/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array of objects that provides details about a change to a finding, including the Amazon Web Services Security
 * Finding Format (ASFF) field that changed, the value of the field before the change, and the value of the field after
 * the change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingHistoryUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<FindingHistoryUpdate.Builder, FindingHistoryUpdate> {
    private static final SdkField<String> UPDATED_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdatedField").getter(getter(FindingHistoryUpdate::updatedField)).setter(setter(Builder::updatedField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedField").build()).build();

    private static final SdkField<String> OLD_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OldValue").getter(getter(FindingHistoryUpdate::oldValue)).setter(setter(Builder::oldValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OldValue").build()).build();

    private static final SdkField<String> NEW_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewValue").getter(getter(FindingHistoryUpdate::newValue)).setter(setter(Builder::newValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATED_FIELD_FIELD,
            OLD_VALUE_FIELD, NEW_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String updatedField;

    private final String oldValue;

    private final String newValue;

    private FindingHistoryUpdate(BuilderImpl builder) {
        this.updatedField = builder.updatedField;
        this.oldValue = builder.oldValue;
        this.newValue = builder.newValue;
    }

    /**
     * <p>
     * The ASFF field that changed during the finding change event.
     * </p>
     * 
     * @return The ASFF field that changed during the finding change event.
     */
    public final String updatedField() {
        return updatedField;
    }

    /**
     * <p>
     * The value of the ASFF field before the finding change event.
     * </p>
     * 
     * @return The value of the ASFF field before the finding change event.
     */
    public final String oldValue() {
        return oldValue;
    }

    /**
     * <p>
     * The value of the ASFF field after the finding change event. To preserve storage and readability, Security Hub
     * omits this value if <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_FindingHistoryRecord.html">
     * <code>FindingHistoryRecord</code> </a> exceeds database limits.
     * </p>
     * 
     * @return The value of the ASFF field after the finding change event. To preserve storage and readability, Security
     *         Hub omits this value if <a
     *         href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_FindingHistoryRecord.html">
     *         <code>FindingHistoryRecord</code> </a> exceeds database limits.
     */
    public final String newValue() {
        return newValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(updatedField());
        hashCode = 31 * hashCode + Objects.hashCode(oldValue());
        hashCode = 31 * hashCode + Objects.hashCode(newValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingHistoryUpdate)) {
            return false;
        }
        FindingHistoryUpdate other = (FindingHistoryUpdate) obj;
        return Objects.equals(updatedField(), other.updatedField()) && Objects.equals(oldValue(), other.oldValue())
                && Objects.equals(newValue(), other.newValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingHistoryUpdate").add("UpdatedField", updatedField()).add("OldValue", oldValue())
                .add("NewValue", newValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdatedField":
            return Optional.ofNullable(clazz.cast(updatedField()));
        case "OldValue":
            return Optional.ofNullable(clazz.cast(oldValue()));
        case "NewValue":
            return Optional.ofNullable(clazz.cast(newValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindingHistoryUpdate, T> g) {
        return obj -> g.apply((FindingHistoryUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingHistoryUpdate> {
        /**
         * <p>
         * The ASFF field that changed during the finding change event.
         * </p>
         * 
         * @param updatedField
         *        The ASFF field that changed during the finding change event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedField(String updatedField);

        /**
         * <p>
         * The value of the ASFF field before the finding change event.
         * </p>
         * 
         * @param oldValue
         *        The value of the ASFF field before the finding change event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oldValue(String oldValue);

        /**
         * <p>
         * The value of the ASFF field after the finding change event. To preserve storage and readability, Security Hub
         * omits this value if <a
         * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_FindingHistoryRecord.html">
         * <code>FindingHistoryRecord</code> </a> exceeds database limits.
         * </p>
         * 
         * @param newValue
         *        The value of the ASFF field after the finding change event. To preserve storage and readability,
         *        Security Hub omits this value if <a
         *        href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_FindingHistoryRecord.html">
         *        <code>FindingHistoryRecord</code> </a> exceeds database limits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newValue(String newValue);
    }

    static final class BuilderImpl implements Builder {
        private String updatedField;

        private String oldValue;

        private String newValue;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingHistoryUpdate model) {
            updatedField(model.updatedField);
            oldValue(model.oldValue);
            newValue(model.newValue);
        }

        public final String getUpdatedField() {
            return updatedField;
        }

        public final void setUpdatedField(String updatedField) {
            this.updatedField = updatedField;
        }

        @Override
        public final Builder updatedField(String updatedField) {
            this.updatedField = updatedField;
            return this;
        }

        public final String getOldValue() {
            return oldValue;
        }

        public final void setOldValue(String oldValue) {
            this.oldValue = oldValue;
        }

        @Override
        public final Builder oldValue(String oldValue) {
            this.oldValue = oldValue;
            return this;
        }

        public final String getNewValue() {
            return newValue;
        }

        public final void setNewValue(String newValue) {
            this.newValue = newValue;
        }

        @Override
        public final Builder newValue(String newValue) {
            this.newValue = newValue;
            return this;
        }

        @Override
        public FindingHistoryUpdate build() {
            return new FindingHistoryUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
