/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateStandardsControlAssociationsResponse extends SecurityHubResponse
        implements
        ToCopyableBuilder<BatchUpdateStandardsControlAssociationsResponse.Builder, BatchUpdateStandardsControlAssociationsResponse> {
    private static final SdkField<List<UnprocessedStandardsControlAssociationUpdate>> UNPROCESSED_ASSOCIATION_UPDATES_FIELD = SdkField
            .<List<UnprocessedStandardsControlAssociationUpdate>> builder(MarshallingType.LIST)
            .memberName("UnprocessedAssociationUpdates")
            .getter(getter(BatchUpdateStandardsControlAssociationsResponse::unprocessedAssociationUpdates))
            .setter(setter(Builder::unprocessedAssociationUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedAssociationUpdates")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedStandardsControlAssociationUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedStandardsControlAssociationUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(UNPROCESSED_ASSOCIATION_UPDATES_FIELD));

    private final List<UnprocessedStandardsControlAssociationUpdate> unprocessedAssociationUpdates;

    private BatchUpdateStandardsControlAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.unprocessedAssociationUpdates = builder.unprocessedAssociationUpdates;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedAssociationUpdates property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUnprocessedAssociationUpdates() {
        return unprocessedAssociationUpdates != null && !(unprocessedAssociationUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of
     * both parameters) whose enablement status in a specified standard couldn't be updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedAssociationUpdates} method.
     * </p>
     * 
     * @return A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a
     *         mix of both parameters) whose enablement status in a specified standard couldn't be updated.
     */
    public final List<UnprocessedStandardsControlAssociationUpdate> unprocessedAssociationUpdates() {
        return unprocessedAssociationUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedAssociationUpdates() ? unprocessedAssociationUpdates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateStandardsControlAssociationsResponse)) {
            return false;
        }
        BatchUpdateStandardsControlAssociationsResponse other = (BatchUpdateStandardsControlAssociationsResponse) obj;
        return hasUnprocessedAssociationUpdates() == other.hasUnprocessedAssociationUpdates()
                && Objects.equals(unprocessedAssociationUpdates(), other.unprocessedAssociationUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("BatchUpdateStandardsControlAssociationsResponse")
                .add("UnprocessedAssociationUpdates", hasUnprocessedAssociationUpdates() ? unprocessedAssociationUpdates() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UnprocessedAssociationUpdates":
            return Optional.ofNullable(clazz.cast(unprocessedAssociationUpdates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateStandardsControlAssociationsResponse, T> g) {
        return obj -> g.apply((BatchUpdateStandardsControlAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateStandardsControlAssociationsResponse> {
        /**
         * <p>
         * A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix
         * of both parameters) whose enablement status in a specified standard couldn't be updated.
         * </p>
         * 
         * @param unprocessedAssociationUpdates
         *        A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>,
         *        or a mix of both parameters) whose enablement status in a specified standard couldn't be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAssociationUpdates(
                Collection<UnprocessedStandardsControlAssociationUpdate> unprocessedAssociationUpdates);

        /**
         * <p>
         * A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix
         * of both parameters) whose enablement status in a specified standard couldn't be updated.
         * </p>
         * 
         * @param unprocessedAssociationUpdates
         *        A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>,
         *        or a mix of both parameters) whose enablement status in a specified standard couldn't be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAssociationUpdates(UnprocessedStandardsControlAssociationUpdate... unprocessedAssociationUpdates);

        /**
         * <p>
         * A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix
         * of both parameters) whose enablement status in a specified standard couldn't be updated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociationUpdate.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociationUpdate#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociationUpdate.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #unprocessedAssociationUpdates(List<UnprocessedStandardsControlAssociationUpdate>)}.
         * 
         * @param unprocessedAssociationUpdates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedAssociationUpdates(java.util.Collection<UnprocessedStandardsControlAssociationUpdate>)
         */
        Builder unprocessedAssociationUpdates(
                Consumer<UnprocessedStandardsControlAssociationUpdate.Builder>... unprocessedAssociationUpdates);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<UnprocessedStandardsControlAssociationUpdate> unprocessedAssociationUpdates = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateStandardsControlAssociationsResponse model) {
            super(model);
            unprocessedAssociationUpdates(model.unprocessedAssociationUpdates);
        }

        public final List<UnprocessedStandardsControlAssociationUpdate.Builder> getUnprocessedAssociationUpdates() {
            List<UnprocessedStandardsControlAssociationUpdate.Builder> result = UnprocessedStandardsControlAssociationUpdatesCopier
                    .copyToBuilder(this.unprocessedAssociationUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedAssociationUpdates(
                Collection<UnprocessedStandardsControlAssociationUpdate.BuilderImpl> unprocessedAssociationUpdates) {
            this.unprocessedAssociationUpdates = UnprocessedStandardsControlAssociationUpdatesCopier
                    .copyFromBuilder(unprocessedAssociationUpdates);
        }

        @Override
        public final Builder unprocessedAssociationUpdates(
                Collection<UnprocessedStandardsControlAssociationUpdate> unprocessedAssociationUpdates) {
            this.unprocessedAssociationUpdates = UnprocessedStandardsControlAssociationUpdatesCopier
                    .copy(unprocessedAssociationUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAssociationUpdates(
                UnprocessedStandardsControlAssociationUpdate... unprocessedAssociationUpdates) {
            unprocessedAssociationUpdates(Arrays.asList(unprocessedAssociationUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAssociationUpdates(
                Consumer<UnprocessedStandardsControlAssociationUpdate.Builder>... unprocessedAssociationUpdates) {
            unprocessedAssociationUpdates(Stream.of(unprocessedAssociationUpdates)
                    .map(c -> UnprocessedStandardsControlAssociationUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateStandardsControlAssociationsResponse build() {
            return new BatchUpdateStandardsControlAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
