/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array of objects that describes where your execution history events will be logged.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails.Builder, AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails> {
    private static final SdkField<AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails> CLOUD_WATCH_LOGS_LOG_GROUP_FIELD = SdkField
            .<AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails> builder(
                    MarshallingType.SDK_POJO).memberName("CloudWatchLogsLogGroup")
            .getter(getter(AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails::cloudWatchLogsLogGroup))
            .setter(setter(Builder::cloudWatchLogsLogGroup))
            .constructor(AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsLogGroup").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CLOUD_WATCH_LOGS_LOG_GROUP_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails cloudWatchLogsLogGroup;

    private AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails(BuilderImpl builder) {
        this.cloudWatchLogsLogGroup = builder.cloudWatchLogsLogGroup;
    }

    /**
     * <p>
     * An object describing a CloudWatch Logs log group. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html"> Amazon Web
     * Services::Logs::LogGroup</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * 
     * @return An object describing a CloudWatch Logs log group. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html">
     *         Amazon Web Services::Logs::LogGroup</a> in the <i>CloudFormation User Guide</i>.
     */
    public final AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails cloudWatchLogsLogGroup() {
        return cloudWatchLogsLogGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsLogGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails)) {
            return false;
        }
        AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails other = (AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails) obj;
        return Objects.equals(cloudWatchLogsLogGroup(), other.cloudWatchLogsLogGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails")
                .add("CloudWatchLogsLogGroup", cloudWatchLogsLogGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchLogsLogGroup":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsLogGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(
            Function<AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails, T> g) {
        return obj -> g.apply((AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails> {
        /**
         * <p>
         * An object describing a CloudWatch Logs log group. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html"> Amazon
         * Web Services::Logs::LogGroup</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * 
         * @param cloudWatchLogsLogGroup
         *        An object describing a CloudWatch Logs log group. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html">
         *        Amazon Web Services::Logs::LogGroup</a> in the <i>CloudFormation User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsLogGroup(
                AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails cloudWatchLogsLogGroup);

        /**
         * <p>
         * An object describing a CloudWatch Logs log group. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html"> Amazon
         * Web Services::Logs::LogGroup</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails.Builder}
         * avoiding the need to create one manually via
         * {@link AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #cloudWatchLogsLogGroup(AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails)}.
         * 
         * @param cloudWatchLogsLogGroup
         *        a consumer that will call methods on
         *        {@link AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogsLogGroup(AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails)
         */
        default Builder cloudWatchLogsLogGroup(
                Consumer<AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails.Builder> cloudWatchLogsLogGroup) {
            return cloudWatchLogsLogGroup(AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails
                    .builder().applyMutation(cloudWatchLogsLogGroup).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails cloudWatchLogsLogGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails model) {
            cloudWatchLogsLogGroup(model.cloudWatchLogsLogGroup);
        }

        public final AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails.Builder getCloudWatchLogsLogGroup() {
            return cloudWatchLogsLogGroup != null ? cloudWatchLogsLogGroup.toBuilder() : null;
        }

        public final void setCloudWatchLogsLogGroup(
                AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails.BuilderImpl cloudWatchLogsLogGroup) {
            this.cloudWatchLogsLogGroup = cloudWatchLogsLogGroup != null ? cloudWatchLogsLogGroup.build() : null;
        }

        @Override
        public final Builder cloudWatchLogsLogGroup(
                AwsStepFunctionStateMachineLoggingConfigurationDestinationsCloudWatchLogsLogGroupDetails cloudWatchLogsLogGroup) {
            this.cloudWatchLogsLogGroup = cloudWatchLogsLogGroup;
            return this;
        }

        @Override
        public AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails build() {
            return new AwsStepFunctionStateMachineLoggingConfigurationDestinationsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
