/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for an Amazon S3 filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketNotificationConfigurationS3KeyFilter
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsS3BucketNotificationConfigurationS3KeyFilter.Builder, AwsS3BucketNotificationConfigurationS3KeyFilter> {
    private static final SdkField<List<AwsS3BucketNotificationConfigurationS3KeyFilterRule>> FILTER_RULES_FIELD = SdkField
            .<List<AwsS3BucketNotificationConfigurationS3KeyFilterRule>> builder(MarshallingType.LIST)
            .memberName("FilterRules")
            .getter(getter(AwsS3BucketNotificationConfigurationS3KeyFilter::filterRules))
            .setter(setter(Builder::filterRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsS3BucketNotificationConfigurationS3KeyFilterRule> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsS3BucketNotificationConfigurationS3KeyFilterRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_RULES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AwsS3BucketNotificationConfigurationS3KeyFilterRule> filterRules;

    private AwsS3BucketNotificationConfigurationS3KeyFilter(BuilderImpl builder) {
        this.filterRules = builder.filterRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilterRules() {
        return filterRules != null && !(filterRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter rules for the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterRules} method.
     * </p>
     * 
     * @return The filter rules for the filter.
     */
    public final List<AwsS3BucketNotificationConfigurationS3KeyFilterRule> filterRules() {
        return filterRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterRules() ? filterRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketNotificationConfigurationS3KeyFilter)) {
            return false;
        }
        AwsS3BucketNotificationConfigurationS3KeyFilter other = (AwsS3BucketNotificationConfigurationS3KeyFilter) obj;
        return hasFilterRules() == other.hasFilterRules() && Objects.equals(filterRules(), other.filterRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketNotificationConfigurationS3KeyFilter")
                .add("FilterRules", hasFilterRules() ? filterRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterRules":
            return Optional.ofNullable(clazz.cast(filterRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketNotificationConfigurationS3KeyFilter, T> g) {
        return obj -> g.apply((AwsS3BucketNotificationConfigurationS3KeyFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3BucketNotificationConfigurationS3KeyFilter> {
        /**
         * <p>
         * The filter rules for the filter.
         * </p>
         * 
         * @param filterRules
         *        The filter rules for the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterRules(Collection<AwsS3BucketNotificationConfigurationS3KeyFilterRule> filterRules);

        /**
         * <p>
         * The filter rules for the filter.
         * </p>
         * 
         * @param filterRules
         *        The filter rules for the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterRules(AwsS3BucketNotificationConfigurationS3KeyFilterRule... filterRules);

        /**
         * <p>
         * The filter rules for the filter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #filterRules(List<AwsS3BucketNotificationConfigurationS3KeyFilterRule>)}.
         * 
         * @param filterRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterRules(java.util.Collection<AwsS3BucketNotificationConfigurationS3KeyFilterRule>)
         */
        Builder filterRules(Consumer<AwsS3BucketNotificationConfigurationS3KeyFilterRule.Builder>... filterRules);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsS3BucketNotificationConfigurationS3KeyFilterRule> filterRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketNotificationConfigurationS3KeyFilter model) {
            filterRules(model.filterRules);
        }

        public final List<AwsS3BucketNotificationConfigurationS3KeyFilterRule.Builder> getFilterRules() {
            List<AwsS3BucketNotificationConfigurationS3KeyFilterRule.Builder> result = AwsS3BucketNotificationConfigurationS3KeyFilterRulesCopier
                    .copyToBuilder(this.filterRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterRules(Collection<AwsS3BucketNotificationConfigurationS3KeyFilterRule.BuilderImpl> filterRules) {
            this.filterRules = AwsS3BucketNotificationConfigurationS3KeyFilterRulesCopier.copyFromBuilder(filterRules);
        }

        @Override
        public final Builder filterRules(Collection<AwsS3BucketNotificationConfigurationS3KeyFilterRule> filterRules) {
            this.filterRules = AwsS3BucketNotificationConfigurationS3KeyFilterRulesCopier.copy(filterRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterRules(AwsS3BucketNotificationConfigurationS3KeyFilterRule... filterRules) {
            filterRules(Arrays.asList(filterRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterRules(Consumer<AwsS3BucketNotificationConfigurationS3KeyFilterRule.Builder>... filterRules) {
            filterRules(Stream.of(filterRules)
                    .map(c -> AwsS3BucketNotificationConfigurationS3KeyFilterRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsS3BucketNotificationConfigurationS3KeyFilter build() {
            return new AwsS3BucketNotificationConfigurationS3KeyFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
