/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A node in an Amazon Redshift cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRedshiftClusterClusterNode implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRedshiftClusterClusterNode.Builder, AwsRedshiftClusterClusterNode> {
    private static final SdkField<String> NODE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeRole").getter(getter(AwsRedshiftClusterClusterNode::nodeRole)).setter(setter(Builder::nodeRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeRole").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateIpAddress").getter(getter(AwsRedshiftClusterClusterNode::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").build()).build();

    private static final SdkField<String> PUBLIC_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicIpAddress").getter(getter(AwsRedshiftClusterClusterNode::publicIpAddress))
            .setter(setter(Builder::publicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_ROLE_FIELD,
            PRIVATE_IP_ADDRESS_FIELD, PUBLIC_IP_ADDRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String nodeRole;

    private final String privateIpAddress;

    private final String publicIpAddress;

    private AwsRedshiftClusterClusterNode(BuilderImpl builder) {
        this.nodeRole = builder.nodeRole;
        this.privateIpAddress = builder.privateIpAddress;
        this.publicIpAddress = builder.publicIpAddress;
    }

    /**
     * <p>
     * The role of the node. A node might be a leader node or a compute node.
     * </p>
     * 
     * @return The role of the node. A node might be a leader node or a compute node.
     */
    public final String nodeRole() {
        return nodeRole;
    }

    /**
     * <p>
     * The private IP address of the node.
     * </p>
     * 
     * @return The private IP address of the node.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * The public IP address of the node.
     * </p>
     * 
     * @return The public IP address of the node.
     */
    public final String publicIpAddress() {
        return publicIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeRole());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(publicIpAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRedshiftClusterClusterNode)) {
            return false;
        }
        AwsRedshiftClusterClusterNode other = (AwsRedshiftClusterClusterNode) obj;
        return Objects.equals(nodeRole(), other.nodeRole()) && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && Objects.equals(publicIpAddress(), other.publicIpAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRedshiftClusterClusterNode").add("NodeRole", nodeRole())
                .add("PrivateIpAddress", privateIpAddress()).add("PublicIpAddress", publicIpAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NodeRole":
            return Optional.ofNullable(clazz.cast(nodeRole()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "PublicIpAddress":
            return Optional.ofNullable(clazz.cast(publicIpAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRedshiftClusterClusterNode, T> g) {
        return obj -> g.apply((AwsRedshiftClusterClusterNode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRedshiftClusterClusterNode> {
        /**
         * <p>
         * The role of the node. A node might be a leader node or a compute node.
         * </p>
         * 
         * @param nodeRole
         *        The role of the node. A node might be a leader node or a compute node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeRole(String nodeRole);

        /**
         * <p>
         * The private IP address of the node.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IP address of the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * The public IP address of the node.
         * </p>
         * 
         * @param publicIpAddress
         *        The public IP address of the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpAddress(String publicIpAddress);
    }

    static final class BuilderImpl implements Builder {
        private String nodeRole;

        private String privateIpAddress;

        private String publicIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRedshiftClusterClusterNode model) {
            nodeRole(model.nodeRole);
            privateIpAddress(model.privateIpAddress);
            publicIpAddress(model.publicIpAddress);
        }

        public final String getNodeRole() {
            return nodeRole;
        }

        public final void setNodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
        }

        @Override
        public final Builder nodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
            return this;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final String getPublicIpAddress() {
            return publicIpAddress;
        }

        public final void setPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
        }

        @Override
        public final Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        @Override
        public AwsRedshiftClusterClusterNode build() {
            return new AwsRedshiftClusterClusterNode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
