/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies information about the master user of the domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsOpenSearchServiceDomainMasterUserOptionsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsOpenSearchServiceDomainMasterUserOptionsDetails.Builder, AwsOpenSearchServiceDomainMasterUserOptionsDetails> {
    private static final SdkField<String> MASTER_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserArn").getter(getter(AwsOpenSearchServiceDomainMasterUserOptionsDetails::masterUserArn))
            .setter(setter(Builder::masterUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserArn").build()).build();

    private static final SdkField<String> MASTER_USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserName").getter(getter(AwsOpenSearchServiceDomainMasterUserOptionsDetails::masterUserName))
            .setter(setter(Builder::masterUserName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserName").build()).build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserPassword")
            .getter(getter(AwsOpenSearchServiceDomainMasterUserOptionsDetails::masterUserPassword))
            .setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MASTER_USER_ARN_FIELD,
            MASTER_USER_NAME_FIELD, MASTER_USER_PASSWORD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String masterUserArn;

    private final String masterUserName;

    private final String masterUserPassword;

    private AwsOpenSearchServiceDomainMasterUserOptionsDetails(BuilderImpl builder) {
        this.masterUserArn = builder.masterUserArn;
        this.masterUserName = builder.masterUserName;
        this.masterUserPassword = builder.masterUserPassword;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the master user.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the master user.
     */
    public final String masterUserArn() {
        return masterUserArn;
    }

    /**
     * <p>
     * The username for the master user.
     * </p>
     * 
     * @return The username for the master user.
     */
    public final String masterUserName() {
        return masterUserName;
    }

    /**
     * <p>
     * The password for the master user.
     * </p>
     * 
     * @return The password for the master user.
     */
    public final String masterUserPassword() {
        return masterUserPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(masterUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserName());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsOpenSearchServiceDomainMasterUserOptionsDetails)) {
            return false;
        }
        AwsOpenSearchServiceDomainMasterUserOptionsDetails other = (AwsOpenSearchServiceDomainMasterUserOptionsDetails) obj;
        return Objects.equals(masterUserArn(), other.masterUserArn()) && Objects.equals(masterUserName(), other.masterUserName())
                && Objects.equals(masterUserPassword(), other.masterUserPassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsOpenSearchServiceDomainMasterUserOptionsDetails").add("MasterUserArn", masterUserArn())
                .add("MasterUserName", masterUserName()).add("MasterUserPassword", masterUserPassword()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MasterUserArn":
            return Optional.ofNullable(clazz.cast(masterUserArn()));
        case "MasterUserName":
            return Optional.ofNullable(clazz.cast(masterUserName()));
        case "MasterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsOpenSearchServiceDomainMasterUserOptionsDetails, T> g) {
        return obj -> g.apply((AwsOpenSearchServiceDomainMasterUserOptionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsOpenSearchServiceDomainMasterUserOptionsDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the master user.
         * </p>
         * 
         * @param masterUserArn
         *        The Amazon Resource Name (ARN) for the master user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserArn(String masterUserArn);

        /**
         * <p>
         * The username for the master user.
         * </p>
         * 
         * @param masterUserName
         *        The username for the master user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserName(String masterUserName);

        /**
         * <p>
         * The password for the master user.
         * </p>
         * 
         * @param masterUserPassword
         *        The password for the master user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);
    }

    static final class BuilderImpl implements Builder {
        private String masterUserArn;

        private String masterUserName;

        private String masterUserPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsOpenSearchServiceDomainMasterUserOptionsDetails model) {
            masterUserArn(model.masterUserArn);
            masterUserName(model.masterUserName);
            masterUserPassword(model.masterUserPassword);
        }

        public final String getMasterUserArn() {
            return masterUserArn;
        }

        public final void setMasterUserArn(String masterUserArn) {
            this.masterUserArn = masterUserArn;
        }

        @Override
        public final Builder masterUserArn(String masterUserArn) {
            this.masterUserArn = masterUserArn;
            return this;
        }

        public final String getMasterUserName() {
            return masterUserName;
        }

        public final void setMasterUserName(String masterUserName) {
            this.masterUserName = masterUserName;
        }

        @Override
        public final Builder masterUserName(String masterUserName) {
            this.masterUserName = masterUserName;
            return this;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        @Override
        public AwsOpenSearchServiceDomainMasterUserOptionsDetails build() {
            return new AwsOpenSearchServiceDomainMasterUserOptionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
