/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about additional options for the domain endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsOpenSearchServiceDomainDomainEndpointOptionsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.Builder, AwsOpenSearchServiceDomainDomainEndpointOptionsDetails> {
    private static final SdkField<String> CUSTOM_ENDPOINT_CERTIFICATE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomEndpointCertificateArn")
            .getter(getter(AwsOpenSearchServiceDomainDomainEndpointOptionsDetails::customEndpointCertificateArn))
            .setter(setter(Builder::customEndpointCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEndpointCertificateArn")
                    .build()).build();

    private static final SdkField<Boolean> CUSTOM_ENDPOINT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CustomEndpointEnabled")
            .getter(getter(AwsOpenSearchServiceDomainDomainEndpointOptionsDetails::customEndpointEnabled))
            .setter(setter(Builder::customEndpointEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEndpointEnabled").build())
            .build();

    private static final SdkField<Boolean> ENFORCE_HTTPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnforceHTTPS").getter(getter(AwsOpenSearchServiceDomainDomainEndpointOptionsDetails::enforceHTTPS))
            .setter(setter(Builder::enforceHTTPS))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforceHTTPS").build()).build();

    private static final SdkField<String> CUSTOM_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomEndpoint").getter(getter(AwsOpenSearchServiceDomainDomainEndpointOptionsDetails::customEndpoint))
            .setter(setter(Builder::customEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEndpoint").build()).build();

    private static final SdkField<String> TLS_SECURITY_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TLSSecurityPolicy")
            .getter(getter(AwsOpenSearchServiceDomainDomainEndpointOptionsDetails::tlsSecurityPolicy))
            .setter(setter(Builder::tlsSecurityPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSSecurityPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_ENDPOINT_CERTIFICATE_ARN_FIELD, CUSTOM_ENDPOINT_ENABLED_FIELD, ENFORCE_HTTPS_FIELD, CUSTOM_ENDPOINT_FIELD,
            TLS_SECURITY_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String customEndpointCertificateArn;

    private final Boolean customEndpointEnabled;

    private final Boolean enforceHTTPS;

    private final String customEndpoint;

    private final String tlsSecurityPolicy;

    private AwsOpenSearchServiceDomainDomainEndpointOptionsDetails(BuilderImpl builder) {
        this.customEndpointCertificateArn = builder.customEndpointCertificateArn;
        this.customEndpointEnabled = builder.customEndpointEnabled;
        this.enforceHTTPS = builder.enforceHTTPS;
        this.customEndpoint = builder.customEndpoint;
        this.tlsSecurityPolicy = builder.tlsSecurityPolicy;
    }

    /**
     * <p>
     * The ARN for the security certificate. The certificate is managed in ACM.
     * </p>
     * 
     * @return The ARN for the security certificate. The certificate is managed in ACM.
     */
    public final String customEndpointCertificateArn() {
        return customEndpointCertificateArn;
    }

    /**
     * <p>
     * Whether to enable a custom endpoint for the domain.
     * </p>
     * 
     * @return Whether to enable a custom endpoint for the domain.
     */
    public final Boolean customEndpointEnabled() {
        return customEndpointEnabled;
    }

    /**
     * <p>
     * Whether to require that all traffic to the domain arrive over HTTPS.
     * </p>
     * 
     * @return Whether to require that all traffic to the domain arrive over HTTPS.
     */
    public final Boolean enforceHTTPS() {
        return enforceHTTPS;
    }

    /**
     * <p>
     * The fully qualified URL for the custom endpoint.
     * </p>
     * 
     * @return The fully qualified URL for the custom endpoint.
     */
    public final String customEndpoint() {
        return customEndpoint;
    }

    /**
     * <p>
     * The TLS security policy to apply to the HTTPS endpoint of the OpenSearch domain.
     * </p>
     * 
     * @return The TLS security policy to apply to the HTTPS endpoint of the OpenSearch domain.
     */
    public final String tlsSecurityPolicy() {
        return tlsSecurityPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customEndpointCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(customEndpointEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(enforceHTTPS());
        hashCode = 31 * hashCode + Objects.hashCode(customEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(tlsSecurityPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsOpenSearchServiceDomainDomainEndpointOptionsDetails)) {
            return false;
        }
        AwsOpenSearchServiceDomainDomainEndpointOptionsDetails other = (AwsOpenSearchServiceDomainDomainEndpointOptionsDetails) obj;
        return Objects.equals(customEndpointCertificateArn(), other.customEndpointCertificateArn())
                && Objects.equals(customEndpointEnabled(), other.customEndpointEnabled())
                && Objects.equals(enforceHTTPS(), other.enforceHTTPS())
                && Objects.equals(customEndpoint(), other.customEndpoint())
                && Objects.equals(tlsSecurityPolicy(), other.tlsSecurityPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsOpenSearchServiceDomainDomainEndpointOptionsDetails")
                .add("CustomEndpointCertificateArn", customEndpointCertificateArn())
                .add("CustomEndpointEnabled", customEndpointEnabled()).add("EnforceHTTPS", enforceHTTPS())
                .add("CustomEndpoint", customEndpoint()).add("TLSSecurityPolicy", tlsSecurityPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomEndpointCertificateArn":
            return Optional.ofNullable(clazz.cast(customEndpointCertificateArn()));
        case "CustomEndpointEnabled":
            return Optional.ofNullable(clazz.cast(customEndpointEnabled()));
        case "EnforceHTTPS":
            return Optional.ofNullable(clazz.cast(enforceHTTPS()));
        case "CustomEndpoint":
            return Optional.ofNullable(clazz.cast(customEndpoint()));
        case "TLSSecurityPolicy":
            return Optional.ofNullable(clazz.cast(tlsSecurityPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsOpenSearchServiceDomainDomainEndpointOptionsDetails, T> g) {
        return obj -> g.apply((AwsOpenSearchServiceDomainDomainEndpointOptionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsOpenSearchServiceDomainDomainEndpointOptionsDetails> {
        /**
         * <p>
         * The ARN for the security certificate. The certificate is managed in ACM.
         * </p>
         * 
         * @param customEndpointCertificateArn
         *        The ARN for the security certificate. The certificate is managed in ACM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEndpointCertificateArn(String customEndpointCertificateArn);

        /**
         * <p>
         * Whether to enable a custom endpoint for the domain.
         * </p>
         * 
         * @param customEndpointEnabled
         *        Whether to enable a custom endpoint for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEndpointEnabled(Boolean customEndpointEnabled);

        /**
         * <p>
         * Whether to require that all traffic to the domain arrive over HTTPS.
         * </p>
         * 
         * @param enforceHTTPS
         *        Whether to require that all traffic to the domain arrive over HTTPS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enforceHTTPS(Boolean enforceHTTPS);

        /**
         * <p>
         * The fully qualified URL for the custom endpoint.
         * </p>
         * 
         * @param customEndpoint
         *        The fully qualified URL for the custom endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEndpoint(String customEndpoint);

        /**
         * <p>
         * The TLS security policy to apply to the HTTPS endpoint of the OpenSearch domain.
         * </p>
         * 
         * @param tlsSecurityPolicy
         *        The TLS security policy to apply to the HTTPS endpoint of the OpenSearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsSecurityPolicy(String tlsSecurityPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String customEndpointCertificateArn;

        private Boolean customEndpointEnabled;

        private Boolean enforceHTTPS;

        private String customEndpoint;

        private String tlsSecurityPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsOpenSearchServiceDomainDomainEndpointOptionsDetails model) {
            customEndpointCertificateArn(model.customEndpointCertificateArn);
            customEndpointEnabled(model.customEndpointEnabled);
            enforceHTTPS(model.enforceHTTPS);
            customEndpoint(model.customEndpoint);
            tlsSecurityPolicy(model.tlsSecurityPolicy);
        }

        public final String getCustomEndpointCertificateArn() {
            return customEndpointCertificateArn;
        }

        public final void setCustomEndpointCertificateArn(String customEndpointCertificateArn) {
            this.customEndpointCertificateArn = customEndpointCertificateArn;
        }

        @Override
        public final Builder customEndpointCertificateArn(String customEndpointCertificateArn) {
            this.customEndpointCertificateArn = customEndpointCertificateArn;
            return this;
        }

        public final Boolean getCustomEndpointEnabled() {
            return customEndpointEnabled;
        }

        public final void setCustomEndpointEnabled(Boolean customEndpointEnabled) {
            this.customEndpointEnabled = customEndpointEnabled;
        }

        @Override
        public final Builder customEndpointEnabled(Boolean customEndpointEnabled) {
            this.customEndpointEnabled = customEndpointEnabled;
            return this;
        }

        public final Boolean getEnforceHTTPS() {
            return enforceHTTPS;
        }

        public final void setEnforceHTTPS(Boolean enforceHTTPS) {
            this.enforceHTTPS = enforceHTTPS;
        }

        @Override
        public final Builder enforceHTTPS(Boolean enforceHTTPS) {
            this.enforceHTTPS = enforceHTTPS;
            return this;
        }

        public final String getCustomEndpoint() {
            return customEndpoint;
        }

        public final void setCustomEndpoint(String customEndpoint) {
            this.customEndpoint = customEndpoint;
        }

        @Override
        public final Builder customEndpoint(String customEndpoint) {
            this.customEndpoint = customEndpoint;
            return this;
        }

        public final String getTlsSecurityPolicy() {
            return tlsSecurityPolicy;
        }

        public final void setTlsSecurityPolicy(String tlsSecurityPolicy) {
            this.tlsSecurityPolicy = tlsSecurityPolicy;
        }

        @Override
        public final Builder tlsSecurityPolicy(String tlsSecurityPolicy) {
            this.tlsSecurityPolicy = tlsSecurityPolicy;
            return this;
        }

        @Override
        public AwsOpenSearchServiceDomainDomainEndpointOptionsDetails build() {
            return new AwsOpenSearchServiceDomainDomainEndpointOptionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
