/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The minimum and maximum amount of memory per vCPU, in GiB.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails.Builder, AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails> {
    private static final SdkField<Double> MAX_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Max")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails::max))
            .setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Max").build()).build();

    private static final SdkField<Double> MIN_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Min")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails::min))
            .setter(setter(Builder::min))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Min").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_FIELD, MIN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double max;

    private final Double min;

    private AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails(BuilderImpl builder) {
        this.max = builder.max;
        this.min = builder.min;
    }

    /**
     * <p>
     * The maximum amount of memory per vCPU, in GiB. If this parameter is omitted, there's no maximum limit.
     * </p>
     * 
     * @return The maximum amount of memory per vCPU, in GiB. If this parameter is omitted, there's no maximum limit.
     */
    public final Double max() {
        return max;
    }

    /**
     * <p>
     * The minimum amount of memory per vCPU, in GiB. If this parameter is omitted, there's no maximum limit.
     * </p>
     * 
     * @return The minimum amount of memory per vCPU, in GiB. If this parameter is omitted, there's no maximum limit.
     */
    public final Double min() {
        return min;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(max());
        hashCode = 31 * hashCode + Objects.hashCode(min());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails other = (AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails) obj;
        return Objects.equals(max(), other.max()) && Objects.equals(min(), other.min());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails").add("Max", max())
                .add("Min", min()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Max":
            return Optional.ofNullable(clazz.cast(max()));
        case "Min":
            return Optional.ofNullable(clazz.cast(min()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(
            Function<AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails> {
        /**
         * <p>
         * The maximum amount of memory per vCPU, in GiB. If this parameter is omitted, there's no maximum limit.
         * </p>
         * 
         * @param max
         *        The maximum amount of memory per vCPU, in GiB. If this parameter is omitted, there's no maximum limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(Double max);

        /**
         * <p>
         * The minimum amount of memory per vCPU, in GiB. If this parameter is omitted, there's no maximum limit.
         * </p>
         * 
         * @param min
         *        The minimum amount of memory per vCPU, in GiB. If this parameter is omitted, there's no maximum limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder min(Double min);
    }

    static final class BuilderImpl implements Builder {
        private Double max;

        private Double min;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails model) {
            max(model.max);
            min(model.min);
        }

        public final Double getMax() {
            return max;
        }

        public final void setMax(Double max) {
            this.max = max;
        }

        @Override
        public final Builder max(Double max) {
            this.max = max;
            return this;
        }

        public final Double getMin() {
            return min;
        }

        public final void setMin(Double min) {
            this.min = min;
        }

        @Override
        public final Builder min(Double min) {
            this.min = min;
            return this;
        }

        @Override
        public AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails build() {
            return new AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
