/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information abut a global secondary index for the table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsDynamoDbTableGlobalSecondaryIndex implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsDynamoDbTableGlobalSecondaryIndex.Builder, AwsDynamoDbTableGlobalSecondaryIndex> {
    private static final SdkField<Boolean> BACKFILLING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Backfilling").getter(getter(AwsDynamoDbTableGlobalSecondaryIndex::backfilling))
            .setter(setter(Builder::backfilling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Backfilling").build()).build();

    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexArn").getter(getter(AwsDynamoDbTableGlobalSecondaryIndex::indexArn))
            .setter(setter(Builder::indexArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexArn").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(AwsDynamoDbTableGlobalSecondaryIndex::indexName))
            .setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<Long> INDEX_SIZE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("IndexSizeBytes").getter(getter(AwsDynamoDbTableGlobalSecondaryIndex::indexSizeBytes))
            .setter(setter(Builder::indexSizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexSizeBytes").build()).build();

    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexStatus").getter(getter(AwsDynamoDbTableGlobalSecondaryIndex::indexStatus))
            .setter(setter(Builder::indexStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatus").build()).build();

    private static final SdkField<Integer> ITEM_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ItemCount").getter(getter(AwsDynamoDbTableGlobalSecondaryIndex::itemCount))
            .setter(setter(Builder::itemCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()).build();

    private static final SdkField<List<AwsDynamoDbTableKeySchema>> KEY_SCHEMA_FIELD = SdkField
            .<List<AwsDynamoDbTableKeySchema>> builder(MarshallingType.LIST)
            .memberName("KeySchema")
            .getter(getter(AwsDynamoDbTableGlobalSecondaryIndex::keySchema))
            .setter(setter(Builder::keySchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySchema").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsDynamoDbTableKeySchema> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsDynamoDbTableKeySchema::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsDynamoDbTableProjection> PROJECTION_FIELD = SdkField
            .<AwsDynamoDbTableProjection> builder(MarshallingType.SDK_POJO).memberName("Projection")
            .getter(getter(AwsDynamoDbTableGlobalSecondaryIndex::projection)).setter(setter(Builder::projection))
            .constructor(AwsDynamoDbTableProjection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Projection").build()).build();

    private static final SdkField<AwsDynamoDbTableProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField
            .<AwsDynamoDbTableProvisionedThroughput> builder(MarshallingType.SDK_POJO).memberName("ProvisionedThroughput")
            .getter(getter(AwsDynamoDbTableGlobalSecondaryIndex::provisionedThroughput))
            .setter(setter(Builder::provisionedThroughput)).constructor(AwsDynamoDbTableProvisionedThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughput").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKFILLING_FIELD,
            INDEX_ARN_FIELD, INDEX_NAME_FIELD, INDEX_SIZE_BYTES_FIELD, INDEX_STATUS_FIELD, ITEM_COUNT_FIELD, KEY_SCHEMA_FIELD,
            PROJECTION_FIELD, PROVISIONED_THROUGHPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean backfilling;

    private final String indexArn;

    private final String indexName;

    private final Long indexSizeBytes;

    private final String indexStatus;

    private final Integer itemCount;

    private final List<AwsDynamoDbTableKeySchema> keySchema;

    private final AwsDynamoDbTableProjection projection;

    private final AwsDynamoDbTableProvisionedThroughput provisionedThroughput;

    private AwsDynamoDbTableGlobalSecondaryIndex(BuilderImpl builder) {
        this.backfilling = builder.backfilling;
        this.indexArn = builder.indexArn;
        this.indexName = builder.indexName;
        this.indexSizeBytes = builder.indexSizeBytes;
        this.indexStatus = builder.indexStatus;
        this.itemCount = builder.itemCount;
        this.keySchema = builder.keySchema;
        this.projection = builder.projection;
        this.provisionedThroughput = builder.provisionedThroughput;
    }

    /**
     * <p>
     * Whether the index is currently backfilling.
     * </p>
     * 
     * @return Whether the index is currently backfilling.
     */
    public final Boolean backfilling() {
        return backfilling;
    }

    /**
     * <p>
     * The ARN of the index.
     * </p>
     * 
     * @return The ARN of the index.
     */
    public final String indexArn() {
        return indexArn;
    }

    /**
     * <p>
     * The name of the index.
     * </p>
     * 
     * @return The name of the index.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The total size in bytes of the index.
     * </p>
     * 
     * @return The total size in bytes of the index.
     */
    public final Long indexSizeBytes() {
        return indexSizeBytes;
    }

    /**
     * <p>
     * The current status of the index.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATING</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The current status of the index.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATING</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code>
     *         </p>
     *         </li>
     */
    public final String indexStatus() {
        return indexStatus;
    }

    /**
     * <p>
     * The number of items in the index.
     * </p>
     * 
     * @return The number of items in the index.
     */
    public final Integer itemCount() {
        return itemCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeySchema property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasKeySchema() {
        return keySchema != null && !(keySchema instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key schema for the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeySchema} method.
     * </p>
     * 
     * @return The key schema for the index.
     */
    public final List<AwsDynamoDbTableKeySchema> keySchema() {
        return keySchema;
    }

    /**
     * <p>
     * Attributes that are copied from the table into an index.
     * </p>
     * 
     * @return Attributes that are copied from the table into an index.
     */
    public final AwsDynamoDbTableProjection projection() {
        return projection;
    }

    /**
     * <p>
     * Information about the provisioned throughput settings for the indexes.
     * </p>
     * 
     * @return Information about the provisioned throughput settings for the indexes.
     */
    public final AwsDynamoDbTableProvisionedThroughput provisionedThroughput() {
        return provisionedThroughput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backfilling());
        hashCode = 31 * hashCode + Objects.hashCode(indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(indexSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(indexStatus());
        hashCode = 31 * hashCode + Objects.hashCode(itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeySchema() ? keySchema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(projection());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDynamoDbTableGlobalSecondaryIndex)) {
            return false;
        }
        AwsDynamoDbTableGlobalSecondaryIndex other = (AwsDynamoDbTableGlobalSecondaryIndex) obj;
        return Objects.equals(backfilling(), other.backfilling()) && Objects.equals(indexArn(), other.indexArn())
                && Objects.equals(indexName(), other.indexName()) && Objects.equals(indexSizeBytes(), other.indexSizeBytes())
                && Objects.equals(indexStatus(), other.indexStatus()) && Objects.equals(itemCount(), other.itemCount())
                && hasKeySchema() == other.hasKeySchema() && Objects.equals(keySchema(), other.keySchema())
                && Objects.equals(projection(), other.projection())
                && Objects.equals(provisionedThroughput(), other.provisionedThroughput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsDynamoDbTableGlobalSecondaryIndex").add("Backfilling", backfilling())
                .add("IndexArn", indexArn()).add("IndexName", indexName()).add("IndexSizeBytes", indexSizeBytes())
                .add("IndexStatus", indexStatus()).add("ItemCount", itemCount())
                .add("KeySchema", hasKeySchema() ? keySchema() : null).add("Projection", projection())
                .add("ProvisionedThroughput", provisionedThroughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Backfilling":
            return Optional.ofNullable(clazz.cast(backfilling()));
        case "IndexArn":
            return Optional.ofNullable(clazz.cast(indexArn()));
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "IndexSizeBytes":
            return Optional.ofNullable(clazz.cast(indexSizeBytes()));
        case "IndexStatus":
            return Optional.ofNullable(clazz.cast(indexStatus()));
        case "ItemCount":
            return Optional.ofNullable(clazz.cast(itemCount()));
        case "KeySchema":
            return Optional.ofNullable(clazz.cast(keySchema()));
        case "Projection":
            return Optional.ofNullable(clazz.cast(projection()));
        case "ProvisionedThroughput":
            return Optional.ofNullable(clazz.cast(provisionedThroughput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsDynamoDbTableGlobalSecondaryIndex, T> g) {
        return obj -> g.apply((AwsDynamoDbTableGlobalSecondaryIndex) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsDynamoDbTableGlobalSecondaryIndex> {
        /**
         * <p>
         * Whether the index is currently backfilling.
         * </p>
         * 
         * @param backfilling
         *        Whether the index is currently backfilling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backfilling(Boolean backfilling);

        /**
         * <p>
         * The ARN of the index.
         * </p>
         * 
         * @param indexArn
         *        The ARN of the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexArn(String indexArn);

        /**
         * <p>
         * The name of the index.
         * </p>
         * 
         * @param indexName
         *        The name of the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The total size in bytes of the index.
         * </p>
         * 
         * @param indexSizeBytes
         *        The total size in bytes of the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexSizeBytes(Long indexSizeBytes);

        /**
         * <p>
         * The current status of the index.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATING</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param indexStatus
         *        The current status of the index.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATING</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexStatus(String indexStatus);

        /**
         * <p>
         * The number of items in the index.
         * </p>
         * 
         * @param itemCount
         *        The number of items in the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemCount(Integer itemCount);

        /**
         * <p>
         * The key schema for the index.
         * </p>
         * 
         * @param keySchema
         *        The key schema for the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(Collection<AwsDynamoDbTableKeySchema> keySchema);

        /**
         * <p>
         * The key schema for the index.
         * </p>
         * 
         * @param keySchema
         *        The key schema for the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(AwsDynamoDbTableKeySchema... keySchema);

        /**
         * <p>
         * The key schema for the index.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableKeySchema.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableKeySchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableKeySchema.Builder#build()} is called
         * immediately and its result is passed to {@link #keySchema(List<AwsDynamoDbTableKeySchema>)}.
         * 
         * @param keySchema
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableKeySchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keySchema(java.util.Collection<AwsDynamoDbTableKeySchema>)
         */
        Builder keySchema(Consumer<AwsDynamoDbTableKeySchema.Builder>... keySchema);

        /**
         * <p>
         * Attributes that are copied from the table into an index.
         * </p>
         * 
         * @param projection
         *        Attributes that are copied from the table into an index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projection(AwsDynamoDbTableProjection projection);

        /**
         * <p>
         * Attributes that are copied from the table into an index.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsDynamoDbTableProjection.Builder}
         * avoiding the need to create one manually via {@link AwsDynamoDbTableProjection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsDynamoDbTableProjection.Builder#build()} is called immediately
         * and its result is passed to {@link #projection(AwsDynamoDbTableProjection)}.
         * 
         * @param projection
         *        a consumer that will call methods on {@link AwsDynamoDbTableProjection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projection(AwsDynamoDbTableProjection)
         */
        default Builder projection(Consumer<AwsDynamoDbTableProjection.Builder> projection) {
            return projection(AwsDynamoDbTableProjection.builder().applyMutation(projection).build());
        }

        /**
         * <p>
         * Information about the provisioned throughput settings for the indexes.
         * </p>
         * 
         * @param provisionedThroughput
         *        Information about the provisioned throughput settings for the indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughput(AwsDynamoDbTableProvisionedThroughput provisionedThroughput);

        /**
         * <p>
         * Information about the provisioned throughput settings for the indexes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsDynamoDbTableProvisionedThroughput.Builder} avoiding the need to create one manually via
         * {@link AwsDynamoDbTableProvisionedThroughput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsDynamoDbTableProvisionedThroughput.Builder#build()} is called
         * immediately and its result is passed to {@link #provisionedThroughput(AwsDynamoDbTableProvisionedThroughput)}.
         * 
         * @param provisionedThroughput
         *        a consumer that will call methods on {@link AwsDynamoDbTableProvisionedThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughput(AwsDynamoDbTableProvisionedThroughput)
         */
        default Builder provisionedThroughput(Consumer<AwsDynamoDbTableProvisionedThroughput.Builder> provisionedThroughput) {
            return provisionedThroughput(AwsDynamoDbTableProvisionedThroughput.builder().applyMutation(provisionedThroughput)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean backfilling;

        private String indexArn;

        private String indexName;

        private Long indexSizeBytes;

        private String indexStatus;

        private Integer itemCount;

        private List<AwsDynamoDbTableKeySchema> keySchema = DefaultSdkAutoConstructList.getInstance();

        private AwsDynamoDbTableProjection projection;

        private AwsDynamoDbTableProvisionedThroughput provisionedThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDynamoDbTableGlobalSecondaryIndex model) {
            backfilling(model.backfilling);
            indexArn(model.indexArn);
            indexName(model.indexName);
            indexSizeBytes(model.indexSizeBytes);
            indexStatus(model.indexStatus);
            itemCount(model.itemCount);
            keySchema(model.keySchema);
            projection(model.projection);
            provisionedThroughput(model.provisionedThroughput);
        }

        public final Boolean getBackfilling() {
            return backfilling;
        }

        public final void setBackfilling(Boolean backfilling) {
            this.backfilling = backfilling;
        }

        @Override
        public final Builder backfilling(Boolean backfilling) {
            this.backfilling = backfilling;
            return this;
        }

        public final String getIndexArn() {
            return indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final Long getIndexSizeBytes() {
            return indexSizeBytes;
        }

        public final void setIndexSizeBytes(Long indexSizeBytes) {
            this.indexSizeBytes = indexSizeBytes;
        }

        @Override
        public final Builder indexSizeBytes(Long indexSizeBytes) {
            this.indexSizeBytes = indexSizeBytes;
            return this;
        }

        public final String getIndexStatus() {
            return indexStatus;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        public final Integer getItemCount() {
            return itemCount;
        }

        public final void setItemCount(Integer itemCount) {
            this.itemCount = itemCount;
        }

        @Override
        public final Builder itemCount(Integer itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final List<AwsDynamoDbTableKeySchema.Builder> getKeySchema() {
            List<AwsDynamoDbTableKeySchema.Builder> result = AwsDynamoDbTableKeySchemaListCopier.copyToBuilder(this.keySchema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeySchema(Collection<AwsDynamoDbTableKeySchema.BuilderImpl> keySchema) {
            this.keySchema = AwsDynamoDbTableKeySchemaListCopier.copyFromBuilder(keySchema);
        }

        @Override
        public final Builder keySchema(Collection<AwsDynamoDbTableKeySchema> keySchema) {
            this.keySchema = AwsDynamoDbTableKeySchemaListCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(AwsDynamoDbTableKeySchema... keySchema) {
            keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(Consumer<AwsDynamoDbTableKeySchema.Builder>... keySchema) {
            keySchema(Stream.of(keySchema).map(c -> AwsDynamoDbTableKeySchema.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsDynamoDbTableProjection.Builder getProjection() {
            return projection != null ? projection.toBuilder() : null;
        }

        public final void setProjection(AwsDynamoDbTableProjection.BuilderImpl projection) {
            this.projection = projection != null ? projection.build() : null;
        }

        @Override
        public final Builder projection(AwsDynamoDbTableProjection projection) {
            this.projection = projection;
            return this;
        }

        public final AwsDynamoDbTableProvisionedThroughput.Builder getProvisionedThroughput() {
            return provisionedThroughput != null ? provisionedThroughput.toBuilder() : null;
        }

        public final void setProvisionedThroughput(AwsDynamoDbTableProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        @Override
        public final Builder provisionedThroughput(AwsDynamoDbTableProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        @Override
        public AwsDynamoDbTableGlobalSecondaryIndex build() {
            return new AwsDynamoDbTableGlobalSecondaryIndex(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
