/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about an Backup backup plan and an array of <code>BackupRule</code> objects, each of which specifies
 * a backup rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsBackupBackupPlanBackupPlanDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsBackupBackupPlanBackupPlanDetails.Builder, AwsBackupBackupPlanBackupPlanDetails> {
    private static final SdkField<String> BACKUP_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupPlanName").getter(getter(AwsBackupBackupPlanBackupPlanDetails::backupPlanName))
            .setter(setter(Builder::backupPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanName").build()).build();

    private static final SdkField<List<AwsBackupBackupPlanAdvancedBackupSettingsDetails>> ADVANCED_BACKUP_SETTINGS_FIELD = SdkField
            .<List<AwsBackupBackupPlanAdvancedBackupSettingsDetails>> builder(MarshallingType.LIST)
            .memberName("AdvancedBackupSettings")
            .getter(getter(AwsBackupBackupPlanBackupPlanDetails::advancedBackupSettings))
            .setter(setter(Builder::advancedBackupSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedBackupSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsBackupBackupPlanAdvancedBackupSettingsDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsBackupBackupPlanAdvancedBackupSettingsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsBackupBackupPlanRuleDetails>> BACKUP_PLAN_RULE_FIELD = SdkField
            .<List<AwsBackupBackupPlanRuleDetails>> builder(MarshallingType.LIST)
            .memberName("BackupPlanRule")
            .getter(getter(AwsBackupBackupPlanBackupPlanDetails::backupPlanRule))
            .setter(setter(Builder::backupPlanRule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanRule").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsBackupBackupPlanRuleDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsBackupBackupPlanRuleDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_NAME_FIELD,
            ADVANCED_BACKUP_SETTINGS_FIELD, BACKUP_PLAN_RULE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String backupPlanName;

    private final List<AwsBackupBackupPlanAdvancedBackupSettingsDetails> advancedBackupSettings;

    private final List<AwsBackupBackupPlanRuleDetails> backupPlanRule;

    private AwsBackupBackupPlanBackupPlanDetails(BuilderImpl builder) {
        this.backupPlanName = builder.backupPlanName;
        this.advancedBackupSettings = builder.advancedBackupSettings;
        this.backupPlanRule = builder.backupPlanRule;
    }

    /**
     * <p>
     * The display name of a backup plan.
     * </p>
     * 
     * @return The display name of a backup plan.
     */
    public final String backupPlanName() {
        return backupPlanName;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdvancedBackupSettings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdvancedBackupSettings() {
        return advancedBackupSettings != null && !(advancedBackupSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of backup options for each resource type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdvancedBackupSettings} method.
     * </p>
     * 
     * @return A list of backup options for each resource type.
     */
    public final List<AwsBackupBackupPlanAdvancedBackupSettingsDetails> advancedBackupSettings() {
        return advancedBackupSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the BackupPlanRule property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBackupPlanRule() {
        return backupPlanRule != null && !(backupPlanRule instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up a
     * selection of resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBackupPlanRule} method.
     * </p>
     * 
     * @return An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to
     *         back up a selection of resources.
     */
    public final List<AwsBackupBackupPlanRuleDetails> backupPlanRule() {
        return backupPlanRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdvancedBackupSettings() ? advancedBackupSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBackupPlanRule() ? backupPlanRule() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsBackupBackupPlanBackupPlanDetails)) {
            return false;
        }
        AwsBackupBackupPlanBackupPlanDetails other = (AwsBackupBackupPlanBackupPlanDetails) obj;
        return Objects.equals(backupPlanName(), other.backupPlanName())
                && hasAdvancedBackupSettings() == other.hasAdvancedBackupSettings()
                && Objects.equals(advancedBackupSettings(), other.advancedBackupSettings())
                && hasBackupPlanRule() == other.hasBackupPlanRule() && Objects.equals(backupPlanRule(), other.backupPlanRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsBackupBackupPlanBackupPlanDetails").add("BackupPlanName", backupPlanName())
                .add("AdvancedBackupSettings", hasAdvancedBackupSettings() ? advancedBackupSettings() : null)
                .add("BackupPlanRule", hasBackupPlanRule() ? backupPlanRule() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlanName":
            return Optional.ofNullable(clazz.cast(backupPlanName()));
        case "AdvancedBackupSettings":
            return Optional.ofNullable(clazz.cast(advancedBackupSettings()));
        case "BackupPlanRule":
            return Optional.ofNullable(clazz.cast(backupPlanRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsBackupBackupPlanBackupPlanDetails, T> g) {
        return obj -> g.apply((AwsBackupBackupPlanBackupPlanDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsBackupBackupPlanBackupPlanDetails> {
        /**
         * <p>
         * The display name of a backup plan.
         * </p>
         * 
         * @param backupPlanName
         *        The display name of a backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanName(String backupPlanName);

        /**
         * <p>
         * A list of backup options for each resource type.
         * </p>
         * 
         * @param advancedBackupSettings
         *        A list of backup options for each resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedBackupSettings(Collection<AwsBackupBackupPlanAdvancedBackupSettingsDetails> advancedBackupSettings);

        /**
         * <p>
         * A list of backup options for each resource type.
         * </p>
         * 
         * @param advancedBackupSettings
         *        A list of backup options for each resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedBackupSettings(AwsBackupBackupPlanAdvancedBackupSettingsDetails... advancedBackupSettings);

        /**
         * <p>
         * A list of backup options for each resource type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #advancedBackupSettings(List<AwsBackupBackupPlanAdvancedBackupSettingsDetails>)}.
         * 
         * @param advancedBackupSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedBackupSettings(java.util.Collection<AwsBackupBackupPlanAdvancedBackupSettingsDetails>)
         */
        Builder advancedBackupSettings(
                Consumer<AwsBackupBackupPlanAdvancedBackupSettingsDetails.Builder>... advancedBackupSettings);

        /**
         * <p>
         * An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up
         * a selection of resources.
         * </p>
         * 
         * @param backupPlanRule
         *        An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to
         *        back up a selection of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanRule(Collection<AwsBackupBackupPlanRuleDetails> backupPlanRule);

        /**
         * <p>
         * An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up
         * a selection of resources.
         * </p>
         * 
         * @param backupPlanRule
         *        An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to
         *        back up a selection of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanRule(AwsBackupBackupPlanRuleDetails... backupPlanRule);

        /**
         * <p>
         * An array of <code>BackupRule</code> objects, each of which specifies a scheduled task that is used to back up
         * a selection of resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleDetails.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleDetails.Builder#build()} is
         * called immediately and its result is passed to {@link #backupPlanRule(List<AwsBackupBackupPlanRuleDetails>)}.
         * 
         * @param backupPlanRule
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupPlanRule(java.util.Collection<AwsBackupBackupPlanRuleDetails>)
         */
        Builder backupPlanRule(Consumer<AwsBackupBackupPlanRuleDetails.Builder>... backupPlanRule);
    }

    static final class BuilderImpl implements Builder {
        private String backupPlanName;

        private List<AwsBackupBackupPlanAdvancedBackupSettingsDetails> advancedBackupSettings = DefaultSdkAutoConstructList
                .getInstance();

        private List<AwsBackupBackupPlanRuleDetails> backupPlanRule = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsBackupBackupPlanBackupPlanDetails model) {
            backupPlanName(model.backupPlanName);
            advancedBackupSettings(model.advancedBackupSettings);
            backupPlanRule(model.backupPlanRule);
        }

        public final String getBackupPlanName() {
            return backupPlanName;
        }

        public final void setBackupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
        }

        @Override
        public final Builder backupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
            return this;
        }

        public final List<AwsBackupBackupPlanAdvancedBackupSettingsDetails.Builder> getAdvancedBackupSettings() {
            List<AwsBackupBackupPlanAdvancedBackupSettingsDetails.Builder> result = AwsBackupBackupPlanAdvancedBackupSettingsListCopier
                    .copyToBuilder(this.advancedBackupSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdvancedBackupSettings(
                Collection<AwsBackupBackupPlanAdvancedBackupSettingsDetails.BuilderImpl> advancedBackupSettings) {
            this.advancedBackupSettings = AwsBackupBackupPlanAdvancedBackupSettingsListCopier
                    .copyFromBuilder(advancedBackupSettings);
        }

        @Override
        public final Builder advancedBackupSettings(
                Collection<AwsBackupBackupPlanAdvancedBackupSettingsDetails> advancedBackupSettings) {
            this.advancedBackupSettings = AwsBackupBackupPlanAdvancedBackupSettingsListCopier.copy(advancedBackupSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedBackupSettings(AwsBackupBackupPlanAdvancedBackupSettingsDetails... advancedBackupSettings) {
            advancedBackupSettings(Arrays.asList(advancedBackupSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedBackupSettings(
                Consumer<AwsBackupBackupPlanAdvancedBackupSettingsDetails.Builder>... advancedBackupSettings) {
            advancedBackupSettings(Stream.of(advancedBackupSettings)
                    .map(c -> AwsBackupBackupPlanAdvancedBackupSettingsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AwsBackupBackupPlanRuleDetails.Builder> getBackupPlanRule() {
            List<AwsBackupBackupPlanRuleDetails.Builder> result = AwsBackupBackupPlanRuleListCopier
                    .copyToBuilder(this.backupPlanRule);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackupPlanRule(Collection<AwsBackupBackupPlanRuleDetails.BuilderImpl> backupPlanRule) {
            this.backupPlanRule = AwsBackupBackupPlanRuleListCopier.copyFromBuilder(backupPlanRule);
        }

        @Override
        public final Builder backupPlanRule(Collection<AwsBackupBackupPlanRuleDetails> backupPlanRule) {
            this.backupPlanRule = AwsBackupBackupPlanRuleListCopier.copy(backupPlanRule);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupPlanRule(AwsBackupBackupPlanRuleDetails... backupPlanRule) {
            backupPlanRule(Arrays.asList(backupPlanRule));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupPlanRule(Consumer<AwsBackupBackupPlanRuleDetails.Builder>... backupPlanRule) {
            backupPlanRule(Stream.of(backupPlanRule).map(c -> AwsBackupBackupPlanRuleDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsBackupBackupPlanBackupPlanDetails build() {
            return new AwsBackupBackupPlanBackupPlanDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
