/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsRequest;
import software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsResponse;
import software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationSummary;

public class ListStandardsControlAssociationsIterable
implements SdkIterable<ListStandardsControlAssociationsResponse> {
    private final SecurityHubClient client;
    private final ListStandardsControlAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStandardsControlAssociationsIterable(SecurityHubClient client, ListStandardsControlAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStandardsControlAssociationsResponseFetcher();
    }

    public Iterator<ListStandardsControlAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StandardsControlAssociationSummary> standardsControlAssociationSummaries() {
        Function<ListStandardsControlAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.standardsControlAssociationSummaries() != null) {
                return response.standardsControlAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStandardsControlAssociationsResponseFetcher
    implements SyncPageFetcher<ListStandardsControlAssociationsResponse> {
        private ListStandardsControlAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListStandardsControlAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStandardsControlAssociationsResponse nextPage(ListStandardsControlAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListStandardsControlAssociationsIterable.this.client.listStandardsControlAssociations(ListStandardsControlAssociationsIterable.this.firstRequest);
            }
            return ListStandardsControlAssociationsIterable.this.client.listStandardsControlAssociations((ListStandardsControlAssociationsRequest)((Object)ListStandardsControlAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

