/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DateRangeUnit {
    DAYS("DAYS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DateRangeUnit> VALUE_MAP;
    private final String value;

    private DateRangeUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DateRangeUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DateRangeUnit> knownValues() {
        EnumSet<DateRangeUnit> knownValues = EnumSet.allOf(DateRangeUnit.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DateRangeUnit.class, DateRangeUnit::toString);
    }
}

