/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsAutoScalingLaunchConfigurationMetadataOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsAutoScalingLaunchConfigurationMetadataOptions> {
    private static final SdkField<String> HTTP_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpEndpoint").getter(AwsAutoScalingLaunchConfigurationMetadataOptions.getter(AwsAutoScalingLaunchConfigurationMetadataOptions::httpEndpoint)).setter(AwsAutoScalingLaunchConfigurationMetadataOptions.setter(Builder::httpEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpoint").build()}).build();
    private static final SdkField<Integer> HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HttpPutResponseHopLimit").getter(AwsAutoScalingLaunchConfigurationMetadataOptions.getter(AwsAutoScalingLaunchConfigurationMetadataOptions::httpPutResponseHopLimit)).setter(AwsAutoScalingLaunchConfigurationMetadataOptions.setter(Builder::httpPutResponseHopLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPutResponseHopLimit").build()}).build();
    private static final SdkField<String> HTTP_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpTokens").getter(AwsAutoScalingLaunchConfigurationMetadataOptions.getter(AwsAutoScalingLaunchConfigurationMetadataOptions::httpTokens)).setter(AwsAutoScalingLaunchConfigurationMetadataOptions.setter(Builder::httpTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpTokens").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_ENDPOINT_FIELD, HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD, HTTP_TOKENS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String httpEndpoint;
    private final Integer httpPutResponseHopLimit;
    private final String httpTokens;

    private AwsAutoScalingLaunchConfigurationMetadataOptions(BuilderImpl builder) {
        this.httpEndpoint = builder.httpEndpoint;
        this.httpPutResponseHopLimit = builder.httpPutResponseHopLimit;
        this.httpTokens = builder.httpTokens;
    }

    public final String httpEndpoint() {
        return this.httpEndpoint;
    }

    public final Integer httpPutResponseHopLimit() {
        return this.httpPutResponseHopLimit;
    }

    public final String httpTokens() {
        return this.httpTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpPutResponseHopLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpTokens());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAutoScalingLaunchConfigurationMetadataOptions)) {
            return false;
        }
        AwsAutoScalingLaunchConfigurationMetadataOptions other = (AwsAutoScalingLaunchConfigurationMetadataOptions)obj;
        return Objects.equals(this.httpEndpoint(), other.httpEndpoint()) && Objects.equals(this.httpPutResponseHopLimit(), other.httpPutResponseHopLimit()) && Objects.equals(this.httpTokens(), other.httpTokens());
    }

    public final String toString() {
        return ToString.builder((String)"AwsAutoScalingLaunchConfigurationMetadataOptions").add("HttpEndpoint", (Object)this.httpEndpoint()).add("HttpPutResponseHopLimit", (Object)this.httpPutResponseHopLimit()).add("HttpTokens", (Object)this.httpTokens()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HttpEndpoint": {
                return Optional.ofNullable(clazz.cast(this.httpEndpoint()));
            }
            case "HttpPutResponseHopLimit": {
                return Optional.ofNullable(clazz.cast(this.httpPutResponseHopLimit()));
            }
            case "HttpTokens": {
                return Optional.ofNullable(clazz.cast(this.httpTokens()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsAutoScalingLaunchConfigurationMetadataOptions, T> g) {
        return obj -> g.apply((AwsAutoScalingLaunchConfigurationMetadataOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String httpEndpoint;
        private Integer httpPutResponseHopLimit;
        private String httpTokens;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAutoScalingLaunchConfigurationMetadataOptions model) {
            this.httpEndpoint(model.httpEndpoint);
            this.httpPutResponseHopLimit(model.httpPutResponseHopLimit);
            this.httpTokens(model.httpTokens);
        }

        public final String getHttpEndpoint() {
            return this.httpEndpoint;
        }

        public final void setHttpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
        }

        @Override
        public final Builder httpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        public final Integer getHttpPutResponseHopLimit() {
            return this.httpPutResponseHopLimit;
        }

        public final void setHttpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
        }

        @Override
        public final Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
            return this;
        }

        public final String getHttpTokens() {
            return this.httpTokens;
        }

        public final void setHttpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
        }

        @Override
        public final Builder httpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
            return this;
        }

        public AwsAutoScalingLaunchConfigurationMetadataOptions build() {
            return new AwsAutoScalingLaunchConfigurationMetadataOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsAutoScalingLaunchConfigurationMetadataOptions> {
        public Builder httpEndpoint(String var1);

        public Builder httpPutResponseHopLimit(Integer var1);

        public Builder httpTokens(String var1);
    }
}

