/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.ControlStatus;
import software.amazon.awssdk.services.securityhub.model.SeverityRating;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityControl
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityControl> {
    private static final SdkField<String> SECURITY_CONTROL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityControlId").getter(SecurityControl.getter(SecurityControl::securityControlId)).setter(SecurityControl.setter(Builder::securityControlId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlId").build()}).build();
    private static final SdkField<String> SECURITY_CONTROL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityControlArn").getter(SecurityControl.getter(SecurityControl::securityControlArn)).setter(SecurityControl.setter(Builder::securityControlArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlArn").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(SecurityControl.getter(SecurityControl::title)).setter(SecurityControl.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SecurityControl.getter(SecurityControl::description)).setter(SecurityControl.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> REMEDIATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemediationUrl").getter(SecurityControl.getter(SecurityControl::remediationUrl)).setter(SecurityControl.setter(Builder::remediationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationUrl").build()}).build();
    private static final SdkField<String> SEVERITY_RATING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SeverityRating").getter(SecurityControl.getter(SecurityControl::severityRatingAsString)).setter(SecurityControl.setter(Builder::severityRating)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeverityRating").build()}).build();
    private static final SdkField<String> SECURITY_CONTROL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityControlStatus").getter(SecurityControl.getter(SecurityControl::securityControlStatusAsString)).setter(SecurityControl.setter(Builder::securityControlStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_CONTROL_ID_FIELD, SECURITY_CONTROL_ARN_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, REMEDIATION_URL_FIELD, SEVERITY_RATING_FIELD, SECURITY_CONTROL_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String securityControlId;
    private final String securityControlArn;
    private final String title;
    private final String description;
    private final String remediationUrl;
    private final String severityRating;
    private final String securityControlStatus;

    private SecurityControl(BuilderImpl builder) {
        this.securityControlId = builder.securityControlId;
        this.securityControlArn = builder.securityControlArn;
        this.title = builder.title;
        this.description = builder.description;
        this.remediationUrl = builder.remediationUrl;
        this.severityRating = builder.severityRating;
        this.securityControlStatus = builder.securityControlStatus;
    }

    public final String securityControlId() {
        return this.securityControlId;
    }

    public final String securityControlArn() {
        return this.securityControlArn;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final String remediationUrl() {
        return this.remediationUrl;
    }

    public final SeverityRating severityRating() {
        return SeverityRating.fromValue(this.severityRating);
    }

    public final String severityRatingAsString() {
        return this.severityRating;
    }

    public final ControlStatus securityControlStatus() {
        return ControlStatus.fromValue(this.securityControlStatus);
    }

    public final String securityControlStatusAsString() {
        return this.securityControlStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityControlId());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityControlArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityRatingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityControlStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityControl)) {
            return false;
        }
        SecurityControl other = (SecurityControl)obj;
        return Objects.equals(this.securityControlId(), other.securityControlId()) && Objects.equals(this.securityControlArn(), other.securityControlArn()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.remediationUrl(), other.remediationUrl()) && Objects.equals(this.severityRatingAsString(), other.severityRatingAsString()) && Objects.equals(this.securityControlStatusAsString(), other.securityControlStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityControl").add("SecurityControlId", (Object)this.securityControlId()).add("SecurityControlArn", (Object)this.securityControlArn()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("RemediationUrl", (Object)this.remediationUrl()).add("SeverityRating", (Object)this.severityRatingAsString()).add("SecurityControlStatus", (Object)this.securityControlStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityControlId": {
                return Optional.ofNullable(clazz.cast(this.securityControlId()));
            }
            case "SecurityControlArn": {
                return Optional.ofNullable(clazz.cast(this.securityControlArn()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RemediationUrl": {
                return Optional.ofNullable(clazz.cast(this.remediationUrl()));
            }
            case "SeverityRating": {
                return Optional.ofNullable(clazz.cast(this.severityRatingAsString()));
            }
            case "SecurityControlStatus": {
                return Optional.ofNullable(clazz.cast(this.securityControlStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityControl, T> g) {
        return obj -> g.apply((SecurityControl)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String securityControlId;
        private String securityControlArn;
        private String title;
        private String description;
        private String remediationUrl;
        private String severityRating;
        private String securityControlStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityControl model) {
            this.securityControlId(model.securityControlId);
            this.securityControlArn(model.securityControlArn);
            this.title(model.title);
            this.description(model.description);
            this.remediationUrl(model.remediationUrl);
            this.severityRating(model.severityRating);
            this.securityControlStatus(model.securityControlStatus);
        }

        public final String getSecurityControlId() {
            return this.securityControlId;
        }

        public final void setSecurityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
        }

        @Override
        public final Builder securityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
            return this;
        }

        public final String getSecurityControlArn() {
            return this.securityControlArn;
        }

        public final void setSecurityControlArn(String securityControlArn) {
            this.securityControlArn = securityControlArn;
        }

        @Override
        public final Builder securityControlArn(String securityControlArn) {
            this.securityControlArn = securityControlArn;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRemediationUrl() {
            return this.remediationUrl;
        }

        public final void setRemediationUrl(String remediationUrl) {
            this.remediationUrl = remediationUrl;
        }

        @Override
        public final Builder remediationUrl(String remediationUrl) {
            this.remediationUrl = remediationUrl;
            return this;
        }

        public final String getSeverityRating() {
            return this.severityRating;
        }

        public final void setSeverityRating(String severityRating) {
            this.severityRating = severityRating;
        }

        @Override
        public final Builder severityRating(String severityRating) {
            this.severityRating = severityRating;
            return this;
        }

        @Override
        public final Builder severityRating(SeverityRating severityRating) {
            this.severityRating(severityRating == null ? null : severityRating.toString());
            return this;
        }

        public final String getSecurityControlStatus() {
            return this.securityControlStatus;
        }

        public final void setSecurityControlStatus(String securityControlStatus) {
            this.securityControlStatus = securityControlStatus;
        }

        @Override
        public final Builder securityControlStatus(String securityControlStatus) {
            this.securityControlStatus = securityControlStatus;
            return this;
        }

        @Override
        public final Builder securityControlStatus(ControlStatus securityControlStatus) {
            this.securityControlStatus(securityControlStatus == null ? null : securityControlStatus.toString());
            return this;
        }

        public SecurityControl build() {
            return new SecurityControl(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityControl> {
        public Builder securityControlId(String var1);

        public Builder securityControlArn(String var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder remediationUrl(String var1);

        public Builder severityRating(String var1);

        public Builder severityRating(SeverityRating var1);

        public Builder securityControlStatus(String var1);

        public Builder securityControlStatus(ControlStatus var1);
    }
}

