/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationEventsCopier;
import software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsS3BucketNotificationConfigurationDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsS3BucketNotificationConfigurationDetail> {
    private static final SdkField<List<String>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Events").getter(AwsS3BucketNotificationConfigurationDetail.getter(AwsS3BucketNotificationConfigurationDetail::events)).setter(AwsS3BucketNotificationConfigurationDetail.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsS3BucketNotificationConfigurationFilter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(AwsS3BucketNotificationConfigurationDetail.getter(AwsS3BucketNotificationConfigurationDetail::filter)).setter(AwsS3BucketNotificationConfigurationDetail.setter(Builder::filter)).constructor(AwsS3BucketNotificationConfigurationFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(AwsS3BucketNotificationConfigurationDetail.getter(AwsS3BucketNotificationConfigurationDetail::destination)).setter(AwsS3BucketNotificationConfigurationDetail.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(AwsS3BucketNotificationConfigurationDetail.getter(AwsS3BucketNotificationConfigurationDetail::type)).setter(AwsS3BucketNotificationConfigurationDetail.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD, FILTER_FIELD, DESTINATION_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> events;
    private final AwsS3BucketNotificationConfigurationFilter filter;
    private final String destination;
    private final String type;

    private AwsS3BucketNotificationConfigurationDetail(BuilderImpl builder) {
        this.events = builder.events;
        this.filter = builder.filter;
        this.destination = builder.destination;
        this.type = builder.type;
    }

    public final boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructList);
    }

    public final List<String> events() {
        return this.events;
    }

    public final AwsS3BucketNotificationConfigurationFilter filter() {
        return this.filter;
    }

    public final String destination() {
        return this.destination;
    }

    public final String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketNotificationConfigurationDetail)) {
            return false;
        }
        AwsS3BucketNotificationConfigurationDetail other = (AwsS3BucketNotificationConfigurationDetail)obj;
        return this.hasEvents() == other.hasEvents() && Objects.equals(this.events(), other.events()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"AwsS3BucketNotificationConfigurationDetail").add("Events", this.hasEvents() ? this.events() : null).add("Filter", (Object)this.filter()).add("Destination", (Object)this.destination()).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketNotificationConfigurationDetail, T> g) {
        return obj -> g.apply((AwsS3BucketNotificationConfigurationDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> events = DefaultSdkAutoConstructList.getInstance();
        private AwsS3BucketNotificationConfigurationFilter filter;
        private String destination;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketNotificationConfigurationDetail model) {
            this.events(model.events);
            this.filter(model.filter);
            this.destination(model.destination);
            this.type(model.type);
        }

        public final Collection<String> getEvents() {
            if (this.events instanceof SdkAutoConstructList) {
                return null;
            }
            return this.events;
        }

        public final void setEvents(Collection<String> events) {
            this.events = AwsS3BucketNotificationConfigurationEventsCopier.copy(events);
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = AwsS3BucketNotificationConfigurationEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final AwsS3BucketNotificationConfigurationFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(AwsS3BucketNotificationConfigurationFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(AwsS3BucketNotificationConfigurationFilter filter) {
            this.filter = filter;
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public AwsS3BucketNotificationConfigurationDetail build() {
            return new AwsS3BucketNotificationConfigurationDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsS3BucketNotificationConfigurationDetail> {
        public Builder events(Collection<String> var1);

        public Builder events(String ... var1);

        public Builder filter(AwsS3BucketNotificationConfigurationFilter var1);

        default public Builder filter(Consumer<AwsS3BucketNotificationConfigurationFilter.Builder> filter) {
            return this.filter((AwsS3BucketNotificationConfigurationFilter)((AwsS3BucketNotificationConfigurationFilter.Builder)AwsS3BucketNotificationConfigurationFilter.builder().applyMutation(filter)).build());
        }

        public Builder destination(String var1);

        public Builder type(String var1);
    }
}

