/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails> {
    private static final SdkField<String> ASSIGN_PUBLIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssignPublicIp").getter(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.getter(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails::assignPublicIp)).setter(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.setter(Builder::assignPublicIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignPublicIp").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.getter(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails::securityGroups)).setter(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subnets").getter(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.getter(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails::subnets)).setter(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGN_PUBLIC_IP_FIELD, SECURITY_GROUPS_FIELD, SUBNETS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String assignPublicIp;
    private final List<String> securityGroups;
    private final List<String> subnets;

    private AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails(BuilderImpl builder) {
        this.assignPublicIp = builder.assignPublicIp;
        this.securityGroups = builder.securityGroups;
        this.subnets = builder.subnets;
    }

    public final String assignPublicIp() {
        return this.assignPublicIp;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<String> subnets() {
        return this.subnets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assignPublicIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails)) {
            return false;
        }
        AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails other = (AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails)obj;
        return Objects.equals(this.assignPublicIp(), other.assignPublicIp()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails").add("AssignPublicIp", (Object)this.assignPublicIp()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("Subnets", this.hasSubnets() ? this.subnets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssignPublicIp": {
                return Optional.ofNullable(clazz.cast(this.assignPublicIp()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "Subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails, T> g) {
        return obj -> g.apply((AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assignPublicIp;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails model) {
            this.assignPublicIp(model.assignPublicIp);
            this.securityGroups(model.securityGroups);
            this.subnets(model.subnets);
        }

        public final String getAssignPublicIp() {
            return this.assignPublicIp;
        }

        public final void setAssignPublicIp(String assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
        }

        @Override
        @Transient
        public final Builder assignPublicIp(String assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = NonEmptyStringListCopier.copy(securityGroups);
        }

        @Override
        @Transient
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = NonEmptyStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final Collection<String> getSubnets() {
            if (this.subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = NonEmptyStringListCopier.copy(subnets);
        }

        @Override
        @Transient
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = NonEmptyStringListCopier.copy(subnets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails build() {
            return new AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails> {
        public Builder assignPublicIp(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);
    }
}

