/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsAutoScalingAutoScalingGroupDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsAutoScalingAutoScalingGroupDetails> {
    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchConfigurationName").getter(AwsAutoScalingAutoScalingGroupDetails.getter(AwsAutoScalingAutoScalingGroupDetails::launchConfigurationName)).setter(AwsAutoScalingAutoScalingGroupDetails.setter(Builder::launchConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build()}).build();
    private static final SdkField<List<String>> LOAD_BALANCER_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LoadBalancerNames").getter(AwsAutoScalingAutoScalingGroupDetails.getter(AwsAutoScalingAutoScalingGroupDetails::loadBalancerNames)).setter(AwsAutoScalingAutoScalingGroupDetails.setter(Builder::loadBalancerNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HEALTH_CHECK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthCheckType").getter(AwsAutoScalingAutoScalingGroupDetails.getter(AwsAutoScalingAutoScalingGroupDetails::healthCheckType)).setter(AwsAutoScalingAutoScalingGroupDetails.setter(Builder::healthCheckType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckType").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HealthCheckGracePeriod").getter(AwsAutoScalingAutoScalingGroupDetails.getter(AwsAutoScalingAutoScalingGroupDetails::healthCheckGracePeriod)).setter(AwsAutoScalingAutoScalingGroupDetails.setter(Builder::healthCheckGracePeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckGracePeriod").build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedTime").getter(AwsAutoScalingAutoScalingGroupDetails.getter(AwsAutoScalingAutoScalingGroupDetails::createdTime)).setter(AwsAutoScalingAutoScalingGroupDetails.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_CONFIGURATION_NAME_FIELD, LOAD_BALANCER_NAMES_FIELD, HEALTH_CHECK_TYPE_FIELD, HEALTH_CHECK_GRACE_PERIOD_FIELD, CREATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String launchConfigurationName;
    private final List<String> loadBalancerNames;
    private final String healthCheckType;
    private final Integer healthCheckGracePeriod;
    private final String createdTime;

    private AwsAutoScalingAutoScalingGroupDetails(BuilderImpl builder) {
        this.launchConfigurationName = builder.launchConfigurationName;
        this.loadBalancerNames = builder.loadBalancerNames;
        this.healthCheckType = builder.healthCheckType;
        this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
        this.createdTime = builder.createdTime;
    }

    public final String launchConfigurationName() {
        return this.launchConfigurationName;
    }

    public final boolean hasLoadBalancerNames() {
        return this.loadBalancerNames != null && !(this.loadBalancerNames instanceof SdkAutoConstructList);
    }

    public final List<String> loadBalancerNames() {
        return this.loadBalancerNames;
    }

    public final String healthCheckType() {
        return this.healthCheckType;
    }

    public final Integer healthCheckGracePeriod() {
        return this.healthCheckGracePeriod;
    }

    public final String createdTime() {
        return this.createdTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBalancerNames() ? this.loadBalancerNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckType());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckGracePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAutoScalingAutoScalingGroupDetails)) {
            return false;
        }
        AwsAutoScalingAutoScalingGroupDetails other = (AwsAutoScalingAutoScalingGroupDetails)obj;
        return Objects.equals(this.launchConfigurationName(), other.launchConfigurationName()) && this.hasLoadBalancerNames() == other.hasLoadBalancerNames() && Objects.equals(this.loadBalancerNames(), other.loadBalancerNames()) && Objects.equals(this.healthCheckType(), other.healthCheckType()) && Objects.equals(this.healthCheckGracePeriod(), other.healthCheckGracePeriod()) && Objects.equals(this.createdTime(), other.createdTime());
    }

    public final String toString() {
        return ToString.builder((String)"AwsAutoScalingAutoScalingGroupDetails").add("LaunchConfigurationName", (Object)this.launchConfigurationName()).add("LoadBalancerNames", this.hasLoadBalancerNames() ? this.loadBalancerNames() : null).add("HealthCheckType", (Object)this.healthCheckType()).add("HealthCheckGracePeriod", (Object)this.healthCheckGracePeriod()).add("CreatedTime", (Object)this.createdTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.launchConfigurationName()));
            }
            case "LoadBalancerNames": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerNames()));
            }
            case "HealthCheckType": {
                return Optional.ofNullable(clazz.cast(this.healthCheckType()));
            }
            case "HealthCheckGracePeriod": {
                return Optional.ofNullable(clazz.cast(this.healthCheckGracePeriod()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsAutoScalingAutoScalingGroupDetails, T> g) {
        return obj -> g.apply((AwsAutoScalingAutoScalingGroupDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String launchConfigurationName;
        private List<String> loadBalancerNames = DefaultSdkAutoConstructList.getInstance();
        private String healthCheckType;
        private Integer healthCheckGracePeriod;
        private String createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAutoScalingAutoScalingGroupDetails model) {
            this.launchConfigurationName(model.launchConfigurationName);
            this.loadBalancerNames(model.loadBalancerNames);
            this.healthCheckType(model.healthCheckType);
            this.healthCheckGracePeriod(model.healthCheckGracePeriod);
            this.createdTime(model.createdTime);
        }

        public final String getLaunchConfigurationName() {
            return this.launchConfigurationName;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        @Override
        @Transient
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final Collection<String> getLoadBalancerNames() {
            if (this.loadBalancerNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.loadBalancerNames;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = StringListCopier.copy(loadBalancerNames);
        }

        @Override
        @Transient
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = StringListCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder loadBalancerNames(String ... loadBalancerNames) {
            this.loadBalancerNames(Arrays.asList(loadBalancerNames));
            return this;
        }

        public final String getHealthCheckType() {
            return this.healthCheckType;
        }

        public final void setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        @Override
        @Transient
        public final Builder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final Integer getHealthCheckGracePeriod() {
            return this.healthCheckGracePeriod;
        }

        public final void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
        }

        @Override
        @Transient
        public final Builder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public AwsAutoScalingAutoScalingGroupDetails build() {
            return new AwsAutoScalingAutoScalingGroupDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsAutoScalingAutoScalingGroupDetails> {
        public Builder launchConfigurationName(String var1);

        public Builder loadBalancerNames(Collection<String> var1);

        public Builder loadBalancerNames(String ... var1);

        public Builder healthCheckType(String var1);

        public Builder healthCheckGracePeriod(Integer var1);

        public Builder createdTime(String var1);
    }
}

