/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.IntegerListCopier;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2VpnConnectionOptionsTunnelOptionsDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2VpnConnectionOptionsTunnelOptionsDetails> {
    private static final SdkField<Integer> DPD_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DpdTimeoutSeconds").getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::dpdTimeoutSeconds)).setter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.setter(Builder::dpdTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DpdTimeoutSeconds").build()}).build();
    private static final SdkField<List<String>> IKE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IkeVersions").getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::ikeVersions)).setter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.setter(Builder::ikeVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IkeVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OUTSIDE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutsideIpAddress").getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::outsideIpAddress)).setter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.setter(Builder::outsideIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutsideIpAddress").build()}).build();
    private static final SdkField<List<Integer>> PHASE1_DH_GROUP_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phase1DhGroupNumbers").getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::phase1DhGroupNumbers)).setter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.setter(Builder::phase1DhGroupNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1DhGroupNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PHASE1_ENCRYPTION_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phase1EncryptionAlgorithms").getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::phase1EncryptionAlgorithms)).setter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.setter(Builder::phase1EncryptionAlgorithms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1EncryptionAlgorithms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PHASE1_INTEGRITY_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phase1IntegrityAlgorithms").getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::phase1IntegrityAlgorithms)).setter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.setter(Builder::phase1IntegrityAlgorithms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1IntegrityAlgorithms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PHASE1_LIFETIME_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Phase1LifetimeSeconds").getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::phase1LifetimeSeconds)).setter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.setter(Builder::phase1LifetimeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1LifetimeSeconds").build()}).build();
    private static final SdkField<List<Integer>> PHASE2_DH_GROUP_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phase2DhGroupNumbers").getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::phase2DhGroupNumbers)).setter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.setter(Builder::phase2DhGroupNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2DhGroupNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PHASE2_ENCRYPTION_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phase2EncryptionAlgorithms").getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::phase2EncryptionAlgorithms)).setter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.setter(Builder::phase2EncryptionAlgorithms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2EncryptionAlgorithms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PHASE2_INTEGRITY_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Phase2IntegrityAlgorithms").getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::phase2IntegrityAlgorithms)).setter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.setter(Builder::phase2IntegrityAlgorithms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2IntegrityAlgorithms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PHASE2_LIFETIME_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Phase2LifetimeSeconds").getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::phase2LifetimeSeconds)).setter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.setter(Builder::phase2LifetimeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2LifetimeSeconds").build()}).build();
    private static final SdkField<String> PRE_SHARED_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreSharedKey").getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::preSharedKey)).setter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.setter(Builder::preSharedKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSharedKey").build()}).build();
    private static final SdkField<Integer> REKEY_FUZZ_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RekeyFuzzPercentage").getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::rekeyFuzzPercentage)).setter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.setter(Builder::rekeyFuzzPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RekeyFuzzPercentage").build()}).build();
    private static final SdkField<Integer> REKEY_MARGIN_TIME_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RekeyMarginTimeSeconds").getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::rekeyMarginTimeSeconds)).setter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.setter(Builder::rekeyMarginTimeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RekeyMarginTimeSeconds").build()}).build();
    private static final SdkField<Integer> REPLAY_WINDOW_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReplayWindowSize").getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::replayWindowSize)).setter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.setter(Builder::replayWindowSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayWindowSize").build()}).build();
    private static final SdkField<String> TUNNEL_INSIDE_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TunnelInsideCidr").getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.getter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::tunnelInsideCidr)).setter(AwsEc2VpnConnectionOptionsTunnelOptionsDetails.setter(Builder::tunnelInsideCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelInsideCidr").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DPD_TIMEOUT_SECONDS_FIELD, IKE_VERSIONS_FIELD, OUTSIDE_IP_ADDRESS_FIELD, PHASE1_DH_GROUP_NUMBERS_FIELD, PHASE1_ENCRYPTION_ALGORITHMS_FIELD, PHASE1_INTEGRITY_ALGORITHMS_FIELD, PHASE1_LIFETIME_SECONDS_FIELD, PHASE2_DH_GROUP_NUMBERS_FIELD, PHASE2_ENCRYPTION_ALGORITHMS_FIELD, PHASE2_INTEGRITY_ALGORITHMS_FIELD, PHASE2_LIFETIME_SECONDS_FIELD, PRE_SHARED_KEY_FIELD, REKEY_FUZZ_PERCENTAGE_FIELD, REKEY_MARGIN_TIME_SECONDS_FIELD, REPLAY_WINDOW_SIZE_FIELD, TUNNEL_INSIDE_CIDR_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer dpdTimeoutSeconds;
    private final List<String> ikeVersions;
    private final String outsideIpAddress;
    private final List<Integer> phase1DhGroupNumbers;
    private final List<String> phase1EncryptionAlgorithms;
    private final List<String> phase1IntegrityAlgorithms;
    private final Integer phase1LifetimeSeconds;
    private final List<Integer> phase2DhGroupNumbers;
    private final List<String> phase2EncryptionAlgorithms;
    private final List<String> phase2IntegrityAlgorithms;
    private final Integer phase2LifetimeSeconds;
    private final String preSharedKey;
    private final Integer rekeyFuzzPercentage;
    private final Integer rekeyMarginTimeSeconds;
    private final Integer replayWindowSize;
    private final String tunnelInsideCidr;

    private AwsEc2VpnConnectionOptionsTunnelOptionsDetails(BuilderImpl builder) {
        this.dpdTimeoutSeconds = builder.dpdTimeoutSeconds;
        this.ikeVersions = builder.ikeVersions;
        this.outsideIpAddress = builder.outsideIpAddress;
        this.phase1DhGroupNumbers = builder.phase1DhGroupNumbers;
        this.phase1EncryptionAlgorithms = builder.phase1EncryptionAlgorithms;
        this.phase1IntegrityAlgorithms = builder.phase1IntegrityAlgorithms;
        this.phase1LifetimeSeconds = builder.phase1LifetimeSeconds;
        this.phase2DhGroupNumbers = builder.phase2DhGroupNumbers;
        this.phase2EncryptionAlgorithms = builder.phase2EncryptionAlgorithms;
        this.phase2IntegrityAlgorithms = builder.phase2IntegrityAlgorithms;
        this.phase2LifetimeSeconds = builder.phase2LifetimeSeconds;
        this.preSharedKey = builder.preSharedKey;
        this.rekeyFuzzPercentage = builder.rekeyFuzzPercentage;
        this.rekeyMarginTimeSeconds = builder.rekeyMarginTimeSeconds;
        this.replayWindowSize = builder.replayWindowSize;
        this.tunnelInsideCidr = builder.tunnelInsideCidr;
    }

    public final Integer dpdTimeoutSeconds() {
        return this.dpdTimeoutSeconds;
    }

    public final boolean hasIkeVersions() {
        return this.ikeVersions != null && !(this.ikeVersions instanceof SdkAutoConstructList);
    }

    public final List<String> ikeVersions() {
        return this.ikeVersions;
    }

    public final String outsideIpAddress() {
        return this.outsideIpAddress;
    }

    public final boolean hasPhase1DhGroupNumbers() {
        return this.phase1DhGroupNumbers != null && !(this.phase1DhGroupNumbers instanceof SdkAutoConstructList);
    }

    public final List<Integer> phase1DhGroupNumbers() {
        return this.phase1DhGroupNumbers;
    }

    public final boolean hasPhase1EncryptionAlgorithms() {
        return this.phase1EncryptionAlgorithms != null && !(this.phase1EncryptionAlgorithms instanceof SdkAutoConstructList);
    }

    public final List<String> phase1EncryptionAlgorithms() {
        return this.phase1EncryptionAlgorithms;
    }

    public final boolean hasPhase1IntegrityAlgorithms() {
        return this.phase1IntegrityAlgorithms != null && !(this.phase1IntegrityAlgorithms instanceof SdkAutoConstructList);
    }

    public final List<String> phase1IntegrityAlgorithms() {
        return this.phase1IntegrityAlgorithms;
    }

    public final Integer phase1LifetimeSeconds() {
        return this.phase1LifetimeSeconds;
    }

    public final boolean hasPhase2DhGroupNumbers() {
        return this.phase2DhGroupNumbers != null && !(this.phase2DhGroupNumbers instanceof SdkAutoConstructList);
    }

    public final List<Integer> phase2DhGroupNumbers() {
        return this.phase2DhGroupNumbers;
    }

    public final boolean hasPhase2EncryptionAlgorithms() {
        return this.phase2EncryptionAlgorithms != null && !(this.phase2EncryptionAlgorithms instanceof SdkAutoConstructList);
    }

    public final List<String> phase2EncryptionAlgorithms() {
        return this.phase2EncryptionAlgorithms;
    }

    public final boolean hasPhase2IntegrityAlgorithms() {
        return this.phase2IntegrityAlgorithms != null && !(this.phase2IntegrityAlgorithms instanceof SdkAutoConstructList);
    }

    public final List<String> phase2IntegrityAlgorithms() {
        return this.phase2IntegrityAlgorithms;
    }

    public final Integer phase2LifetimeSeconds() {
        return this.phase2LifetimeSeconds;
    }

    public final String preSharedKey() {
        return this.preSharedKey;
    }

    public final Integer rekeyFuzzPercentage() {
        return this.rekeyFuzzPercentage;
    }

    public final Integer rekeyMarginTimeSeconds() {
        return this.rekeyMarginTimeSeconds;
    }

    public final Integer replayWindowSize() {
        return this.replayWindowSize;
    }

    public final String tunnelInsideCidr() {
        return this.tunnelInsideCidr;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dpdTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIkeVersions() ? this.ikeVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outsideIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhase1DhGroupNumbers() ? this.phase1DhGroupNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhase1EncryptionAlgorithms() ? this.phase1EncryptionAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhase1IntegrityAlgorithms() ? this.phase1IntegrityAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.phase1LifetimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhase2DhGroupNumbers() ? this.phase2DhGroupNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhase2EncryptionAlgorithms() ? this.phase2EncryptionAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhase2IntegrityAlgorithms() ? this.phase2IntegrityAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.phase2LifetimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.preSharedKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.rekeyFuzzPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.rekeyMarginTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.replayWindowSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelInsideCidr());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2VpnConnectionOptionsTunnelOptionsDetails)) {
            return false;
        }
        AwsEc2VpnConnectionOptionsTunnelOptionsDetails other = (AwsEc2VpnConnectionOptionsTunnelOptionsDetails)obj;
        return Objects.equals(this.dpdTimeoutSeconds(), other.dpdTimeoutSeconds()) && this.hasIkeVersions() == other.hasIkeVersions() && Objects.equals(this.ikeVersions(), other.ikeVersions()) && Objects.equals(this.outsideIpAddress(), other.outsideIpAddress()) && this.hasPhase1DhGroupNumbers() == other.hasPhase1DhGroupNumbers() && Objects.equals(this.phase1DhGroupNumbers(), other.phase1DhGroupNumbers()) && this.hasPhase1EncryptionAlgorithms() == other.hasPhase1EncryptionAlgorithms() && Objects.equals(this.phase1EncryptionAlgorithms(), other.phase1EncryptionAlgorithms()) && this.hasPhase1IntegrityAlgorithms() == other.hasPhase1IntegrityAlgorithms() && Objects.equals(this.phase1IntegrityAlgorithms(), other.phase1IntegrityAlgorithms()) && Objects.equals(this.phase1LifetimeSeconds(), other.phase1LifetimeSeconds()) && this.hasPhase2DhGroupNumbers() == other.hasPhase2DhGroupNumbers() && Objects.equals(this.phase2DhGroupNumbers(), other.phase2DhGroupNumbers()) && this.hasPhase2EncryptionAlgorithms() == other.hasPhase2EncryptionAlgorithms() && Objects.equals(this.phase2EncryptionAlgorithms(), other.phase2EncryptionAlgorithms()) && this.hasPhase2IntegrityAlgorithms() == other.hasPhase2IntegrityAlgorithms() && Objects.equals(this.phase2IntegrityAlgorithms(), other.phase2IntegrityAlgorithms()) && Objects.equals(this.phase2LifetimeSeconds(), other.phase2LifetimeSeconds()) && Objects.equals(this.preSharedKey(), other.preSharedKey()) && Objects.equals(this.rekeyFuzzPercentage(), other.rekeyFuzzPercentage()) && Objects.equals(this.rekeyMarginTimeSeconds(), other.rekeyMarginTimeSeconds()) && Objects.equals(this.replayWindowSize(), other.replayWindowSize()) && Objects.equals(this.tunnelInsideCidr(), other.tunnelInsideCidr());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2VpnConnectionOptionsTunnelOptionsDetails").add("DpdTimeoutSeconds", (Object)this.dpdTimeoutSeconds()).add("IkeVersions", this.hasIkeVersions() ? this.ikeVersions() : null).add("OutsideIpAddress", (Object)this.outsideIpAddress()).add("Phase1DhGroupNumbers", this.hasPhase1DhGroupNumbers() ? this.phase1DhGroupNumbers() : null).add("Phase1EncryptionAlgorithms", this.hasPhase1EncryptionAlgorithms() ? this.phase1EncryptionAlgorithms() : null).add("Phase1IntegrityAlgorithms", this.hasPhase1IntegrityAlgorithms() ? this.phase1IntegrityAlgorithms() : null).add("Phase1LifetimeSeconds", (Object)this.phase1LifetimeSeconds()).add("Phase2DhGroupNumbers", this.hasPhase2DhGroupNumbers() ? this.phase2DhGroupNumbers() : null).add("Phase2EncryptionAlgorithms", this.hasPhase2EncryptionAlgorithms() ? this.phase2EncryptionAlgorithms() : null).add("Phase2IntegrityAlgorithms", this.hasPhase2IntegrityAlgorithms() ? this.phase2IntegrityAlgorithms() : null).add("Phase2LifetimeSeconds", (Object)this.phase2LifetimeSeconds()).add("PreSharedKey", (Object)this.preSharedKey()).add("RekeyFuzzPercentage", (Object)this.rekeyFuzzPercentage()).add("RekeyMarginTimeSeconds", (Object)this.rekeyMarginTimeSeconds()).add("ReplayWindowSize", (Object)this.replayWindowSize()).add("TunnelInsideCidr", (Object)this.tunnelInsideCidr()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DpdTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.dpdTimeoutSeconds()));
            }
            case "IkeVersions": {
                return Optional.ofNullable(clazz.cast(this.ikeVersions()));
            }
            case "OutsideIpAddress": {
                return Optional.ofNullable(clazz.cast(this.outsideIpAddress()));
            }
            case "Phase1DhGroupNumbers": {
                return Optional.ofNullable(clazz.cast(this.phase1DhGroupNumbers()));
            }
            case "Phase1EncryptionAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.phase1EncryptionAlgorithms()));
            }
            case "Phase1IntegrityAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.phase1IntegrityAlgorithms()));
            }
            case "Phase1LifetimeSeconds": {
                return Optional.ofNullable(clazz.cast(this.phase1LifetimeSeconds()));
            }
            case "Phase2DhGroupNumbers": {
                return Optional.ofNullable(clazz.cast(this.phase2DhGroupNumbers()));
            }
            case "Phase2EncryptionAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.phase2EncryptionAlgorithms()));
            }
            case "Phase2IntegrityAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.phase2IntegrityAlgorithms()));
            }
            case "Phase2LifetimeSeconds": {
                return Optional.ofNullable(clazz.cast(this.phase2LifetimeSeconds()));
            }
            case "PreSharedKey": {
                return Optional.ofNullable(clazz.cast(this.preSharedKey()));
            }
            case "RekeyFuzzPercentage": {
                return Optional.ofNullable(clazz.cast(this.rekeyFuzzPercentage()));
            }
            case "RekeyMarginTimeSeconds": {
                return Optional.ofNullable(clazz.cast(this.rekeyMarginTimeSeconds()));
            }
            case "ReplayWindowSize": {
                return Optional.ofNullable(clazz.cast(this.replayWindowSize()));
            }
            case "TunnelInsideCidr": {
                return Optional.ofNullable(clazz.cast(this.tunnelInsideCidr()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2VpnConnectionOptionsTunnelOptionsDetails, T> g) {
        return obj -> g.apply((AwsEc2VpnConnectionOptionsTunnelOptionsDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer dpdTimeoutSeconds;
        private List<String> ikeVersions = DefaultSdkAutoConstructList.getInstance();
        private String outsideIpAddress;
        private List<Integer> phase1DhGroupNumbers = DefaultSdkAutoConstructList.getInstance();
        private List<String> phase1EncryptionAlgorithms = DefaultSdkAutoConstructList.getInstance();
        private List<String> phase1IntegrityAlgorithms = DefaultSdkAutoConstructList.getInstance();
        private Integer phase1LifetimeSeconds;
        private List<Integer> phase2DhGroupNumbers = DefaultSdkAutoConstructList.getInstance();
        private List<String> phase2EncryptionAlgorithms = DefaultSdkAutoConstructList.getInstance();
        private List<String> phase2IntegrityAlgorithms = DefaultSdkAutoConstructList.getInstance();
        private Integer phase2LifetimeSeconds;
        private String preSharedKey;
        private Integer rekeyFuzzPercentage;
        private Integer rekeyMarginTimeSeconds;
        private Integer replayWindowSize;
        private String tunnelInsideCidr;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2VpnConnectionOptionsTunnelOptionsDetails model) {
            this.dpdTimeoutSeconds(model.dpdTimeoutSeconds);
            this.ikeVersions(model.ikeVersions);
            this.outsideIpAddress(model.outsideIpAddress);
            this.phase1DhGroupNumbers(model.phase1DhGroupNumbers);
            this.phase1EncryptionAlgorithms(model.phase1EncryptionAlgorithms);
            this.phase1IntegrityAlgorithms(model.phase1IntegrityAlgorithms);
            this.phase1LifetimeSeconds(model.phase1LifetimeSeconds);
            this.phase2DhGroupNumbers(model.phase2DhGroupNumbers);
            this.phase2EncryptionAlgorithms(model.phase2EncryptionAlgorithms);
            this.phase2IntegrityAlgorithms(model.phase2IntegrityAlgorithms);
            this.phase2LifetimeSeconds(model.phase2LifetimeSeconds);
            this.preSharedKey(model.preSharedKey);
            this.rekeyFuzzPercentage(model.rekeyFuzzPercentage);
            this.rekeyMarginTimeSeconds(model.rekeyMarginTimeSeconds);
            this.replayWindowSize(model.replayWindowSize);
            this.tunnelInsideCidr(model.tunnelInsideCidr);
        }

        public final Integer getDpdTimeoutSeconds() {
            return this.dpdTimeoutSeconds;
        }

        public final void setDpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
            this.dpdTimeoutSeconds = dpdTimeoutSeconds;
        }

        @Override
        @Transient
        public final Builder dpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
            this.dpdTimeoutSeconds = dpdTimeoutSeconds;
            return this;
        }

        public final Collection<String> getIkeVersions() {
            if (this.ikeVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ikeVersions;
        }

        public final void setIkeVersions(Collection<String> ikeVersions) {
            this.ikeVersions = NonEmptyStringListCopier.copy(ikeVersions);
        }

        @Override
        @Transient
        public final Builder ikeVersions(Collection<String> ikeVersions) {
            this.ikeVersions = NonEmptyStringListCopier.copy(ikeVersions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ikeVersions(String ... ikeVersions) {
            this.ikeVersions(Arrays.asList(ikeVersions));
            return this;
        }

        public final String getOutsideIpAddress() {
            return this.outsideIpAddress;
        }

        public final void setOutsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
        }

        @Override
        @Transient
        public final Builder outsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
            return this;
        }

        public final Collection<Integer> getPhase1DhGroupNumbers() {
            if (this.phase1DhGroupNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.phase1DhGroupNumbers;
        }

        public final void setPhase1DhGroupNumbers(Collection<Integer> phase1DhGroupNumbers) {
            this.phase1DhGroupNumbers = IntegerListCopier.copy(phase1DhGroupNumbers);
        }

        @Override
        @Transient
        public final Builder phase1DhGroupNumbers(Collection<Integer> phase1DhGroupNumbers) {
            this.phase1DhGroupNumbers = IntegerListCopier.copy(phase1DhGroupNumbers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder phase1DhGroupNumbers(Integer ... phase1DhGroupNumbers) {
            this.phase1DhGroupNumbers(Arrays.asList(phase1DhGroupNumbers));
            return this;
        }

        public final Collection<String> getPhase1EncryptionAlgorithms() {
            if (this.phase1EncryptionAlgorithms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.phase1EncryptionAlgorithms;
        }

        public final void setPhase1EncryptionAlgorithms(Collection<String> phase1EncryptionAlgorithms) {
            this.phase1EncryptionAlgorithms = NonEmptyStringListCopier.copy(phase1EncryptionAlgorithms);
        }

        @Override
        @Transient
        public final Builder phase1EncryptionAlgorithms(Collection<String> phase1EncryptionAlgorithms) {
            this.phase1EncryptionAlgorithms = NonEmptyStringListCopier.copy(phase1EncryptionAlgorithms);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder phase1EncryptionAlgorithms(String ... phase1EncryptionAlgorithms) {
            this.phase1EncryptionAlgorithms(Arrays.asList(phase1EncryptionAlgorithms));
            return this;
        }

        public final Collection<String> getPhase1IntegrityAlgorithms() {
            if (this.phase1IntegrityAlgorithms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.phase1IntegrityAlgorithms;
        }

        public final void setPhase1IntegrityAlgorithms(Collection<String> phase1IntegrityAlgorithms) {
            this.phase1IntegrityAlgorithms = NonEmptyStringListCopier.copy(phase1IntegrityAlgorithms);
        }

        @Override
        @Transient
        public final Builder phase1IntegrityAlgorithms(Collection<String> phase1IntegrityAlgorithms) {
            this.phase1IntegrityAlgorithms = NonEmptyStringListCopier.copy(phase1IntegrityAlgorithms);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder phase1IntegrityAlgorithms(String ... phase1IntegrityAlgorithms) {
            this.phase1IntegrityAlgorithms(Arrays.asList(phase1IntegrityAlgorithms));
            return this;
        }

        public final Integer getPhase1LifetimeSeconds() {
            return this.phase1LifetimeSeconds;
        }

        public final void setPhase1LifetimeSeconds(Integer phase1LifetimeSeconds) {
            this.phase1LifetimeSeconds = phase1LifetimeSeconds;
        }

        @Override
        @Transient
        public final Builder phase1LifetimeSeconds(Integer phase1LifetimeSeconds) {
            this.phase1LifetimeSeconds = phase1LifetimeSeconds;
            return this;
        }

        public final Collection<Integer> getPhase2DhGroupNumbers() {
            if (this.phase2DhGroupNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.phase2DhGroupNumbers;
        }

        public final void setPhase2DhGroupNumbers(Collection<Integer> phase2DhGroupNumbers) {
            this.phase2DhGroupNumbers = IntegerListCopier.copy(phase2DhGroupNumbers);
        }

        @Override
        @Transient
        public final Builder phase2DhGroupNumbers(Collection<Integer> phase2DhGroupNumbers) {
            this.phase2DhGroupNumbers = IntegerListCopier.copy(phase2DhGroupNumbers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder phase2DhGroupNumbers(Integer ... phase2DhGroupNumbers) {
            this.phase2DhGroupNumbers(Arrays.asList(phase2DhGroupNumbers));
            return this;
        }

        public final Collection<String> getPhase2EncryptionAlgorithms() {
            if (this.phase2EncryptionAlgorithms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.phase2EncryptionAlgorithms;
        }

        public final void setPhase2EncryptionAlgorithms(Collection<String> phase2EncryptionAlgorithms) {
            this.phase2EncryptionAlgorithms = NonEmptyStringListCopier.copy(phase2EncryptionAlgorithms);
        }

        @Override
        @Transient
        public final Builder phase2EncryptionAlgorithms(Collection<String> phase2EncryptionAlgorithms) {
            this.phase2EncryptionAlgorithms = NonEmptyStringListCopier.copy(phase2EncryptionAlgorithms);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder phase2EncryptionAlgorithms(String ... phase2EncryptionAlgorithms) {
            this.phase2EncryptionAlgorithms(Arrays.asList(phase2EncryptionAlgorithms));
            return this;
        }

        public final Collection<String> getPhase2IntegrityAlgorithms() {
            if (this.phase2IntegrityAlgorithms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.phase2IntegrityAlgorithms;
        }

        public final void setPhase2IntegrityAlgorithms(Collection<String> phase2IntegrityAlgorithms) {
            this.phase2IntegrityAlgorithms = NonEmptyStringListCopier.copy(phase2IntegrityAlgorithms);
        }

        @Override
        @Transient
        public final Builder phase2IntegrityAlgorithms(Collection<String> phase2IntegrityAlgorithms) {
            this.phase2IntegrityAlgorithms = NonEmptyStringListCopier.copy(phase2IntegrityAlgorithms);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder phase2IntegrityAlgorithms(String ... phase2IntegrityAlgorithms) {
            this.phase2IntegrityAlgorithms(Arrays.asList(phase2IntegrityAlgorithms));
            return this;
        }

        public final Integer getPhase2LifetimeSeconds() {
            return this.phase2LifetimeSeconds;
        }

        public final void setPhase2LifetimeSeconds(Integer phase2LifetimeSeconds) {
            this.phase2LifetimeSeconds = phase2LifetimeSeconds;
        }

        @Override
        @Transient
        public final Builder phase2LifetimeSeconds(Integer phase2LifetimeSeconds) {
            this.phase2LifetimeSeconds = phase2LifetimeSeconds;
            return this;
        }

        public final String getPreSharedKey() {
            return this.preSharedKey;
        }

        public final void setPreSharedKey(String preSharedKey) {
            this.preSharedKey = preSharedKey;
        }

        @Override
        @Transient
        public final Builder preSharedKey(String preSharedKey) {
            this.preSharedKey = preSharedKey;
            return this;
        }

        public final Integer getRekeyFuzzPercentage() {
            return this.rekeyFuzzPercentage;
        }

        public final void setRekeyFuzzPercentage(Integer rekeyFuzzPercentage) {
            this.rekeyFuzzPercentage = rekeyFuzzPercentage;
        }

        @Override
        @Transient
        public final Builder rekeyFuzzPercentage(Integer rekeyFuzzPercentage) {
            this.rekeyFuzzPercentage = rekeyFuzzPercentage;
            return this;
        }

        public final Integer getRekeyMarginTimeSeconds() {
            return this.rekeyMarginTimeSeconds;
        }

        public final void setRekeyMarginTimeSeconds(Integer rekeyMarginTimeSeconds) {
            this.rekeyMarginTimeSeconds = rekeyMarginTimeSeconds;
        }

        @Override
        @Transient
        public final Builder rekeyMarginTimeSeconds(Integer rekeyMarginTimeSeconds) {
            this.rekeyMarginTimeSeconds = rekeyMarginTimeSeconds;
            return this;
        }

        public final Integer getReplayWindowSize() {
            return this.replayWindowSize;
        }

        public final void setReplayWindowSize(Integer replayWindowSize) {
            this.replayWindowSize = replayWindowSize;
        }

        @Override
        @Transient
        public final Builder replayWindowSize(Integer replayWindowSize) {
            this.replayWindowSize = replayWindowSize;
            return this;
        }

        public final String getTunnelInsideCidr() {
            return this.tunnelInsideCidr;
        }

        public final void setTunnelInsideCidr(String tunnelInsideCidr) {
            this.tunnelInsideCidr = tunnelInsideCidr;
        }

        @Override
        @Transient
        public final Builder tunnelInsideCidr(String tunnelInsideCidr) {
            this.tunnelInsideCidr = tunnelInsideCidr;
            return this;
        }

        public AwsEc2VpnConnectionOptionsTunnelOptionsDetails build() {
            return new AwsEc2VpnConnectionOptionsTunnelOptionsDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2VpnConnectionOptionsTunnelOptionsDetails> {
        public Builder dpdTimeoutSeconds(Integer var1);

        public Builder ikeVersions(Collection<String> var1);

        public Builder ikeVersions(String ... var1);

        public Builder outsideIpAddress(String var1);

        public Builder phase1DhGroupNumbers(Collection<Integer> var1);

        public Builder phase1DhGroupNumbers(Integer ... var1);

        public Builder phase1EncryptionAlgorithms(Collection<String> var1);

        public Builder phase1EncryptionAlgorithms(String ... var1);

        public Builder phase1IntegrityAlgorithms(Collection<String> var1);

        public Builder phase1IntegrityAlgorithms(String ... var1);

        public Builder phase1LifetimeSeconds(Integer var1);

        public Builder phase2DhGroupNumbers(Collection<Integer> var1);

        public Builder phase2DhGroupNumbers(Integer ... var1);

        public Builder phase2EncryptionAlgorithms(Collection<String> var1);

        public Builder phase2EncryptionAlgorithms(String ... var1);

        public Builder phase2IntegrityAlgorithms(Collection<String> var1);

        public Builder phase2IntegrityAlgorithms(String ... var1);

        public Builder phase2LifetimeSeconds(Integer var1);

        public Builder preSharedKey(String var1);

        public Builder rekeyFuzzPercentage(Integer var1);

        public Builder rekeyMarginTimeSeconds(Integer var1);

        public Builder replayWindowSize(Integer var1);

        public Builder tunnelInsideCidr(String var1);
    }
}

