/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SoftwarePackage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SoftwarePackage> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SoftwarePackage.getter(SoftwarePackage::name)).setter(SoftwarePackage.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(SoftwarePackage.getter(SoftwarePackage::version)).setter(SoftwarePackage.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> EPOCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Epoch").getter(SoftwarePackage.getter(SoftwarePackage::epoch)).setter(SoftwarePackage.setter(Builder::epoch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Epoch").build()}).build();
    private static final SdkField<String> RELEASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Release").getter(SoftwarePackage.getter(SoftwarePackage::release)).setter(SoftwarePackage.setter(Builder::release)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Release").build()}).build();
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Architecture").getter(SoftwarePackage.getter(SoftwarePackage::architecture)).setter(SoftwarePackage.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_FIELD, EPOCH_FIELD, RELEASE_FIELD, ARCHITECTURE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String version;
    private final String epoch;
    private final String release;
    private final String architecture;

    private SoftwarePackage(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.epoch = builder.epoch;
        this.release = builder.release;
        this.architecture = builder.architecture;
    }

    public final String name() {
        return this.name;
    }

    public final String version() {
        return this.version;
    }

    public final String epoch() {
        return this.epoch;
    }

    public final String release() {
        return this.release;
    }

    public final String architecture() {
        return this.architecture;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.epoch());
        hashCode = 31 * hashCode + Objects.hashCode(this.release());
        hashCode = 31 * hashCode + Objects.hashCode(this.architecture());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SoftwarePackage)) {
            return false;
        }
        SoftwarePackage other = (SoftwarePackage)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.epoch(), other.epoch()) && Objects.equals(this.release(), other.release()) && Objects.equals(this.architecture(), other.architecture());
    }

    public final String toString() {
        return ToString.builder((String)"SoftwarePackage").add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("Epoch", (Object)this.epoch()).add("Release", (Object)this.release()).add("Architecture", (Object)this.architecture()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Epoch": {
                return Optional.ofNullable(clazz.cast(this.epoch()));
            }
            case "Release": {
                return Optional.ofNullable(clazz.cast(this.release()));
            }
            case "Architecture": {
                return Optional.ofNullable(clazz.cast(this.architecture()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SoftwarePackage, T> g) {
        return obj -> g.apply((SoftwarePackage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String version;
        private String epoch;
        private String release;
        private String architecture;

        private BuilderImpl() {
        }

        private BuilderImpl(SoftwarePackage model) {
            this.name(model.name);
            this.version(model.version);
            this.epoch(model.epoch);
            this.release(model.release);
            this.architecture(model.architecture);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getEpoch() {
            return this.epoch;
        }

        public final void setEpoch(String epoch) {
            this.epoch = epoch;
        }

        @Override
        @Transient
        public final Builder epoch(String epoch) {
            this.epoch = epoch;
            return this;
        }

        public final String getRelease() {
            return this.release;
        }

        public final void setRelease(String release) {
            this.release = release;
        }

        @Override
        @Transient
        public final Builder release(String release) {
            this.release = release;
            return this;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        @Transient
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public SoftwarePackage build() {
            return new SoftwarePackage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SoftwarePackage> {
        public Builder name(String var1);

        public Builder version(String var1);

        public Builder epoch(String var1);

        public Builder release(String var1);

        public Builder architecture(String var1);
    }
}

