/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SoftwarePackage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SoftwarePackage> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SoftwarePackage.getter(SoftwarePackage::name)).setter(SoftwarePackage.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(SoftwarePackage.getter(SoftwarePackage::version)).setter(SoftwarePackage.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> EPOCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Epoch").getter(SoftwarePackage.getter(SoftwarePackage::epoch)).setter(SoftwarePackage.setter(Builder::epoch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Epoch").build()}).build();
    private static final SdkField<String> RELEASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Release").getter(SoftwarePackage.getter(SoftwarePackage::release)).setter(SoftwarePackage.setter(Builder::release)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Release").build()}).build();
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Architecture").getter(SoftwarePackage.getter(SoftwarePackage::architecture)).setter(SoftwarePackage.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture").build()}).build();
    private static final SdkField<String> PACKAGE_MANAGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageManager").getter(SoftwarePackage.getter(SoftwarePackage::packageManager)).setter(SoftwarePackage.setter(Builder::packageManager)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageManager").build()}).build();
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilePath").getter(SoftwarePackage.getter(SoftwarePackage::filePath)).setter(SoftwarePackage.setter(Builder::filePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilePath").build()}).build();
    private static final SdkField<String> FIXED_IN_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FixedInVersion").getter(SoftwarePackage.getter(SoftwarePackage::fixedInVersion)).setter(SoftwarePackage.setter(Builder::fixedInVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedInVersion").build()}).build();
    private static final SdkField<String> REMEDIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Remediation").getter(SoftwarePackage.getter(SoftwarePackage::remediation)).setter(SoftwarePackage.setter(Builder::remediation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Remediation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_FIELD, EPOCH_FIELD, RELEASE_FIELD, ARCHITECTURE_FIELD, PACKAGE_MANAGER_FIELD, FILE_PATH_FIELD, FIXED_IN_VERSION_FIELD, REMEDIATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String version;
    private final String epoch;
    private final String release;
    private final String architecture;
    private final String packageManager;
    private final String filePath;
    private final String fixedInVersion;
    private final String remediation;

    private SoftwarePackage(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.epoch = builder.epoch;
        this.release = builder.release;
        this.architecture = builder.architecture;
        this.packageManager = builder.packageManager;
        this.filePath = builder.filePath;
        this.fixedInVersion = builder.fixedInVersion;
        this.remediation = builder.remediation;
    }

    public final String name() {
        return this.name;
    }

    public final String version() {
        return this.version;
    }

    public final String epoch() {
        return this.epoch;
    }

    public final String release() {
        return this.release;
    }

    public final String architecture() {
        return this.architecture;
    }

    public final String packageManager() {
        return this.packageManager;
    }

    public final String filePath() {
        return this.filePath;
    }

    public final String fixedInVersion() {
        return this.fixedInVersion;
    }

    public final String remediation() {
        return this.remediation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.epoch());
        hashCode = 31 * hashCode + Objects.hashCode(this.release());
        hashCode = 31 * hashCode + Objects.hashCode(this.architecture());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageManager());
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedInVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SoftwarePackage)) {
            return false;
        }
        SoftwarePackage other = (SoftwarePackage)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.epoch(), other.epoch()) && Objects.equals(this.release(), other.release()) && Objects.equals(this.architecture(), other.architecture()) && Objects.equals(this.packageManager(), other.packageManager()) && Objects.equals(this.filePath(), other.filePath()) && Objects.equals(this.fixedInVersion(), other.fixedInVersion()) && Objects.equals(this.remediation(), other.remediation());
    }

    public final String toString() {
        return ToString.builder((String)"SoftwarePackage").add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("Epoch", (Object)this.epoch()).add("Release", (Object)this.release()).add("Architecture", (Object)this.architecture()).add("PackageManager", (Object)this.packageManager()).add("FilePath", (Object)this.filePath()).add("FixedInVersion", (Object)this.fixedInVersion()).add("Remediation", (Object)this.remediation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Epoch": {
                return Optional.ofNullable(clazz.cast(this.epoch()));
            }
            case "Release": {
                return Optional.ofNullable(clazz.cast(this.release()));
            }
            case "Architecture": {
                return Optional.ofNullable(clazz.cast(this.architecture()));
            }
            case "PackageManager": {
                return Optional.ofNullable(clazz.cast(this.packageManager()));
            }
            case "FilePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "FixedInVersion": {
                return Optional.ofNullable(clazz.cast(this.fixedInVersion()));
            }
            case "Remediation": {
                return Optional.ofNullable(clazz.cast(this.remediation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SoftwarePackage, T> g) {
        return obj -> g.apply((SoftwarePackage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String version;
        private String epoch;
        private String release;
        private String architecture;
        private String packageManager;
        private String filePath;
        private String fixedInVersion;
        private String remediation;

        private BuilderImpl() {
        }

        private BuilderImpl(SoftwarePackage model) {
            this.name(model.name);
            this.version(model.version);
            this.epoch(model.epoch);
            this.release(model.release);
            this.architecture(model.architecture);
            this.packageManager(model.packageManager);
            this.filePath(model.filePath);
            this.fixedInVersion(model.fixedInVersion);
            this.remediation(model.remediation);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getEpoch() {
            return this.epoch;
        }

        public final void setEpoch(String epoch) {
            this.epoch = epoch;
        }

        @Override
        public final Builder epoch(String epoch) {
            this.epoch = epoch;
            return this;
        }

        public final String getRelease() {
            return this.release;
        }

        public final void setRelease(String release) {
            this.release = release;
        }

        @Override
        public final Builder release(String release) {
            this.release = release;
            return this;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final String getPackageManager() {
            return this.packageManager;
        }

        public final void setPackageManager(String packageManager) {
            this.packageManager = packageManager;
        }

        @Override
        public final Builder packageManager(String packageManager) {
            this.packageManager = packageManager;
            return this;
        }

        public final String getFilePath() {
            return this.filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getFixedInVersion() {
            return this.fixedInVersion;
        }

        public final void setFixedInVersion(String fixedInVersion) {
            this.fixedInVersion = fixedInVersion;
        }

        @Override
        public final Builder fixedInVersion(String fixedInVersion) {
            this.fixedInVersion = fixedInVersion;
            return this;
        }

        public final String getRemediation() {
            return this.remediation;
        }

        public final void setRemediation(String remediation) {
            this.remediation = remediation;
        }

        @Override
        public final Builder remediation(String remediation) {
            this.remediation = remediation;
            return this;
        }

        public SoftwarePackage build() {
            return new SoftwarePackage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SoftwarePackage> {
        public Builder name(String var1);

        public Builder version(String var1);

        public Builder epoch(String var1);

        public Builder release(String var1);

        public Builder architecture(String var1);

        public Builder packageManager(String var1);

        public Builder filePath(String var1);

        public Builder fixedInVersion(String var1);

        public Builder remediation(String var1);
    }
}

