/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironment;
import software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigDetails;
import software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectSource;
import software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectVpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsCodeBuildProjectDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsCodeBuildProjectDetails> {
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKey").getter(AwsCodeBuildProjectDetails.getter(AwsCodeBuildProjectDetails::encryptionKey)).setter(AwsCodeBuildProjectDetails.setter(Builder::encryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKey").build()}).build();
    private static final SdkField<List<AwsCodeBuildProjectArtifactsDetails>> ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Artifacts").getter(AwsCodeBuildProjectDetails.getter(AwsCodeBuildProjectDetails::artifacts)).setter(AwsCodeBuildProjectDetails.setter(Builder::artifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Artifacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsCodeBuildProjectArtifactsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsCodeBuildProjectEnvironment> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Environment").getter(AwsCodeBuildProjectDetails.getter(AwsCodeBuildProjectDetails::environment)).setter(AwsCodeBuildProjectDetails.setter(Builder::environment)).constructor(AwsCodeBuildProjectEnvironment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AwsCodeBuildProjectDetails.getter(AwsCodeBuildProjectDetails::name)).setter(AwsCodeBuildProjectDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<AwsCodeBuildProjectSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(AwsCodeBuildProjectDetails.getter(AwsCodeBuildProjectDetails::source)).setter(AwsCodeBuildProjectDetails.setter(Builder::source)).constructor(AwsCodeBuildProjectSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRole").getter(AwsCodeBuildProjectDetails.getter(AwsCodeBuildProjectDetails::serviceRole)).setter(AwsCodeBuildProjectDetails.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()}).build();
    private static final SdkField<AwsCodeBuildProjectLogsConfigDetails> LOGS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogsConfig").getter(AwsCodeBuildProjectDetails.getter(AwsCodeBuildProjectDetails::logsConfig)).setter(AwsCodeBuildProjectDetails.setter(Builder::logsConfig)).constructor(AwsCodeBuildProjectLogsConfigDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogsConfig").build()}).build();
    private static final SdkField<AwsCodeBuildProjectVpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(AwsCodeBuildProjectDetails.getter(AwsCodeBuildProjectDetails::vpcConfig)).setter(AwsCodeBuildProjectDetails.setter(Builder::vpcConfig)).constructor(AwsCodeBuildProjectVpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_KEY_FIELD, ARTIFACTS_FIELD, ENVIRONMENT_FIELD, NAME_FIELD, SOURCE_FIELD, SERVICE_ROLE_FIELD, LOGS_CONFIG_FIELD, VPC_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String encryptionKey;
    private final List<AwsCodeBuildProjectArtifactsDetails> artifacts;
    private final AwsCodeBuildProjectEnvironment environment;
    private final String name;
    private final AwsCodeBuildProjectSource source;
    private final String serviceRole;
    private final AwsCodeBuildProjectLogsConfigDetails logsConfig;
    private final AwsCodeBuildProjectVpcConfig vpcConfig;

    private AwsCodeBuildProjectDetails(BuilderImpl builder) {
        this.encryptionKey = builder.encryptionKey;
        this.artifacts = builder.artifacts;
        this.environment = builder.environment;
        this.name = builder.name;
        this.source = builder.source;
        this.serviceRole = builder.serviceRole;
        this.logsConfig = builder.logsConfig;
        this.vpcConfig = builder.vpcConfig;
    }

    public final String encryptionKey() {
        return this.encryptionKey;
    }

    public final boolean hasArtifacts() {
        return this.artifacts != null && !(this.artifacts instanceof SdkAutoConstructList);
    }

    public final List<AwsCodeBuildProjectArtifactsDetails> artifacts() {
        return this.artifacts;
    }

    public final AwsCodeBuildProjectEnvironment environment() {
        return this.environment;
    }

    public final String name() {
        return this.name;
    }

    public final AwsCodeBuildProjectSource source() {
        return this.source;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final AwsCodeBuildProjectLogsConfigDetails logsConfig() {
        return this.logsConfig;
    }

    public final AwsCodeBuildProjectVpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArtifacts() ? this.artifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.logsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCodeBuildProjectDetails)) {
            return false;
        }
        AwsCodeBuildProjectDetails other = (AwsCodeBuildProjectDetails)obj;
        return Objects.equals(this.encryptionKey(), other.encryptionKey()) && this.hasArtifacts() == other.hasArtifacts() && Objects.equals(this.artifacts(), other.artifacts()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.logsConfig(), other.logsConfig()) && Objects.equals(this.vpcConfig(), other.vpcConfig());
    }

    public final String toString() {
        return ToString.builder((String)"AwsCodeBuildProjectDetails").add("EncryptionKey", (Object)this.encryptionKey()).add("Artifacts", this.hasArtifacts() ? this.artifacts() : null).add("Environment", (Object)this.environment()).add("Name", (Object)this.name()).add("Source", (Object)this.source()).add("ServiceRole", (Object)this.serviceRole()).add("LogsConfig", (Object)this.logsConfig()).add("VpcConfig", (Object)this.vpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "Artifacts": {
                return Optional.ofNullable(clazz.cast(this.artifacts()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "ServiceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "LogsConfig": {
                return Optional.ofNullable(clazz.cast(this.logsConfig()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCodeBuildProjectDetails, T> g) {
        return obj -> g.apply((AwsCodeBuildProjectDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String encryptionKey;
        private List<AwsCodeBuildProjectArtifactsDetails> artifacts = DefaultSdkAutoConstructList.getInstance();
        private AwsCodeBuildProjectEnvironment environment;
        private String name;
        private AwsCodeBuildProjectSource source;
        private String serviceRole;
        private AwsCodeBuildProjectLogsConfigDetails logsConfig;
        private AwsCodeBuildProjectVpcConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCodeBuildProjectDetails model) {
            this.encryptionKey(model.encryptionKey);
            this.artifacts(model.artifacts);
            this.environment(model.environment);
            this.name(model.name);
            this.source(model.source);
            this.serviceRole(model.serviceRole);
            this.logsConfig(model.logsConfig);
            this.vpcConfig(model.vpcConfig);
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final List<AwsCodeBuildProjectArtifactsDetails.Builder> getArtifacts() {
            List<AwsCodeBuildProjectArtifactsDetails.Builder> result = AwsCodeBuildProjectArtifactsListCopier.copyToBuilder(this.artifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArtifacts(Collection<AwsCodeBuildProjectArtifactsDetails.BuilderImpl> artifacts) {
            this.artifacts = AwsCodeBuildProjectArtifactsListCopier.copyFromBuilder(artifacts);
        }

        @Override
        public final Builder artifacts(Collection<AwsCodeBuildProjectArtifactsDetails> artifacts) {
            this.artifacts = AwsCodeBuildProjectArtifactsListCopier.copy(artifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifacts(AwsCodeBuildProjectArtifactsDetails ... artifacts) {
            this.artifacts(Arrays.asList(artifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifacts(Consumer<AwsCodeBuildProjectArtifactsDetails.Builder> ... artifacts) {
            this.artifacts(Stream.of(artifacts).map(c -> (AwsCodeBuildProjectArtifactsDetails)((AwsCodeBuildProjectArtifactsDetails.Builder)AwsCodeBuildProjectArtifactsDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AwsCodeBuildProjectEnvironment.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        public final void setEnvironment(AwsCodeBuildProjectEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        public final Builder environment(AwsCodeBuildProjectEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AwsCodeBuildProjectSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(AwsCodeBuildProjectSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(AwsCodeBuildProjectSource source) {
            this.source = source;
            return this;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final AwsCodeBuildProjectLogsConfigDetails.Builder getLogsConfig() {
            return this.logsConfig != null ? this.logsConfig.toBuilder() : null;
        }

        public final void setLogsConfig(AwsCodeBuildProjectLogsConfigDetails.BuilderImpl logsConfig) {
            this.logsConfig = logsConfig != null ? logsConfig.build() : null;
        }

        @Override
        public final Builder logsConfig(AwsCodeBuildProjectLogsConfigDetails logsConfig) {
            this.logsConfig = logsConfig;
            return this;
        }

        public final AwsCodeBuildProjectVpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(AwsCodeBuildProjectVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(AwsCodeBuildProjectVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public AwsCodeBuildProjectDetails build() {
            return new AwsCodeBuildProjectDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsCodeBuildProjectDetails> {
        public Builder encryptionKey(String var1);

        public Builder artifacts(Collection<AwsCodeBuildProjectArtifactsDetails> var1);

        public Builder artifacts(AwsCodeBuildProjectArtifactsDetails ... var1);

        public Builder artifacts(Consumer<AwsCodeBuildProjectArtifactsDetails.Builder> ... var1);

        public Builder environment(AwsCodeBuildProjectEnvironment var1);

        default public Builder environment(Consumer<AwsCodeBuildProjectEnvironment.Builder> environment) {
            return this.environment((AwsCodeBuildProjectEnvironment)((AwsCodeBuildProjectEnvironment.Builder)AwsCodeBuildProjectEnvironment.builder().applyMutation(environment)).build());
        }

        public Builder name(String var1);

        public Builder source(AwsCodeBuildProjectSource var1);

        default public Builder source(Consumer<AwsCodeBuildProjectSource.Builder> source) {
            return this.source((AwsCodeBuildProjectSource)((AwsCodeBuildProjectSource.Builder)AwsCodeBuildProjectSource.builder().applyMutation(source)).build());
        }

        public Builder serviceRole(String var1);

        public Builder logsConfig(AwsCodeBuildProjectLogsConfigDetails var1);

        default public Builder logsConfig(Consumer<AwsCodeBuildProjectLogsConfigDetails.Builder> logsConfig) {
            return this.logsConfig((AwsCodeBuildProjectLogsConfigDetails)((AwsCodeBuildProjectLogsConfigDetails.Builder)AwsCodeBuildProjectLogsConfigDetails.builder().applyMutation(logsConfig)).build());
        }

        public Builder vpcConfig(AwsCodeBuildProjectVpcConfig var1);

        default public Builder vpcConfig(Consumer<AwsCodeBuildProjectVpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((AwsCodeBuildProjectVpcConfig)((AwsCodeBuildProjectVpcConfig.Builder)AwsCodeBuildProjectVpcConfig.builder().applyMutation(vpcConfig)).build());
        }
    }
}

