/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.SeverityLabel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Severity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Severity> {
    private static final SdkField<Double> PRODUCT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Product").getter(Severity.getter(Severity::product)).setter(Severity.setter(Builder::product)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Product").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Label").getter(Severity.getter(Severity::labelAsString)).setter(Severity.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<Integer> NORMALIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Normalized").getter(Severity.getter(Severity::normalized)).setter(Severity.setter(Builder::normalized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Normalized").build()}).build();
    private static final SdkField<String> ORIGINAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Original").getter(Severity.getter(Severity::original)).setter(Severity.setter(Builder::original)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Original").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_FIELD, LABEL_FIELD, NORMALIZED_FIELD, ORIGINAL_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double product;
    private final String label;
    private final Integer normalized;
    private final String original;

    private Severity(BuilderImpl builder) {
        this.product = builder.product;
        this.label = builder.label;
        this.normalized = builder.normalized;
        this.original = builder.original;
    }

    public final Double product() {
        return this.product;
    }

    public final SeverityLabel label() {
        return SeverityLabel.fromValue(this.label);
    }

    public final String labelAsString() {
        return this.label;
    }

    public final Integer normalized() {
        return this.normalized;
    }

    public final String original() {
        return this.original;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.product());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.normalized());
        hashCode = 31 * hashCode + Objects.hashCode(this.original());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Severity)) {
            return false;
        }
        Severity other = (Severity)obj;
        return Objects.equals(this.product(), other.product()) && Objects.equals(this.labelAsString(), other.labelAsString()) && Objects.equals(this.normalized(), other.normalized()) && Objects.equals(this.original(), other.original());
    }

    public final String toString() {
        return ToString.builder((String)"Severity").add("Product", (Object)this.product()).add("Label", (Object)this.labelAsString()).add("Normalized", (Object)this.normalized()).add("Original", (Object)this.original()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Product": {
                return Optional.ofNullable(clazz.cast(this.product()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.labelAsString()));
            }
            case "Normalized": {
                return Optional.ofNullable(clazz.cast(this.normalized()));
            }
            case "Original": {
                return Optional.ofNullable(clazz.cast(this.original()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Severity, T> g) {
        return obj -> g.apply((Severity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double product;
        private String label;
        private Integer normalized;
        private String original;

        private BuilderImpl() {
        }

        private BuilderImpl(Severity model) {
            this.product(model.product);
            this.label(model.label);
            this.normalized(model.normalized);
            this.original(model.original);
        }

        public final Double getProduct() {
            return this.product;
        }

        public final void setProduct(Double product) {
            this.product = product;
        }

        @Override
        @Transient
        public final Builder product(Double product) {
            this.product = product;
            return this;
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        @Transient
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        @Override
        @Transient
        public final Builder label(SeverityLabel label) {
            this.label(label == null ? null : label.toString());
            return this;
        }

        public final Integer getNormalized() {
            return this.normalized;
        }

        public final void setNormalized(Integer normalized) {
            this.normalized = normalized;
        }

        @Override
        @Transient
        public final Builder normalized(Integer normalized) {
            this.normalized = normalized;
            return this;
        }

        public final String getOriginal() {
            return this.original;
        }

        public final void setOriginal(String original) {
            this.original = original;
        }

        @Override
        @Transient
        public final Builder original(String original) {
            this.original = original;
            return this;
        }

        public Severity build() {
            return new Severity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Severity> {
        public Builder product(Double var1);

        public Builder label(String var1);

        public Builder label(SeverityLabel var1);

        public Builder normalized(Integer var1);

        public Builder original(String var1);
    }
}

