/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MalwareState {
    OBSERVED("OBSERVED"),
    REMOVAL_FAILED("REMOVAL_FAILED"),
    REMOVED("REMOVED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MalwareState> VALUE_MAP;
    private final String value;

    private MalwareState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MalwareState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MalwareState> knownValues() {
        EnumSet<MalwareState> knownValues = EnumSet.allOf(MalwareState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MalwareState.class, MalwareState::toString);
    }
}

