/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsEc2VpcEndpointServiceServiceTypeDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEc2VpcEndpointServiceServiceTypeListCopier;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2VpcEndpointServiceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2VpcEndpointServiceDetails> {
    private static final SdkField<Boolean> ACCEPTANCE_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AcceptanceRequired").getter(AwsEc2VpcEndpointServiceDetails.getter(AwsEc2VpcEndpointServiceDetails::acceptanceRequired)).setter(AwsEc2VpcEndpointServiceDetails.setter(Builder::acceptanceRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceRequired").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(AwsEc2VpcEndpointServiceDetails.getter(AwsEc2VpcEndpointServiceDetails::availabilityZones)).setter(AwsEc2VpcEndpointServiceDetails.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BASE_ENDPOINT_DNS_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BaseEndpointDnsNames").getter(AwsEc2VpcEndpointServiceDetails.getter(AwsEc2VpcEndpointServiceDetails::baseEndpointDnsNames)).setter(AwsEc2VpcEndpointServiceDetails.setter(Builder::baseEndpointDnsNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseEndpointDnsNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MANAGES_VPC_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ManagesVpcEndpoints").getter(AwsEc2VpcEndpointServiceDetails.getter(AwsEc2VpcEndpointServiceDetails::managesVpcEndpoints)).setter(AwsEc2VpcEndpointServiceDetails.setter(Builder::managesVpcEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagesVpcEndpoints").build()}).build();
    private static final SdkField<List<String>> GATEWAY_LOAD_BALANCER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GatewayLoadBalancerArns").getter(AwsEc2VpcEndpointServiceDetails.getter(AwsEc2VpcEndpointServiceDetails::gatewayLoadBalancerArns)).setter(AwsEc2VpcEndpointServiceDetails.setter(Builder::gatewayLoadBalancerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayLoadBalancerArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NETWORK_LOAD_BALANCER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkLoadBalancerArns").getter(AwsEc2VpcEndpointServiceDetails.getter(AwsEc2VpcEndpointServiceDetails::networkLoadBalancerArns)).setter(AwsEc2VpcEndpointServiceDetails.setter(Builder::networkLoadBalancerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkLoadBalancerArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateDnsName").getter(AwsEc2VpcEndpointServiceDetails.getter(AwsEc2VpcEndpointServiceDetails::privateDnsName)).setter(AwsEc2VpcEndpointServiceDetails.setter(Builder::privateDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName").build()}).build();
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceId").getter(AwsEc2VpcEndpointServiceDetails.getter(AwsEc2VpcEndpointServiceDetails::serviceId)).setter(AwsEc2VpcEndpointServiceDetails.setter(Builder::serviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(AwsEc2VpcEndpointServiceDetails.getter(AwsEc2VpcEndpointServiceDetails::serviceName)).setter(AwsEc2VpcEndpointServiceDetails.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<String> SERVICE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceState").getter(AwsEc2VpcEndpointServiceDetails.getter(AwsEc2VpcEndpointServiceDetails::serviceState)).setter(AwsEc2VpcEndpointServiceDetails.setter(Builder::serviceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceState").build()}).build();
    private static final SdkField<List<AwsEc2VpcEndpointServiceServiceTypeDetails>> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceType").getter(AwsEc2VpcEndpointServiceDetails.getter(AwsEc2VpcEndpointServiceDetails::serviceType)).setter(AwsEc2VpcEndpointServiceDetails.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2VpcEndpointServiceServiceTypeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTANCE_REQUIRED_FIELD, AVAILABILITY_ZONES_FIELD, BASE_ENDPOINT_DNS_NAMES_FIELD, MANAGES_VPC_ENDPOINTS_FIELD, GATEWAY_LOAD_BALANCER_ARNS_FIELD, NETWORK_LOAD_BALANCER_ARNS_FIELD, PRIVATE_DNS_NAME_FIELD, SERVICE_ID_FIELD, SERVICE_NAME_FIELD, SERVICE_STATE_FIELD, SERVICE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean acceptanceRequired;
    private final List<String> availabilityZones;
    private final List<String> baseEndpointDnsNames;
    private final Boolean managesVpcEndpoints;
    private final List<String> gatewayLoadBalancerArns;
    private final List<String> networkLoadBalancerArns;
    private final String privateDnsName;
    private final String serviceId;
    private final String serviceName;
    private final String serviceState;
    private final List<AwsEc2VpcEndpointServiceServiceTypeDetails> serviceType;

    private AwsEc2VpcEndpointServiceDetails(BuilderImpl builder) {
        this.acceptanceRequired = builder.acceptanceRequired;
        this.availabilityZones = builder.availabilityZones;
        this.baseEndpointDnsNames = builder.baseEndpointDnsNames;
        this.managesVpcEndpoints = builder.managesVpcEndpoints;
        this.gatewayLoadBalancerArns = builder.gatewayLoadBalancerArns;
        this.networkLoadBalancerArns = builder.networkLoadBalancerArns;
        this.privateDnsName = builder.privateDnsName;
        this.serviceId = builder.serviceId;
        this.serviceName = builder.serviceName;
        this.serviceState = builder.serviceState;
        this.serviceType = builder.serviceType;
    }

    public final Boolean acceptanceRequired() {
        return this.acceptanceRequired;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final boolean hasBaseEndpointDnsNames() {
        return this.baseEndpointDnsNames != null && !(this.baseEndpointDnsNames instanceof SdkAutoConstructList);
    }

    public final List<String> baseEndpointDnsNames() {
        return this.baseEndpointDnsNames;
    }

    public final Boolean managesVpcEndpoints() {
        return this.managesVpcEndpoints;
    }

    public final boolean hasGatewayLoadBalancerArns() {
        return this.gatewayLoadBalancerArns != null && !(this.gatewayLoadBalancerArns instanceof SdkAutoConstructList);
    }

    public final List<String> gatewayLoadBalancerArns() {
        return this.gatewayLoadBalancerArns;
    }

    public final boolean hasNetworkLoadBalancerArns() {
        return this.networkLoadBalancerArns != null && !(this.networkLoadBalancerArns instanceof SdkAutoConstructList);
    }

    public final List<String> networkLoadBalancerArns() {
        return this.networkLoadBalancerArns;
    }

    public final String privateDnsName() {
        return this.privateDnsName;
    }

    public final String serviceId() {
        return this.serviceId;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String serviceState() {
        return this.serviceState;
    }

    public final boolean hasServiceType() {
        return this.serviceType != null && !(this.serviceType instanceof SdkAutoConstructList);
    }

    public final List<AwsEc2VpcEndpointServiceServiceTypeDetails> serviceType() {
        return this.serviceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBaseEndpointDnsNames() ? this.baseEndpointDnsNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.managesVpcEndpoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGatewayLoadBalancerArns() ? this.gatewayLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkLoadBalancerArns() ? this.networkLoadBalancerArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceState());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceType() ? this.serviceType() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2VpcEndpointServiceDetails)) {
            return false;
        }
        AwsEc2VpcEndpointServiceDetails other = (AwsEc2VpcEndpointServiceDetails)obj;
        return Objects.equals(this.acceptanceRequired(), other.acceptanceRequired()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && this.hasBaseEndpointDnsNames() == other.hasBaseEndpointDnsNames() && Objects.equals(this.baseEndpointDnsNames(), other.baseEndpointDnsNames()) && Objects.equals(this.managesVpcEndpoints(), other.managesVpcEndpoints()) && this.hasGatewayLoadBalancerArns() == other.hasGatewayLoadBalancerArns() && Objects.equals(this.gatewayLoadBalancerArns(), other.gatewayLoadBalancerArns()) && this.hasNetworkLoadBalancerArns() == other.hasNetworkLoadBalancerArns() && Objects.equals(this.networkLoadBalancerArns(), other.networkLoadBalancerArns()) && Objects.equals(this.privateDnsName(), other.privateDnsName()) && Objects.equals(this.serviceId(), other.serviceId()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceState(), other.serviceState()) && this.hasServiceType() == other.hasServiceType() && Objects.equals(this.serviceType(), other.serviceType());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2VpcEndpointServiceDetails").add("AcceptanceRequired", (Object)this.acceptanceRequired()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("BaseEndpointDnsNames", this.hasBaseEndpointDnsNames() ? this.baseEndpointDnsNames() : null).add("ManagesVpcEndpoints", (Object)this.managesVpcEndpoints()).add("GatewayLoadBalancerArns", this.hasGatewayLoadBalancerArns() ? this.gatewayLoadBalancerArns() : null).add("NetworkLoadBalancerArns", this.hasNetworkLoadBalancerArns() ? this.networkLoadBalancerArns() : null).add("PrivateDnsName", (Object)this.privateDnsName()).add("ServiceId", (Object)this.serviceId()).add("ServiceName", (Object)this.serviceName()).add("ServiceState", (Object)this.serviceState()).add("ServiceType", this.hasServiceType() ? this.serviceType() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptanceRequired": {
                return Optional.ofNullable(clazz.cast(this.acceptanceRequired()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "BaseEndpointDnsNames": {
                return Optional.ofNullable(clazz.cast(this.baseEndpointDnsNames()));
            }
            case "ManagesVpcEndpoints": {
                return Optional.ofNullable(clazz.cast(this.managesVpcEndpoints()));
            }
            case "GatewayLoadBalancerArns": {
                return Optional.ofNullable(clazz.cast(this.gatewayLoadBalancerArns()));
            }
            case "NetworkLoadBalancerArns": {
                return Optional.ofNullable(clazz.cast(this.networkLoadBalancerArns()));
            }
            case "PrivateDnsName": {
                return Optional.ofNullable(clazz.cast(this.privateDnsName()));
            }
            case "ServiceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "ServiceState": {
                return Optional.ofNullable(clazz.cast(this.serviceState()));
            }
            case "ServiceType": {
                return Optional.ofNullable(clazz.cast(this.serviceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2VpcEndpointServiceDetails, T> g) {
        return obj -> g.apply((AwsEc2VpcEndpointServiceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean acceptanceRequired;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<String> baseEndpointDnsNames = DefaultSdkAutoConstructList.getInstance();
        private Boolean managesVpcEndpoints;
        private List<String> gatewayLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> networkLoadBalancerArns = DefaultSdkAutoConstructList.getInstance();
        private String privateDnsName;
        private String serviceId;
        private String serviceName;
        private String serviceState;
        private List<AwsEc2VpcEndpointServiceServiceTypeDetails> serviceType = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2VpcEndpointServiceDetails model) {
            this.acceptanceRequired(model.acceptanceRequired);
            this.availabilityZones(model.availabilityZones);
            this.baseEndpointDnsNames(model.baseEndpointDnsNames);
            this.managesVpcEndpoints(model.managesVpcEndpoints);
            this.gatewayLoadBalancerArns(model.gatewayLoadBalancerArns);
            this.networkLoadBalancerArns(model.networkLoadBalancerArns);
            this.privateDnsName(model.privateDnsName);
            this.serviceId(model.serviceId);
            this.serviceName(model.serviceName);
            this.serviceState(model.serviceState);
            this.serviceType(model.serviceType);
        }

        public final Boolean getAcceptanceRequired() {
            return this.acceptanceRequired;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        @Override
        @Transient
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = NonEmptyStringListCopier.copy(availabilityZones);
        }

        @Override
        @Transient
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = NonEmptyStringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Collection<String> getBaseEndpointDnsNames() {
            if (this.baseEndpointDnsNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.baseEndpointDnsNames;
        }

        public final void setBaseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = NonEmptyStringListCopier.copy(baseEndpointDnsNames);
        }

        @Override
        @Transient
        public final Builder baseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
            this.baseEndpointDnsNames = NonEmptyStringListCopier.copy(baseEndpointDnsNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder baseEndpointDnsNames(String ... baseEndpointDnsNames) {
            this.baseEndpointDnsNames(Arrays.asList(baseEndpointDnsNames));
            return this;
        }

        public final Boolean getManagesVpcEndpoints() {
            return this.managesVpcEndpoints;
        }

        public final void setManagesVpcEndpoints(Boolean managesVpcEndpoints) {
            this.managesVpcEndpoints = managesVpcEndpoints;
        }

        @Override
        @Transient
        public final Builder managesVpcEndpoints(Boolean managesVpcEndpoints) {
            this.managesVpcEndpoints = managesVpcEndpoints;
            return this;
        }

        public final Collection<String> getGatewayLoadBalancerArns() {
            if (this.gatewayLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.gatewayLoadBalancerArns;
        }

        public final void setGatewayLoadBalancerArns(Collection<String> gatewayLoadBalancerArns) {
            this.gatewayLoadBalancerArns = NonEmptyStringListCopier.copy(gatewayLoadBalancerArns);
        }

        @Override
        @Transient
        public final Builder gatewayLoadBalancerArns(Collection<String> gatewayLoadBalancerArns) {
            this.gatewayLoadBalancerArns = NonEmptyStringListCopier.copy(gatewayLoadBalancerArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder gatewayLoadBalancerArns(String ... gatewayLoadBalancerArns) {
            this.gatewayLoadBalancerArns(Arrays.asList(gatewayLoadBalancerArns));
            return this;
        }

        public final Collection<String> getNetworkLoadBalancerArns() {
            if (this.networkLoadBalancerArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkLoadBalancerArns;
        }

        public final void setNetworkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
            this.networkLoadBalancerArns = NonEmptyStringListCopier.copy(networkLoadBalancerArns);
        }

        @Override
        @Transient
        public final Builder networkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
            this.networkLoadBalancerArns = NonEmptyStringListCopier.copy(networkLoadBalancerArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkLoadBalancerArns(String ... networkLoadBalancerArns) {
            this.networkLoadBalancerArns(Arrays.asList(networkLoadBalancerArns));
            return this;
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        @Override
        @Transient
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        @Transient
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        @Transient
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceState() {
            return this.serviceState;
        }

        public final void setServiceState(String serviceState) {
            this.serviceState = serviceState;
        }

        @Override
        @Transient
        public final Builder serviceState(String serviceState) {
            this.serviceState = serviceState;
            return this;
        }

        public final List<AwsEc2VpcEndpointServiceServiceTypeDetails.Builder> getServiceType() {
            List<AwsEc2VpcEndpointServiceServiceTypeDetails.Builder> result = AwsEc2VpcEndpointServiceServiceTypeListCopier.copyToBuilder(this.serviceType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceType(Collection<AwsEc2VpcEndpointServiceServiceTypeDetails.BuilderImpl> serviceType) {
            this.serviceType = AwsEc2VpcEndpointServiceServiceTypeListCopier.copyFromBuilder(serviceType);
        }

        @Override
        @Transient
        public final Builder serviceType(Collection<AwsEc2VpcEndpointServiceServiceTypeDetails> serviceType) {
            this.serviceType = AwsEc2VpcEndpointServiceServiceTypeListCopier.copy(serviceType);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder serviceType(AwsEc2VpcEndpointServiceServiceTypeDetails ... serviceType) {
            this.serviceType(Arrays.asList(serviceType));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder serviceType(Consumer<AwsEc2VpcEndpointServiceServiceTypeDetails.Builder> ... serviceType) {
            this.serviceType(Stream.of(serviceType).map(c -> (AwsEc2VpcEndpointServiceServiceTypeDetails)((AwsEc2VpcEndpointServiceServiceTypeDetails.Builder)AwsEc2VpcEndpointServiceServiceTypeDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsEc2VpcEndpointServiceDetails build() {
            return new AwsEc2VpcEndpointServiceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2VpcEndpointServiceDetails> {
        public Builder acceptanceRequired(Boolean var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder baseEndpointDnsNames(Collection<String> var1);

        public Builder baseEndpointDnsNames(String ... var1);

        public Builder managesVpcEndpoints(Boolean var1);

        public Builder gatewayLoadBalancerArns(Collection<String> var1);

        public Builder gatewayLoadBalancerArns(String ... var1);

        public Builder networkLoadBalancerArns(Collection<String> var1);

        public Builder networkLoadBalancerArns(String ... var1);

        public Builder privateDnsName(String var1);

        public Builder serviceId(String var1);

        public Builder serviceName(String var1);

        public Builder serviceState(String var1);

        public Builder serviceType(Collection<AwsEc2VpcEndpointServiceServiceTypeDetails> var1);

        public Builder serviceType(AwsEc2VpcEndpointServiceServiceTypeDetails ... var1);

        public Builder serviceType(Consumer<AwsEc2VpcEndpointServiceServiceTypeDetails.Builder> ... var1);
    }
}

