/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.ImportFindingsError;
import software.amazon.awssdk.services.securityhub.model.ImportFindingsErrorListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchImportFindingsResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, BatchImportFindingsResponse> {
    private static final SdkField<Integer> FAILED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailedCount").getter(BatchImportFindingsResponse.getter(BatchImportFindingsResponse::failedCount)).setter(BatchImportFindingsResponse.setter(Builder::failedCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedCount").build()}).build();
    private static final SdkField<Integer> SUCCESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SuccessCount").getter(BatchImportFindingsResponse.getter(BatchImportFindingsResponse::successCount)).setter(BatchImportFindingsResponse.setter(Builder::successCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessCount").build()}).build();
    private static final SdkField<List<ImportFindingsError>> FAILED_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedFindings").getter(BatchImportFindingsResponse.getter(BatchImportFindingsResponse::failedFindings)).setter(BatchImportFindingsResponse.setter(Builder::failedFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedFindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImportFindingsError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_COUNT_FIELD, SUCCESS_COUNT_FIELD, FAILED_FINDINGS_FIELD));
    private final Integer failedCount;
    private final Integer successCount;
    private final List<ImportFindingsError> failedFindings;

    private BatchImportFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.failedCount = builder.failedCount;
        this.successCount = builder.successCount;
        this.failedFindings = builder.failedFindings;
    }

    public final Integer failedCount() {
        return this.failedCount;
    }

    public final Integer successCount() {
        return this.successCount;
    }

    public final boolean hasFailedFindings() {
        return this.failedFindings != null && !(this.failedFindings instanceof SdkAutoConstructList);
    }

    public final List<ImportFindingsError> failedFindings() {
        return this.failedFindings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.failedCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.successCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedFindings() ? this.failedFindings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchImportFindingsResponse)) {
            return false;
        }
        BatchImportFindingsResponse other = (BatchImportFindingsResponse)((Object)obj);
        return Objects.equals(this.failedCount(), other.failedCount()) && Objects.equals(this.successCount(), other.successCount()) && this.hasFailedFindings() == other.hasFailedFindings() && Objects.equals(this.failedFindings(), other.failedFindings());
    }

    public final String toString() {
        return ToString.builder((String)"BatchImportFindingsResponse").add("FailedCount", (Object)this.failedCount()).add("SuccessCount", (Object)this.successCount()).add("FailedFindings", this.hasFailedFindings() ? this.failedFindings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedCount": {
                return Optional.ofNullable(clazz.cast(this.failedCount()));
            }
            case "SuccessCount": {
                return Optional.ofNullable(clazz.cast(this.successCount()));
            }
            case "FailedFindings": {
                return Optional.ofNullable(clazz.cast(this.failedFindings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchImportFindingsResponse, T> g) {
        return obj -> g.apply((BatchImportFindingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private Integer failedCount;
        private Integer successCount;
        private List<ImportFindingsError> failedFindings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchImportFindingsResponse model) {
            super(model);
            this.failedCount(model.failedCount);
            this.successCount(model.successCount);
            this.failedFindings(model.failedFindings);
        }

        public final Integer getFailedCount() {
            return this.failedCount;
        }

        public final void setFailedCount(Integer failedCount) {
            this.failedCount = failedCount;
        }

        @Override
        @Transient
        public final Builder failedCount(Integer failedCount) {
            this.failedCount = failedCount;
            return this;
        }

        public final Integer getSuccessCount() {
            return this.successCount;
        }

        public final void setSuccessCount(Integer successCount) {
            this.successCount = successCount;
        }

        @Override
        @Transient
        public final Builder successCount(Integer successCount) {
            this.successCount = successCount;
            return this;
        }

        public final List<ImportFindingsError.Builder> getFailedFindings() {
            List<ImportFindingsError.Builder> result = ImportFindingsErrorListCopier.copyToBuilder(this.failedFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedFindings(Collection<ImportFindingsError.BuilderImpl> failedFindings) {
            this.failedFindings = ImportFindingsErrorListCopier.copyFromBuilder(failedFindings);
        }

        @Override
        @Transient
        public final Builder failedFindings(Collection<ImportFindingsError> failedFindings) {
            this.failedFindings = ImportFindingsErrorListCopier.copy(failedFindings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failedFindings(ImportFindingsError ... failedFindings) {
            this.failedFindings(Arrays.asList(failedFindings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failedFindings(Consumer<ImportFindingsError.Builder> ... failedFindings) {
            this.failedFindings(Stream.of(failedFindings).map(c -> (ImportFindingsError)((ImportFindingsError.Builder)ImportFindingsError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchImportFindingsResponse build() {
            return new BatchImportFindingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchImportFindingsResponse> {
        public Builder failedCount(Integer var1);

        public Builder successCount(Integer var1);

        public Builder failedFindings(Collection<ImportFindingsError> var1);

        public Builder failedFindings(ImportFindingsError ... var1);

        public Builder failedFindings(Consumer<ImportFindingsError.Builder> ... var1);
    }
}

