/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsWafWebAclRule;
import software.amazon.awssdk.services.securityhub.model.AwsWafWebAclRuleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsWafWebAclDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsWafWebAclDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AwsWafWebAclDetails.getter(AwsWafWebAclDetails::name)).setter(AwsWafWebAclDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DEFAULT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultAction").getter(AwsWafWebAclDetails.getter(AwsWafWebAclDetails::defaultAction)).setter(AwsWafWebAclDetails.setter(Builder::defaultAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAction").build()}).build();
    private static final SdkField<List<AwsWafWebAclRule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(AwsWafWebAclDetails.getter(AwsWafWebAclDetails::rules)).setter(AwsWafWebAclDetails.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsWafWebAclRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebAclId").getter(AwsWafWebAclDetails.getter(AwsWafWebAclDetails::webAclId)).setter(AwsWafWebAclDetails.setter(Builder::webAclId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAclId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DEFAULT_ACTION_FIELD, RULES_FIELD, WEB_ACL_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String defaultAction;
    private final List<AwsWafWebAclRule> rules;
    private final String webAclId;

    private AwsWafWebAclDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.defaultAction = builder.defaultAction;
        this.rules = builder.rules;
        this.webAclId = builder.webAclId;
    }

    public final String name() {
        return this.name;
    }

    public final String defaultAction() {
        return this.defaultAction;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<AwsWafWebAclRule> rules() {
        return this.rules;
    }

    public final String webAclId() {
        return this.webAclId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.webAclId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafWebAclDetails)) {
            return false;
        }
        AwsWafWebAclDetails other = (AwsWafWebAclDetails)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.defaultAction(), other.defaultAction()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.webAclId(), other.webAclId());
    }

    public final String toString() {
        return ToString.builder((String)"AwsWafWebAclDetails").add("Name", (Object)this.name()).add("DefaultAction", (Object)this.defaultAction()).add("Rules", this.hasRules() ? this.rules() : null).add("WebAclId", (Object)this.webAclId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DefaultAction": {
                return Optional.ofNullable(clazz.cast(this.defaultAction()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "WebAclId": {
                return Optional.ofNullable(clazz.cast(this.webAclId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsWafWebAclDetails, T> g) {
        return obj -> g.apply((AwsWafWebAclDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String defaultAction;
        private List<AwsWafWebAclRule> rules = DefaultSdkAutoConstructList.getInstance();
        private String webAclId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafWebAclDetails model) {
            this.name(model.name);
            this.defaultAction(model.defaultAction);
            this.rules(model.rules);
            this.webAclId(model.webAclId);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDefaultAction() {
            return this.defaultAction;
        }

        public final void setDefaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
        }

        @Override
        @Transient
        public final Builder defaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        public final List<AwsWafWebAclRule.Builder> getRules() {
            List<AwsWafWebAclRule.Builder> result = AwsWafWebAclRuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<AwsWafWebAclRule.BuilderImpl> rules) {
            this.rules = AwsWafWebAclRuleListCopier.copyFromBuilder(rules);
        }

        @Override
        @Transient
        public final Builder rules(Collection<AwsWafWebAclRule> rules) {
            this.rules = AwsWafWebAclRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rules(AwsWafWebAclRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rules(Consumer<AwsWafWebAclRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (AwsWafWebAclRule)((AwsWafWebAclRule.Builder)AwsWafWebAclRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWebAclId() {
            return this.webAclId;
        }

        public final void setWebAclId(String webAclId) {
            this.webAclId = webAclId;
        }

        @Override
        @Transient
        public final Builder webAclId(String webAclId) {
            this.webAclId = webAclId;
            return this;
        }

        public AwsWafWebAclDetails build() {
            return new AwsWafWebAclDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsWafWebAclDetails> {
        public Builder name(String var1);

        public Builder defaultAction(String var1);

        public Builder rules(Collection<AwsWafWebAclRule> var1);

        public Builder rules(AwsWafWebAclRule ... var1);

        public Builder rules(Consumer<AwsWafWebAclRule.Builder> ... var1);

        public Builder webAclId(String var1);
    }
}

