/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesRuleOptionsSettingsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleGroupSourceStatefulRulesOptionsDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleGroupSourceStatefulRulesOptionsDetails> {
    private static final SdkField<String> KEYWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Keyword").getter(RuleGroupSourceStatefulRulesOptionsDetails.getter(RuleGroupSourceStatefulRulesOptionsDetails::keyword)).setter(RuleGroupSourceStatefulRulesOptionsDetails.setter(Builder::keyword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keyword").build()}).build();
    private static final SdkField<List<String>> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Settings").getter(RuleGroupSourceStatefulRulesOptionsDetails.getter(RuleGroupSourceStatefulRulesOptionsDetails::settings)).setter(RuleGroupSourceStatefulRulesOptionsDetails.setter(Builder::settings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYWORD_FIELD, SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String keyword;
    private final List<String> settings;

    private RuleGroupSourceStatefulRulesOptionsDetails(BuilderImpl builder) {
        this.keyword = builder.keyword;
        this.settings = builder.settings;
    }

    public final String keyword() {
        return this.keyword;
    }

    public final boolean hasSettings() {
        return this.settings != null && !(this.settings instanceof SdkAutoConstructList);
    }

    public final List<String> settings() {
        return this.settings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyword());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSettings() ? this.settings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupSourceStatefulRulesOptionsDetails)) {
            return false;
        }
        RuleGroupSourceStatefulRulesOptionsDetails other = (RuleGroupSourceStatefulRulesOptionsDetails)obj;
        return Objects.equals(this.keyword(), other.keyword()) && this.hasSettings() == other.hasSettings() && Objects.equals(this.settings(), other.settings());
    }

    public final String toString() {
        return ToString.builder((String)"RuleGroupSourceStatefulRulesOptionsDetails").add("Keyword", (Object)this.keyword()).add("Settings", this.hasSettings() ? this.settings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Keyword": {
                return Optional.ofNullable(clazz.cast(this.keyword()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupSourceStatefulRulesOptionsDetails, T> g) {
        return obj -> g.apply((RuleGroupSourceStatefulRulesOptionsDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyword;
        private List<String> settings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupSourceStatefulRulesOptionsDetails model) {
            this.keyword(model.keyword);
            this.settings(model.settings);
        }

        public final String getKeyword() {
            return this.keyword;
        }

        public final void setKeyword(String keyword) {
            this.keyword = keyword;
        }

        @Override
        @Transient
        public final Builder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public final Collection<String> getSettings() {
            if (this.settings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.settings;
        }

        public final void setSettings(Collection<String> settings) {
            this.settings = RuleGroupSourceStatefulRulesRuleOptionsSettingsListCopier.copy(settings);
        }

        @Override
        @Transient
        public final Builder settings(Collection<String> settings) {
            this.settings = RuleGroupSourceStatefulRulesRuleOptionsSettingsListCopier.copy(settings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settings(String ... settings) {
            this.settings(Arrays.asList(settings));
            return this;
        }

        public RuleGroupSourceStatefulRulesOptionsDetails build() {
            return new RuleGroupSourceStatefulRulesOptionsDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleGroupSourceStatefulRulesOptionsDetails> {
        public Builder keyword(String var1);

        public Builder settings(Collection<String> var1);

        public Builder settings(String ... var1);
    }
}

