/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse;
import software.amazon.awssdk.services.securityhub.model.Product;

public class DescribeProductsPublisher
implements SdkPublisher<DescribeProductsResponse> {
    private final SecurityHubAsyncClient client;
    private final DescribeProductsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeProductsPublisher(SecurityHubAsyncClient client, DescribeProductsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeProductsPublisher(SecurityHubAsyncClient client, DescribeProductsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeProductsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeProductsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Product> products() {
        Function<DescribeProductsResponse, Iterator> getIterator = response -> {
            if (response != null && response.products() != null) {
                return response.products().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeProductsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeProductsResponseFetcher
    implements AsyncPageFetcher<DescribeProductsResponse> {
        private DescribeProductsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeProductsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeProductsResponse> nextPage(DescribeProductsResponse previousPage) {
            if (previousPage == null) {
                return DescribeProductsPublisher.this.client.describeProducts(DescribeProductsPublisher.this.firstRequest);
            }
            return DescribeProductsPublisher.this.client.describeProducts((DescribeProductsRequest)((Object)DescribeProductsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

