/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AdminAccount;
import software.amazon.awssdk.services.securityhub.model.AdminAccountsCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOrganizationAdminAccountsResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, ListOrganizationAdminAccountsResponse> {
    private static final SdkField<List<AdminAccount>> ADMIN_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdminAccounts").getter(ListOrganizationAdminAccountsResponse.getter(ListOrganizationAdminAccountsResponse::adminAccounts)).setter(ListOrganizationAdminAccountsResponse.setter(Builder::adminAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdminAccount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOrganizationAdminAccountsResponse.getter(ListOrganizationAdminAccountsResponse::nextToken)).setter(ListOrganizationAdminAccountsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ACCOUNTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AdminAccount> adminAccounts;
    private final String nextToken;

    private ListOrganizationAdminAccountsResponse(BuilderImpl builder) {
        super(builder);
        this.adminAccounts = builder.adminAccounts;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAdminAccounts() {
        return this.adminAccounts != null && !(this.adminAccounts instanceof SdkAutoConstructList);
    }

    public final List<AdminAccount> adminAccounts() {
        return this.adminAccounts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdminAccounts() ? this.adminAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationAdminAccountsResponse)) {
            return false;
        }
        ListOrganizationAdminAccountsResponse other = (ListOrganizationAdminAccountsResponse)((Object)obj);
        return this.hasAdminAccounts() == other.hasAdminAccounts() && Objects.equals(this.adminAccounts(), other.adminAccounts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOrganizationAdminAccountsResponse").add("AdminAccounts", this.hasAdminAccounts() ? this.adminAccounts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdminAccounts": {
                return Optional.ofNullable(clazz.cast(this.adminAccounts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOrganizationAdminAccountsResponse, T> g) {
        return obj -> g.apply((ListOrganizationAdminAccountsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<AdminAccount> adminAccounts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationAdminAccountsResponse model) {
            super(model);
            this.adminAccounts(model.adminAccounts);
            this.nextToken(model.nextToken);
        }

        public final List<AdminAccount.Builder> getAdminAccounts() {
            List<AdminAccount.Builder> result = AdminAccountsCopier.copyToBuilder(this.adminAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder adminAccounts(Collection<AdminAccount> adminAccounts) {
            this.adminAccounts = AdminAccountsCopier.copy(adminAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adminAccounts(AdminAccount ... adminAccounts) {
            this.adminAccounts(Arrays.asList(adminAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adminAccounts(Consumer<AdminAccount.Builder> ... adminAccounts) {
            this.adminAccounts(Stream.of(adminAccounts).map(c -> (AdminAccount)((AdminAccount.Builder)AdminAccount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdminAccounts(Collection<AdminAccount.BuilderImpl> adminAccounts) {
            this.adminAccounts = AdminAccountsCopier.copyFromBuilder(adminAccounts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOrganizationAdminAccountsResponse build() {
            return new ListOrganizationAdminAccountsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOrganizationAdminAccountsResponse> {
        public Builder adminAccounts(Collection<AdminAccount> var1);

        public Builder adminAccounts(AdminAccount ... var1);

        public Builder adminAccounts(Consumer<AdminAccount.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

