/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableKeySchema;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableKeySchemaListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProjection;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProvisionedThroughput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsDynamoDbTableGlobalSecondaryIndex
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsDynamoDbTableGlobalSecondaryIndex> {
    private static final SdkField<Boolean> BACKFILLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Backfilling").getter(AwsDynamoDbTableGlobalSecondaryIndex.getter(AwsDynamoDbTableGlobalSecondaryIndex::backfilling)).setter(AwsDynamoDbTableGlobalSecondaryIndex.setter(Builder::backfilling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Backfilling").build()}).build();
    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexArn").getter(AwsDynamoDbTableGlobalSecondaryIndex.getter(AwsDynamoDbTableGlobalSecondaryIndex::indexArn)).setter(AwsDynamoDbTableGlobalSecondaryIndex.setter(Builder::indexArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexArn").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(AwsDynamoDbTableGlobalSecondaryIndex.getter(AwsDynamoDbTableGlobalSecondaryIndex::indexName)).setter(AwsDynamoDbTableGlobalSecondaryIndex.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<Long> INDEX_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("IndexSizeBytes").getter(AwsDynamoDbTableGlobalSecondaryIndex.getter(AwsDynamoDbTableGlobalSecondaryIndex::indexSizeBytes)).setter(AwsDynamoDbTableGlobalSecondaryIndex.setter(Builder::indexSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexSizeBytes").build()}).build();
    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexStatus").getter(AwsDynamoDbTableGlobalSecondaryIndex.getter(AwsDynamoDbTableGlobalSecondaryIndex::indexStatus)).setter(AwsDynamoDbTableGlobalSecondaryIndex.setter(Builder::indexStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatus").build()}).build();
    private static final SdkField<Integer> ITEM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ItemCount").getter(AwsDynamoDbTableGlobalSecondaryIndex.getter(AwsDynamoDbTableGlobalSecondaryIndex::itemCount)).setter(AwsDynamoDbTableGlobalSecondaryIndex.setter(Builder::itemCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()}).build();
    private static final SdkField<List<AwsDynamoDbTableKeySchema>> KEY_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeySchema").getter(AwsDynamoDbTableGlobalSecondaryIndex.getter(AwsDynamoDbTableGlobalSecondaryIndex::keySchema)).setter(AwsDynamoDbTableGlobalSecondaryIndex.setter(Builder::keySchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySchema").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsDynamoDbTableKeySchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsDynamoDbTableProjection> PROJECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Projection").getter(AwsDynamoDbTableGlobalSecondaryIndex.getter(AwsDynamoDbTableGlobalSecondaryIndex::projection)).setter(AwsDynamoDbTableGlobalSecondaryIndex.setter(Builder::projection)).constructor(AwsDynamoDbTableProjection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Projection").build()}).build();
    private static final SdkField<AwsDynamoDbTableProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedThroughput").getter(AwsDynamoDbTableGlobalSecondaryIndex.getter(AwsDynamoDbTableGlobalSecondaryIndex::provisionedThroughput)).setter(AwsDynamoDbTableGlobalSecondaryIndex.setter(Builder::provisionedThroughput)).constructor(AwsDynamoDbTableProvisionedThroughput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKFILLING_FIELD, INDEX_ARN_FIELD, INDEX_NAME_FIELD, INDEX_SIZE_BYTES_FIELD, INDEX_STATUS_FIELD, ITEM_COUNT_FIELD, KEY_SCHEMA_FIELD, PROJECTION_FIELD, PROVISIONED_THROUGHPUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean backfilling;
    private final String indexArn;
    private final String indexName;
    private final Long indexSizeBytes;
    private final String indexStatus;
    private final Integer itemCount;
    private final List<AwsDynamoDbTableKeySchema> keySchema;
    private final AwsDynamoDbTableProjection projection;
    private final AwsDynamoDbTableProvisionedThroughput provisionedThroughput;

    private AwsDynamoDbTableGlobalSecondaryIndex(BuilderImpl builder) {
        this.backfilling = builder.backfilling;
        this.indexArn = builder.indexArn;
        this.indexName = builder.indexName;
        this.indexSizeBytes = builder.indexSizeBytes;
        this.indexStatus = builder.indexStatus;
        this.itemCount = builder.itemCount;
        this.keySchema = builder.keySchema;
        this.projection = builder.projection;
        this.provisionedThroughput = builder.provisionedThroughput;
    }

    public final Boolean backfilling() {
        return this.backfilling;
    }

    public final String indexArn() {
        return this.indexArn;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final Long indexSizeBytes() {
        return this.indexSizeBytes;
    }

    public final String indexStatus() {
        return this.indexStatus;
    }

    public final Integer itemCount() {
        return this.itemCount;
    }

    public final boolean hasKeySchema() {
        return this.keySchema != null && !(this.keySchema instanceof SdkAutoConstructList);
    }

    public final List<AwsDynamoDbTableKeySchema> keySchema() {
        return this.keySchema;
    }

    public final AwsDynamoDbTableProjection projection() {
        return this.projection;
    }

    public final AwsDynamoDbTableProvisionedThroughput provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backfilling());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeySchema() ? this.keySchema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.projection());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDynamoDbTableGlobalSecondaryIndex)) {
            return false;
        }
        AwsDynamoDbTableGlobalSecondaryIndex other = (AwsDynamoDbTableGlobalSecondaryIndex)obj;
        return Objects.equals(this.backfilling(), other.backfilling()) && Objects.equals(this.indexArn(), other.indexArn()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.indexSizeBytes(), other.indexSizeBytes()) && Objects.equals(this.indexStatus(), other.indexStatus()) && Objects.equals(this.itemCount(), other.itemCount()) && this.hasKeySchema() == other.hasKeySchema() && Objects.equals(this.keySchema(), other.keySchema()) && Objects.equals(this.projection(), other.projection()) && Objects.equals(this.provisionedThroughput(), other.provisionedThroughput());
    }

    public final String toString() {
        return ToString.builder((String)"AwsDynamoDbTableGlobalSecondaryIndex").add("Backfilling", (Object)this.backfilling()).add("IndexArn", (Object)this.indexArn()).add("IndexName", (Object)this.indexName()).add("IndexSizeBytes", (Object)this.indexSizeBytes()).add("IndexStatus", (Object)this.indexStatus()).add("ItemCount", (Object)this.itemCount()).add("KeySchema", this.hasKeySchema() ? this.keySchema() : null).add("Projection", (Object)this.projection()).add("ProvisionedThroughput", (Object)this.provisionedThroughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Backfilling": {
                return Optional.ofNullable(clazz.cast(this.backfilling()));
            }
            case "IndexArn": {
                return Optional.ofNullable(clazz.cast(this.indexArn()));
            }
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "IndexSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.indexSizeBytes()));
            }
            case "IndexStatus": {
                return Optional.ofNullable(clazz.cast(this.indexStatus()));
            }
            case "ItemCount": {
                return Optional.ofNullable(clazz.cast(this.itemCount()));
            }
            case "KeySchema": {
                return Optional.ofNullable(clazz.cast(this.keySchema()));
            }
            case "Projection": {
                return Optional.ofNullable(clazz.cast(this.projection()));
            }
            case "ProvisionedThroughput": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsDynamoDbTableGlobalSecondaryIndex, T> g) {
        return obj -> g.apply((AwsDynamoDbTableGlobalSecondaryIndex)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean backfilling;
        private String indexArn;
        private String indexName;
        private Long indexSizeBytes;
        private String indexStatus;
        private Integer itemCount;
        private List<AwsDynamoDbTableKeySchema> keySchema = DefaultSdkAutoConstructList.getInstance();
        private AwsDynamoDbTableProjection projection;
        private AwsDynamoDbTableProvisionedThroughput provisionedThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDynamoDbTableGlobalSecondaryIndex model) {
            this.backfilling(model.backfilling);
            this.indexArn(model.indexArn);
            this.indexName(model.indexName);
            this.indexSizeBytes(model.indexSizeBytes);
            this.indexStatus(model.indexStatus);
            this.itemCount(model.itemCount);
            this.keySchema(model.keySchema);
            this.projection(model.projection);
            this.provisionedThroughput(model.provisionedThroughput);
        }

        public final Boolean getBackfilling() {
            return this.backfilling;
        }

        @Override
        public final Builder backfilling(Boolean backfilling) {
            this.backfilling = backfilling;
            return this;
        }

        public final void setBackfilling(Boolean backfilling) {
            this.backfilling = backfilling;
        }

        public final String getIndexArn() {
            return this.indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final Long getIndexSizeBytes() {
            return this.indexSizeBytes;
        }

        @Override
        public final Builder indexSizeBytes(Long indexSizeBytes) {
            this.indexSizeBytes = indexSizeBytes;
            return this;
        }

        public final void setIndexSizeBytes(Long indexSizeBytes) {
            this.indexSizeBytes = indexSizeBytes;
        }

        public final String getIndexStatus() {
            return this.indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        public final Integer getItemCount() {
            return this.itemCount;
        }

        @Override
        public final Builder itemCount(Integer itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final void setItemCount(Integer itemCount) {
            this.itemCount = itemCount;
        }

        public final List<AwsDynamoDbTableKeySchema.Builder> getKeySchema() {
            List<AwsDynamoDbTableKeySchema.Builder> result = AwsDynamoDbTableKeySchemaListCopier.copyToBuilder(this.keySchema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder keySchema(Collection<AwsDynamoDbTableKeySchema> keySchema) {
            this.keySchema = AwsDynamoDbTableKeySchemaListCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(AwsDynamoDbTableKeySchema ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(Consumer<AwsDynamoDbTableKeySchema.Builder> ... keySchema) {
            this.keySchema(Stream.of(keySchema).map(c -> (AwsDynamoDbTableKeySchema)((AwsDynamoDbTableKeySchema.Builder)AwsDynamoDbTableKeySchema.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeySchema(Collection<AwsDynamoDbTableKeySchema.BuilderImpl> keySchema) {
            this.keySchema = AwsDynamoDbTableKeySchemaListCopier.copyFromBuilder(keySchema);
        }

        public final AwsDynamoDbTableProjection.Builder getProjection() {
            return this.projection != null ? this.projection.toBuilder() : null;
        }

        @Override
        public final Builder projection(AwsDynamoDbTableProjection projection) {
            this.projection = projection;
            return this;
        }

        public final void setProjection(AwsDynamoDbTableProjection.BuilderImpl projection) {
            this.projection = projection != null ? projection.build() : null;
        }

        public final AwsDynamoDbTableProvisionedThroughput.Builder getProvisionedThroughput() {
            return this.provisionedThroughput != null ? this.provisionedThroughput.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughput(AwsDynamoDbTableProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(AwsDynamoDbTableProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        public AwsDynamoDbTableGlobalSecondaryIndex build() {
            return new AwsDynamoDbTableGlobalSecondaryIndex(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsDynamoDbTableGlobalSecondaryIndex> {
        public Builder backfilling(Boolean var1);

        public Builder indexArn(String var1);

        public Builder indexName(String var1);

        public Builder indexSizeBytes(Long var1);

        public Builder indexStatus(String var1);

        public Builder itemCount(Integer var1);

        public Builder keySchema(Collection<AwsDynamoDbTableKeySchema> var1);

        public Builder keySchema(AwsDynamoDbTableKeySchema ... var1);

        public Builder keySchema(Consumer<AwsDynamoDbTableKeySchema.Builder> ... var1);

        public Builder projection(AwsDynamoDbTableProjection var1);

        default public Builder projection(Consumer<AwsDynamoDbTableProjection.Builder> projection) {
            return this.projection((AwsDynamoDbTableProjection)((AwsDynamoDbTableProjection.Builder)AwsDynamoDbTableProjection.builder().applyMutation(projection)).build());
        }

        public Builder provisionedThroughput(AwsDynamoDbTableProvisionedThroughput var1);

        default public Builder provisionedThroughput(Consumer<AwsDynamoDbTableProvisionedThroughput.Builder> provisionedThroughput) {
            return this.provisionedThroughput((AwsDynamoDbTableProvisionedThroughput)((AwsDynamoDbTableProvisionedThroughput.Builder)AwsDynamoDbTableProvisionedThroughput.builder().applyMutation(provisionedThroughput)).build());
        }
    }
}

