/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsElbLoadBalancerSourceSecurityGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsElbLoadBalancerSourceSecurityGroup> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(AwsElbLoadBalancerSourceSecurityGroup.getter(AwsElbLoadBalancerSourceSecurityGroup::groupName)).setter(AwsElbLoadBalancerSourceSecurityGroup.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<String> OWNER_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAlias").getter(AwsElbLoadBalancerSourceSecurityGroup.getter(AwsElbLoadBalancerSourceSecurityGroup::ownerAlias)).setter(AwsElbLoadBalancerSourceSecurityGroup.setter(Builder::ownerAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAlias").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, OWNER_ALIAS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String groupName;
    private final String ownerAlias;

    private AwsElbLoadBalancerSourceSecurityGroup(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.ownerAlias = builder.ownerAlias;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final String ownerAlias() {
        return this.ownerAlias;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAlias());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElbLoadBalancerSourceSecurityGroup)) {
            return false;
        }
        AwsElbLoadBalancerSourceSecurityGroup other = (AwsElbLoadBalancerSourceSecurityGroup)obj;
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.ownerAlias(), other.ownerAlias());
    }

    public final String toString() {
        return ToString.builder((String)"AwsElbLoadBalancerSourceSecurityGroup").add("GroupName", (Object)this.groupName()).add("OwnerAlias", (Object)this.ownerAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "OwnerAlias": {
                return Optional.ofNullable(clazz.cast(this.ownerAlias()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsElbLoadBalancerSourceSecurityGroup, T> g) {
        return obj -> g.apply((AwsElbLoadBalancerSourceSecurityGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupName;
        private String ownerAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElbLoadBalancerSourceSecurityGroup model) {
            this.groupName(model.groupName);
            this.ownerAlias(model.ownerAlias);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getOwnerAlias() {
            return this.ownerAlias;
        }

        @Override
        public final Builder ownerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
            return this;
        }

        public final void setOwnerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
        }

        public AwsElbLoadBalancerSourceSecurityGroup build() {
            return new AwsElbLoadBalancerSourceSecurityGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsElbLoadBalancerSourceSecurityGroup> {
        public Builder groupName(String var1);

        public Builder ownerAlias(String var1);
    }
}

