/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsSecurityFinding;
import software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFindingsResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, GetFindingsResponse> {
    private static final SdkField<List<AwsSecurityFinding>> FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Findings").getter(GetFindingsResponse.getter(GetFindingsResponse::findings)).setter(GetFindingsResponse.setter(Builder::findings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Findings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsSecurityFinding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetFindingsResponse.getter(GetFindingsResponse::nextToken)).setter(GetFindingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDINGS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AwsSecurityFinding> findings;
    private final String nextToken;

    private GetFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.findings = builder.findings;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFindings() {
        return this.findings != null && !(this.findings instanceof SdkAutoConstructList);
    }

    public final List<AwsSecurityFinding> findings() {
        return this.findings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindings() ? this.findings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingsResponse)) {
            return false;
        }
        GetFindingsResponse other = (GetFindingsResponse)((Object)obj);
        return this.hasFindings() == other.hasFindings() && Objects.equals(this.findings(), other.findings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetFindingsResponse").add("Findings", this.hasFindings() ? this.findings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Findings": {
                return Optional.ofNullable(clazz.cast(this.findings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFindingsResponse, T> g) {
        return obj -> g.apply((GetFindingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<AwsSecurityFinding> findings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingsResponse model) {
            super(model);
            this.findings(model.findings);
            this.nextToken(model.nextToken);
        }

        public final Collection<AwsSecurityFinding.Builder> getFindings() {
            if (this.findings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.findings != null ? (Collection)this.findings.stream().map(AwsSecurityFinding::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder findings(Collection<AwsSecurityFinding> findings) {
            this.findings = AwsSecurityFindingListCopier.copy(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(AwsSecurityFinding ... findings) {
            this.findings(Arrays.asList(findings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Consumer<AwsSecurityFinding.Builder> ... findings) {
            this.findings(Stream.of(findings).map(c -> (AwsSecurityFinding)((AwsSecurityFinding.Builder)AwsSecurityFinding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFindings(Collection<AwsSecurityFinding.BuilderImpl> findings) {
            this.findings = AwsSecurityFindingListCopier.copyFromBuilder(findings);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetFindingsResponse build() {
            return new GetFindingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFindingsResponse> {
        public Builder findings(Collection<AwsSecurityFinding> var1);

        public Builder findings(AwsSecurityFinding ... var1);

        public Builder findings(Consumer<AwsSecurityFinding.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

