/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Result
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Result> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(Result.getter(Result::accountId)).setter(Result.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> PROCESSING_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcessingResult").getter(Result.getter(Result::processingResult)).setter(Result.setter(Builder::processingResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, PROCESSING_RESULT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String processingResult;

    private Result(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.processingResult = builder.processingResult;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String processingResult() {
        return this.processingResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingResult());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Result)) {
            return false;
        }
        Result other = (Result)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.processingResult(), other.processingResult());
    }

    public final String toString() {
        return ToString.builder((String)"Result").add("AccountId", (Object)this.accountId()).add("ProcessingResult", (Object)this.processingResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ProcessingResult": {
                return Optional.ofNullable(clazz.cast(this.processingResult()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Result, T> g) {
        return obj -> g.apply((Result)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String processingResult;

        private BuilderImpl() {
        }

        private BuilderImpl(Result model) {
            this.accountId(model.accountId);
            this.processingResult(model.processingResult);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getProcessingResult() {
            return this.processingResult;
        }

        @Override
        public final Builder processingResult(String processingResult) {
            this.processingResult = processingResult;
            return this;
        }

        public final void setProcessingResult(String processingResult) {
            this.processingResult = processingResult;
        }

        public Result build() {
            return new Result(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Result> {
        public Builder accountId(String var1);

        public Builder processingResult(String var1);
    }
}

