/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsDynamoDbTableProjection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsDynamoDbTableProjection> {
    private static final SdkField<List<String>> NON_KEY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NonKeyAttributes").getter(AwsDynamoDbTableProjection.getter(AwsDynamoDbTableProjection::nonKeyAttributes)).setter(AwsDynamoDbTableProjection.setter(Builder::nonKeyAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonKeyAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROJECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectionType").getter(AwsDynamoDbTableProjection.getter(AwsDynamoDbTableProjection::projectionType)).setter(AwsDynamoDbTableProjection.setter(Builder::projectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NON_KEY_ATTRIBUTES_FIELD, PROJECTION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> nonKeyAttributes;
    private final String projectionType;

    private AwsDynamoDbTableProjection(BuilderImpl builder) {
        this.nonKeyAttributes = builder.nonKeyAttributes;
        this.projectionType = builder.projectionType;
    }

    public final boolean hasNonKeyAttributes() {
        return this.nonKeyAttributes != null && !(this.nonKeyAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> nonKeyAttributes() {
        return this.nonKeyAttributes;
    }

    public final String projectionType() {
        return this.projectionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNonKeyAttributes() ? this.nonKeyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.projectionType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDynamoDbTableProjection)) {
            return false;
        }
        AwsDynamoDbTableProjection other = (AwsDynamoDbTableProjection)obj;
        return this.hasNonKeyAttributes() == other.hasNonKeyAttributes() && Objects.equals(this.nonKeyAttributes(), other.nonKeyAttributes()) && Objects.equals(this.projectionType(), other.projectionType());
    }

    public final String toString() {
        return ToString.builder((String)"AwsDynamoDbTableProjection").add("NonKeyAttributes", this.hasNonKeyAttributes() ? this.nonKeyAttributes() : null).add("ProjectionType", (Object)this.projectionType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NonKeyAttributes": {
                return Optional.ofNullable(clazz.cast(this.nonKeyAttributes()));
            }
            case "ProjectionType": {
                return Optional.ofNullable(clazz.cast(this.projectionType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsDynamoDbTableProjection, T> g) {
        return obj -> g.apply((AwsDynamoDbTableProjection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> nonKeyAttributes = DefaultSdkAutoConstructList.getInstance();
        private String projectionType;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDynamoDbTableProjection model) {
            this.nonKeyAttributes(model.nonKeyAttributes);
            this.projectionType(model.projectionType);
        }

        public final Collection<String> getNonKeyAttributes() {
            if (this.nonKeyAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nonKeyAttributes;
        }

        @Override
        public final Builder nonKeyAttributes(Collection<String> nonKeyAttributes) {
            this.nonKeyAttributes = StringListCopier.copy(nonKeyAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nonKeyAttributes(String ... nonKeyAttributes) {
            this.nonKeyAttributes(Arrays.asList(nonKeyAttributes));
            return this;
        }

        public final void setNonKeyAttributes(Collection<String> nonKeyAttributes) {
            this.nonKeyAttributes = StringListCopier.copy(nonKeyAttributes);
        }

        public final String getProjectionType() {
            return this.projectionType;
        }

        @Override
        public final Builder projectionType(String projectionType) {
            this.projectionType = projectionType;
            return this;
        }

        public final void setProjectionType(String projectionType) {
            this.projectionType = projectionType;
        }

        public AwsDynamoDbTableProjection build() {
            return new AwsDynamoDbTableProjection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsDynamoDbTableProjection> {
        public Builder nonKeyAttributes(Collection<String> var1);

        public Builder nonKeyAttributes(String ... var1);

        public Builder projectionType(String var1);
    }
}

