/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbSubnetGroupSubnet;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbSubnetGroupSubnetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsRdsDbSubnetGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsRdsDbSubnetGroup> {
    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbSubnetGroupName").getter(AwsRdsDbSubnetGroup.getter(AwsRdsDbSubnetGroup::dbSubnetGroupName)).setter(AwsRdsDbSubnetGroup.setter(Builder::dbSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbSubnetGroupName").build()}).build();
    private static final SdkField<String> DB_SUBNET_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbSubnetGroupDescription").getter(AwsRdsDbSubnetGroup.getter(AwsRdsDbSubnetGroup::dbSubnetGroupDescription)).setter(AwsRdsDbSubnetGroup.setter(Builder::dbSubnetGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbSubnetGroupDescription").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(AwsRdsDbSubnetGroup.getter(AwsRdsDbSubnetGroup::vpcId)).setter(AwsRdsDbSubnetGroup.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> SUBNET_GROUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetGroupStatus").getter(AwsRdsDbSubnetGroup.getter(AwsRdsDbSubnetGroup::subnetGroupStatus)).setter(AwsRdsDbSubnetGroup.setter(Builder::subnetGroupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupStatus").build()}).build();
    private static final SdkField<List<AwsRdsDbSubnetGroupSubnet>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subnets").getter(AwsRdsDbSubnetGroup.getter(AwsRdsDbSubnetGroup::subnets)).setter(AwsRdsDbSubnetGroup.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsRdsDbSubnetGroupSubnet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DB_SUBNET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbSubnetGroupArn").getter(AwsRdsDbSubnetGroup.getter(AwsRdsDbSubnetGroup::dbSubnetGroupArn)).setter(AwsRdsDbSubnetGroup.setter(Builder::dbSubnetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbSubnetGroupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SUBNET_GROUP_NAME_FIELD, DB_SUBNET_GROUP_DESCRIPTION_FIELD, VPC_ID_FIELD, SUBNET_GROUP_STATUS_FIELD, SUBNETS_FIELD, DB_SUBNET_GROUP_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dbSubnetGroupName;
    private final String dbSubnetGroupDescription;
    private final String vpcId;
    private final String subnetGroupStatus;
    private final List<AwsRdsDbSubnetGroupSubnet> subnets;
    private final String dbSubnetGroupArn;

    private AwsRdsDbSubnetGroup(BuilderImpl builder) {
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.dbSubnetGroupDescription = builder.dbSubnetGroupDescription;
        this.vpcId = builder.vpcId;
        this.subnetGroupStatus = builder.subnetGroupStatus;
        this.subnets = builder.subnets;
        this.dbSubnetGroupArn = builder.dbSubnetGroupArn;
    }

    public final String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public final String dbSubnetGroupDescription() {
        return this.dbSubnetGroupDescription;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String subnetGroupStatus() {
        return this.subnetGroupStatus;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<AwsRdsDbSubnetGroupSubnet> subnets() {
        return this.subnets;
    }

    public final String dbSubnetGroupArn() {
        return this.dbSubnetGroupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetGroupStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbSubnetGroup)) {
            return false;
        }
        AwsRdsDbSubnetGroup other = (AwsRdsDbSubnetGroup)obj;
        return Objects.equals(this.dbSubnetGroupName(), other.dbSubnetGroupName()) && Objects.equals(this.dbSubnetGroupDescription(), other.dbSubnetGroupDescription()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.subnetGroupStatus(), other.subnetGroupStatus()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets()) && Objects.equals(this.dbSubnetGroupArn(), other.dbSubnetGroupArn());
    }

    public final String toString() {
        return ToString.builder((String)"AwsRdsDbSubnetGroup").add("DbSubnetGroupName", (Object)this.dbSubnetGroupName()).add("DbSubnetGroupDescription", (Object)this.dbSubnetGroupDescription()).add("VpcId", (Object)this.vpcId()).add("SubnetGroupStatus", (Object)this.subnetGroupStatus()).add("Subnets", this.hasSubnets() ? this.subnets() : null).add("DbSubnetGroupArn", (Object)this.dbSubnetGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DbSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupName()));
            }
            case "DbSubnetGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupDescription()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetGroupStatus": {
                return Optional.ofNullable(clazz.cast(this.subnetGroupStatus()));
            }
            case "Subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "DbSubnetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbSubnetGroup, T> g) {
        return obj -> g.apply((AwsRdsDbSubnetGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbSubnetGroupName;
        private String dbSubnetGroupDescription;
        private String vpcId;
        private String subnetGroupStatus;
        private List<AwsRdsDbSubnetGroupSubnet> subnets = DefaultSdkAutoConstructList.getInstance();
        private String dbSubnetGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbSubnetGroup model) {
            this.dbSubnetGroupName(model.dbSubnetGroupName);
            this.dbSubnetGroupDescription(model.dbSubnetGroupDescription);
            this.vpcId(model.vpcId);
            this.subnetGroupStatus(model.subnetGroupStatus);
            this.subnets(model.subnets);
            this.dbSubnetGroupArn(model.dbSubnetGroupArn);
        }

        public final String getDbSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getDbSubnetGroupDescription() {
            return this.dbSubnetGroupDescription;
        }

        @Override
        public final Builder dbSubnetGroupDescription(String dbSubnetGroupDescription) {
            this.dbSubnetGroupDescription = dbSubnetGroupDescription;
            return this;
        }

        public final void setDbSubnetGroupDescription(String dbSubnetGroupDescription) {
            this.dbSubnetGroupDescription = dbSubnetGroupDescription;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getSubnetGroupStatus() {
            return this.subnetGroupStatus;
        }

        @Override
        public final Builder subnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
            return this;
        }

        public final void setSubnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
        }

        public final Collection<AwsRdsDbSubnetGroupSubnet.Builder> getSubnets() {
            if (this.subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnets != null ? (Collection)this.subnets.stream().map(AwsRdsDbSubnetGroupSubnet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subnets(Collection<AwsRdsDbSubnetGroupSubnet> subnets) {
            this.subnets = AwsRdsDbSubnetGroupSubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(AwsRdsDbSubnetGroupSubnet ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Consumer<AwsRdsDbSubnetGroupSubnet.Builder> ... subnets) {
            this.subnets(Stream.of(subnets).map(c -> (AwsRdsDbSubnetGroupSubnet)((AwsRdsDbSubnetGroupSubnet.Builder)AwsRdsDbSubnetGroupSubnet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubnets(Collection<AwsRdsDbSubnetGroupSubnet.BuilderImpl> subnets) {
            this.subnets = AwsRdsDbSubnetGroupSubnetsCopier.copyFromBuilder(subnets);
        }

        public final String getDbSubnetGroupArn() {
            return this.dbSubnetGroupArn;
        }

        @Override
        public final Builder dbSubnetGroupArn(String dbSubnetGroupArn) {
            this.dbSubnetGroupArn = dbSubnetGroupArn;
            return this;
        }

        public final void setDbSubnetGroupArn(String dbSubnetGroupArn) {
            this.dbSubnetGroupArn = dbSubnetGroupArn;
        }

        public AwsRdsDbSubnetGroup build() {
            return new AwsRdsDbSubnetGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsRdsDbSubnetGroup> {
        public Builder dbSubnetGroupName(String var1);

        public Builder dbSubnetGroupDescription(String var1);

        public Builder vpcId(String var1);

        public Builder subnetGroupStatus(String var1);

        public Builder subnets(Collection<AwsRdsDbSubnetGroupSubnet> var1);

        public Builder subnets(AwsRdsDbSubnetGroupSubnet ... var1);

        public Builder subnets(Consumer<AwsRdsDbSubnetGroupSubnet.Builder> ... var1);

        public Builder dbSubnetGroupArn(String var1);
    }
}

