/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.Invitation;
import software.amazon.awssdk.services.securityhub.model.InvitationListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInvitationsResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, ListInvitationsResponse> {
    private static final SdkField<List<Invitation>> INVITATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Invitations").getter(ListInvitationsResponse.getter(ListInvitationsResponse::invitations)).setter(ListInvitationsResponse.setter(Builder::invitations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Invitations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Invitation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInvitationsResponse.getter(ListInvitationsResponse::nextToken)).setter(ListInvitationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVITATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Invitation> invitations;
    private final String nextToken;

    private ListInvitationsResponse(BuilderImpl builder) {
        super(builder);
        this.invitations = builder.invitations;
        this.nextToken = builder.nextToken;
    }

    public boolean hasInvitations() {
        return this.invitations != null && !(this.invitations instanceof SdkAutoConstructList);
    }

    public List<Invitation> invitations() {
        return this.invitations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvitations() ? this.invitations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvitationsResponse)) {
            return false;
        }
        ListInvitationsResponse other = (ListInvitationsResponse)((Object)obj);
        return this.hasInvitations() == other.hasInvitations() && Objects.equals(this.invitations(), other.invitations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListInvitationsResponse").add("Invitations", this.hasInvitations() ? this.invitations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Invitations": {
                return Optional.ofNullable(clazz.cast(this.invitations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInvitationsResponse, T> g) {
        return obj -> g.apply((ListInvitationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<Invitation> invitations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvitationsResponse model) {
            super(model);
            this.invitations(model.invitations);
            this.nextToken(model.nextToken);
        }

        public final Collection<Invitation.Builder> getInvitations() {
            if (this.invitations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.invitations != null ? (Collection)this.invitations.stream().map(Invitation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder invitations(Collection<Invitation> invitations) {
            this.invitations = InvitationListCopier.copy(invitations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invitations(Invitation ... invitations) {
            this.invitations(Arrays.asList(invitations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invitations(Consumer<Invitation.Builder> ... invitations) {
            this.invitations(Stream.of(invitations).map(c -> (Invitation)((Invitation.Builder)Invitation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInvitations(Collection<Invitation.BuilderImpl> invitations) {
            this.invitations = InvitationListCopier.copyFromBuilder(invitations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInvitationsResponse build() {
            return new ListInvitationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInvitationsResponse> {
        public Builder invitations(Collection<Invitation> var1);

        public Builder invitations(Invitation ... var1);

        public Builder invitations(Consumer<Invitation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

