/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeAttachment;
import software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeAttachmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2VolumeDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2VolumeDetails> {
    private static final SdkField<String> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateTime").getter(AwsEc2VolumeDetails.getter(AwsEc2VolumeDetails::createTime)).setter(AwsEc2VolumeDetails.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(AwsEc2VolumeDetails.getter(AwsEc2VolumeDetails::encrypted)).setter(AwsEc2VolumeDetails.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()}).build();
    private static final SdkField<Integer> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Size").getter(AwsEc2VolumeDetails.getter(AwsEc2VolumeDetails::size)).setter(AwsEc2VolumeDetails.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(AwsEc2VolumeDetails.getter(AwsEc2VolumeDetails::snapshotId)).setter(AwsEc2VolumeDetails.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AwsEc2VolumeDetails.getter(AwsEc2VolumeDetails::status)).setter(AwsEc2VolumeDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(AwsEc2VolumeDetails.getter(AwsEc2VolumeDetails::kmsKeyId)).setter(AwsEc2VolumeDetails.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<List<AwsEc2VolumeAttachment>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attachments").getter(AwsEc2VolumeDetails.getter(AwsEc2VolumeDetails::attachments)).setter(AwsEc2VolumeDetails.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2VolumeAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, ENCRYPTED_FIELD, SIZE_FIELD, SNAPSHOT_ID_FIELD, STATUS_FIELD, KMS_KEY_ID_FIELD, ATTACHMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String createTime;
    private final Boolean encrypted;
    private final Integer size;
    private final String snapshotId;
    private final String status;
    private final String kmsKeyId;
    private final List<AwsEc2VolumeAttachment> attachments;

    private AwsEc2VolumeDetails(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.encrypted = builder.encrypted;
        this.size = builder.size;
        this.snapshotId = builder.snapshotId;
        this.status = builder.status;
        this.kmsKeyId = builder.kmsKeyId;
        this.attachments = builder.attachments;
    }

    public String createTime() {
        return this.createTime;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public Integer size() {
        return this.size;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public String status() {
        return this.status;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public boolean hasAttachments() {
        return this.attachments != null && !(this.attachments instanceof SdkAutoConstructList);
    }

    public List<AwsEc2VolumeAttachment> attachments() {
        return this.attachments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachments() ? this.attachments() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2VolumeDetails)) {
            return false;
        }
        AwsEc2VolumeDetails other = (AwsEc2VolumeDetails)obj;
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasAttachments() == other.hasAttachments() && Objects.equals(this.attachments(), other.attachments());
    }

    public String toString() {
        return ToString.builder((String)"AwsEc2VolumeDetails").add("CreateTime", (Object)this.createTime()).add("Encrypted", (Object)this.encrypted()).add("Size", (Object)this.size()).add("SnapshotId", (Object)this.snapshotId()).add("Status", (Object)this.status()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Attachments", this.hasAttachments() ? this.attachments() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "Attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2VolumeDetails, T> g) {
        return obj -> g.apply((AwsEc2VolumeDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String createTime;
        private Boolean encrypted;
        private Integer size;
        private String snapshotId;
        private String status;
        private String kmsKeyId;
        private List<AwsEc2VolumeAttachment> attachments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2VolumeDetails model) {
            this.createTime(model.createTime);
            this.encrypted(model.encrypted);
            this.size(model.size);
            this.snapshotId(model.snapshotId);
            this.status(model.status);
            this.kmsKeyId(model.kmsKeyId);
            this.attachments(model.attachments);
        }

        public final String getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(String createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Collection<AwsEc2VolumeAttachment.Builder> getAttachments() {
            if (this.attachments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attachments != null ? (Collection)this.attachments.stream().map(AwsEc2VolumeAttachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachments(Collection<AwsEc2VolumeAttachment> attachments) {
            this.attachments = AwsEc2VolumeAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(AwsEc2VolumeAttachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<AwsEc2VolumeAttachment.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (AwsEc2VolumeAttachment)((AwsEc2VolumeAttachment.Builder)AwsEc2VolumeAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachments(Collection<AwsEc2VolumeAttachment.BuilderImpl> attachments) {
            this.attachments = AwsEc2VolumeAttachmentListCopier.copyFromBuilder(attachments);
        }

        public AwsEc2VolumeDetails build() {
            return new AwsEc2VolumeDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2VolumeDetails> {
        public Builder createTime(String var1);

        public Builder encrypted(Boolean var1);

        public Builder size(Integer var1);

        public Builder snapshotId(String var1);

        public Builder status(String var1);

        public Builder kmsKeyId(String var1);

        public Builder attachments(Collection<AwsEc2VolumeAttachment> var1);

        public Builder attachments(AwsEc2VolumeAttachment ... var1);

        public Builder attachments(Consumer<AwsEc2VolumeAttachment.Builder> ... var1);
    }
}

