/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbProcessorFeature;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbProcessorFeaturesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsRdsDbSnapshotDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsRdsDbSnapshotDetails> {
    private static final SdkField<String> DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbSnapshotIdentifier").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::dbSnapshotIdentifier)).setter(AwsRdsDbSnapshotDetails.setter(Builder::dbSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbSnapshotIdentifier").build()}).build();
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbInstanceIdentifier").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::dbInstanceIdentifier)).setter(AwsRdsDbSnapshotDetails.setter(Builder::dbInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbInstanceIdentifier").build()}).build();
    private static final SdkField<String> SNAPSHOT_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotCreateTime").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::snapshotCreateTime)).setter(AwsRdsDbSnapshotDetails.setter(Builder::snapshotCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCreateTime").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::engine)).setter(AwsRdsDbSnapshotDetails.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedStorage").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::allocatedStorage)).setter(AwsRdsDbSnapshotDetails.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::status)).setter(AwsRdsDbSnapshotDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::port)).setter(AwsRdsDbSnapshotDetails.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::availabilityZone)).setter(AwsRdsDbSnapshotDetails.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::vpcId)).setter(AwsRdsDbSnapshotDetails.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> INSTANCE_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceCreateTime").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::instanceCreateTime)).setter(AwsRdsDbSnapshotDetails.setter(Builder::instanceCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCreateTime").build()}).build();
    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUsername").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::masterUsername)).setter(AwsRdsDbSnapshotDetails.setter(Builder::masterUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::engineVersion)).setter(AwsRdsDbSnapshotDetails.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseModel").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::licenseModel)).setter(AwsRdsDbSnapshotDetails.setter(Builder::licenseModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()}).build();
    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotType").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::snapshotType)).setter(AwsRdsDbSnapshotDetails.setter(Builder::snapshotType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotType").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::iops)).setter(AwsRdsDbSnapshotDetails.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupName").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::optionGroupName)).setter(AwsRdsDbSnapshotDetails.setter(Builder::optionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()}).build();
    private static final SdkField<Integer> PERCENT_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PercentProgress").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::percentProgress)).setter(AwsRdsDbSnapshotDetails.setter(Builder::percentProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentProgress").build()}).build();
    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceRegion").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::sourceRegion)).setter(AwsRdsDbSnapshotDetails.setter(Builder::sourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()}).build();
    private static final SdkField<String> SOURCE_DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDbSnapshotIdentifier").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::sourceDbSnapshotIdentifier)).setter(AwsRdsDbSnapshotDetails.setter(Builder::sourceDbSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDbSnapshotIdentifier").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::storageType)).setter(AwsRdsDbSnapshotDetails.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<String> TDE_CREDENTIAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TdeCredentialArn").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::tdeCredentialArn)).setter(AwsRdsDbSnapshotDetails.setter(Builder::tdeCredentialArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialArn").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::encrypted)).setter(AwsRdsDbSnapshotDetails.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::kmsKeyId)).setter(AwsRdsDbSnapshotDetails.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timezone").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::timezone)).setter(AwsRdsDbSnapshotDetails.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build();
    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IamDatabaseAuthenticationEnabled").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::iamDatabaseAuthenticationEnabled)).setter(AwsRdsDbSnapshotDetails.setter(Builder::iamDatabaseAuthenticationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamDatabaseAuthenticationEnabled").build()}).build();
    private static final SdkField<List<AwsRdsDbProcessorFeature>> PROCESSOR_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProcessorFeatures").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::processorFeatures)).setter(AwsRdsDbSnapshotDetails.setter(Builder::processorFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeatures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsRdsDbProcessorFeature::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbiResourceId").getter(AwsRdsDbSnapshotDetails.getter(AwsRdsDbSnapshotDetails::dbiResourceId)).setter(AwsRdsDbSnapshotDetails.setter(Builder::dbiResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SNAPSHOT_IDENTIFIER_FIELD, DB_INSTANCE_IDENTIFIER_FIELD, SNAPSHOT_CREATE_TIME_FIELD, ENGINE_FIELD, ALLOCATED_STORAGE_FIELD, STATUS_FIELD, PORT_FIELD, AVAILABILITY_ZONE_FIELD, VPC_ID_FIELD, INSTANCE_CREATE_TIME_FIELD, MASTER_USERNAME_FIELD, ENGINE_VERSION_FIELD, LICENSE_MODEL_FIELD, SNAPSHOT_TYPE_FIELD, IOPS_FIELD, OPTION_GROUP_NAME_FIELD, PERCENT_PROGRESS_FIELD, SOURCE_REGION_FIELD, SOURCE_DB_SNAPSHOT_IDENTIFIER_FIELD, STORAGE_TYPE_FIELD, TDE_CREDENTIAL_ARN_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, TIMEZONE_FIELD, IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD, PROCESSOR_FEATURES_FIELD, DBI_RESOURCE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dbSnapshotIdentifier;
    private final String dbInstanceIdentifier;
    private final String snapshotCreateTime;
    private final String engine;
    private final Integer allocatedStorage;
    private final String status;
    private final Integer port;
    private final String availabilityZone;
    private final String vpcId;
    private final String instanceCreateTime;
    private final String masterUsername;
    private final String engineVersion;
    private final String licenseModel;
    private final String snapshotType;
    private final Integer iops;
    private final String optionGroupName;
    private final Integer percentProgress;
    private final String sourceRegion;
    private final String sourceDbSnapshotIdentifier;
    private final String storageType;
    private final String tdeCredentialArn;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final String timezone;
    private final Boolean iamDatabaseAuthenticationEnabled;
    private final List<AwsRdsDbProcessorFeature> processorFeatures;
    private final String dbiResourceId;

    private AwsRdsDbSnapshotDetails(BuilderImpl builder) {
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.snapshotCreateTime = builder.snapshotCreateTime;
        this.engine = builder.engine;
        this.allocatedStorage = builder.allocatedStorage;
        this.status = builder.status;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
        this.vpcId = builder.vpcId;
        this.instanceCreateTime = builder.instanceCreateTime;
        this.masterUsername = builder.masterUsername;
        this.engineVersion = builder.engineVersion;
        this.licenseModel = builder.licenseModel;
        this.snapshotType = builder.snapshotType;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.percentProgress = builder.percentProgress;
        this.sourceRegion = builder.sourceRegion;
        this.sourceDbSnapshotIdentifier = builder.sourceDbSnapshotIdentifier;
        this.storageType = builder.storageType;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.timezone = builder.timezone;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.processorFeatures = builder.processorFeatures;
        this.dbiResourceId = builder.dbiResourceId;
    }

    public String dbSnapshotIdentifier() {
        return this.dbSnapshotIdentifier;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public String snapshotCreateTime() {
        return this.snapshotCreateTime;
    }

    public String engine() {
        return this.engine;
    }

    public Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public String status() {
        return this.status;
    }

    public Integer port() {
        return this.port;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String instanceCreateTime() {
        return this.instanceCreateTime;
    }

    public String masterUsername() {
        return this.masterUsername;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String licenseModel() {
        return this.licenseModel;
    }

    public String snapshotType() {
        return this.snapshotType;
    }

    public Integer iops() {
        return this.iops;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public Integer percentProgress() {
        return this.percentProgress;
    }

    public String sourceRegion() {
        return this.sourceRegion;
    }

    public String sourceDbSnapshotIdentifier() {
        return this.sourceDbSnapshotIdentifier;
    }

    public String storageType() {
        return this.storageType;
    }

    public String tdeCredentialArn() {
        return this.tdeCredentialArn;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String timezone() {
        return this.timezone;
    }

    public Boolean iamDatabaseAuthenticationEnabled() {
        return this.iamDatabaseAuthenticationEnabled;
    }

    public boolean hasProcessorFeatures() {
        return this.processorFeatures != null && !(this.processorFeatures instanceof SdkAutoConstructList);
    }

    public List<AwsRdsDbProcessorFeature> processorFeatures() {
        return this.processorFeatures;
    }

    public String dbiResourceId() {
        return this.dbiResourceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotType());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.tdeCredentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamDatabaseAuthenticationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessorFeatures() ? this.processorFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dbiResourceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbSnapshotDetails)) {
            return false;
        }
        AwsRdsDbSnapshotDetails other = (AwsRdsDbSnapshotDetails)obj;
        return Objects.equals(this.dbSnapshotIdentifier(), other.dbSnapshotIdentifier()) && Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.snapshotCreateTime(), other.snapshotCreateTime()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.instanceCreateTime(), other.instanceCreateTime()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.licenseModel(), other.licenseModel()) && Objects.equals(this.snapshotType(), other.snapshotType()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.percentProgress(), other.percentProgress()) && Objects.equals(this.sourceRegion(), other.sourceRegion()) && Objects.equals(this.sourceDbSnapshotIdentifier(), other.sourceDbSnapshotIdentifier()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.tdeCredentialArn(), other.tdeCredentialArn()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled()) && this.hasProcessorFeatures() == other.hasProcessorFeatures() && Objects.equals(this.processorFeatures(), other.processorFeatures()) && Objects.equals(this.dbiResourceId(), other.dbiResourceId());
    }

    public String toString() {
        return ToString.builder((String)"AwsRdsDbSnapshotDetails").add("DbSnapshotIdentifier", (Object)this.dbSnapshotIdentifier()).add("DbInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("SnapshotCreateTime", (Object)this.snapshotCreateTime()).add("Engine", (Object)this.engine()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("Status", (Object)this.status()).add("Port", (Object)this.port()).add("AvailabilityZone", (Object)this.availabilityZone()).add("VpcId", (Object)this.vpcId()).add("InstanceCreateTime", (Object)this.instanceCreateTime()).add("MasterUsername", (Object)this.masterUsername()).add("EngineVersion", (Object)this.engineVersion()).add("LicenseModel", (Object)this.licenseModel()).add("SnapshotType", (Object)this.snapshotType()).add("Iops", (Object)this.iops()).add("OptionGroupName", (Object)this.optionGroupName()).add("PercentProgress", (Object)this.percentProgress()).add("SourceRegion", (Object)this.sourceRegion()).add("SourceDbSnapshotIdentifier", (Object)this.sourceDbSnapshotIdentifier()).add("StorageType", (Object)this.storageType()).add("TdeCredentialArn", (Object)this.tdeCredentialArn()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Timezone", (Object)this.timezone()).add("IamDatabaseAuthenticationEnabled", (Object)this.iamDatabaseAuthenticationEnabled()).add("ProcessorFeatures", this.hasProcessorFeatures() ? this.processorFeatures() : null).add("DbiResourceId", (Object)this.dbiResourceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DbSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbSnapshotIdentifier()));
            }
            case "DbInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "SnapshotCreateTime": {
                return Optional.ofNullable(clazz.cast(this.snapshotCreateTime()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "InstanceCreateTime": {
                return Optional.ofNullable(clazz.cast(this.instanceCreateTime()));
            }
            case "MasterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "LicenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModel()));
            }
            case "SnapshotType": {
                return Optional.ofNullable(clazz.cast(this.snapshotType()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "PercentProgress": {
                return Optional.ofNullable(clazz.cast(this.percentProgress()));
            }
            case "SourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
            case "SourceDbSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceDbSnapshotIdentifier()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "TdeCredentialArn": {
                return Optional.ofNullable(clazz.cast(this.tdeCredentialArn()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "IamDatabaseAuthenticationEnabled": {
                return Optional.ofNullable(clazz.cast(this.iamDatabaseAuthenticationEnabled()));
            }
            case "ProcessorFeatures": {
                return Optional.ofNullable(clazz.cast(this.processorFeatures()));
            }
            case "DbiResourceId": {
                return Optional.ofNullable(clazz.cast(this.dbiResourceId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbSnapshotDetails, T> g) {
        return obj -> g.apply((AwsRdsDbSnapshotDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbSnapshotIdentifier;
        private String dbInstanceIdentifier;
        private String snapshotCreateTime;
        private String engine;
        private Integer allocatedStorage;
        private String status;
        private Integer port;
        private String availabilityZone;
        private String vpcId;
        private String instanceCreateTime;
        private String masterUsername;
        private String engineVersion;
        private String licenseModel;
        private String snapshotType;
        private Integer iops;
        private String optionGroupName;
        private Integer percentProgress;
        private String sourceRegion;
        private String sourceDbSnapshotIdentifier;
        private String storageType;
        private String tdeCredentialArn;
        private Boolean encrypted;
        private String kmsKeyId;
        private String timezone;
        private Boolean iamDatabaseAuthenticationEnabled;
        private List<AwsRdsDbProcessorFeature> processorFeatures = DefaultSdkAutoConstructList.getInstance();
        private String dbiResourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbSnapshotDetails model) {
            this.dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.snapshotCreateTime(model.snapshotCreateTime);
            this.engine(model.engine);
            this.allocatedStorage(model.allocatedStorage);
            this.status(model.status);
            this.port(model.port);
            this.availabilityZone(model.availabilityZone);
            this.vpcId(model.vpcId);
            this.instanceCreateTime(model.instanceCreateTime);
            this.masterUsername(model.masterUsername);
            this.engineVersion(model.engineVersion);
            this.licenseModel(model.licenseModel);
            this.snapshotType(model.snapshotType);
            this.iops(model.iops);
            this.optionGroupName(model.optionGroupName);
            this.percentProgress(model.percentProgress);
            this.sourceRegion(model.sourceRegion);
            this.sourceDbSnapshotIdentifier(model.sourceDbSnapshotIdentifier);
            this.storageType(model.storageType);
            this.tdeCredentialArn(model.tdeCredentialArn);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.timezone(model.timezone);
            this.iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            this.processorFeatures(model.processorFeatures);
            this.dbiResourceId(model.dbiResourceId);
        }

        public final String getDbSnapshotIdentifier() {
            return this.dbSnapshotIdentifier;
        }

        @Override
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final void setDbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        public final String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getSnapshotCreateTime() {
            return this.snapshotCreateTime;
        }

        @Override
        public final Builder snapshotCreateTime(String snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
            return this;
        }

        public final void setSnapshotCreateTime(String snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getInstanceCreateTime() {
            return this.instanceCreateTime;
        }

        @Override
        public final Builder instanceCreateTime(String instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
            return this;
        }

        public final void setInstanceCreateTime(String instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final String getSnapshotType() {
            return this.snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final Integer getPercentProgress() {
            return this.percentProgress;
        }

        @Override
        public final Builder percentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final void setPercentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public final String getSourceDbSnapshotIdentifier() {
            return this.sourceDbSnapshotIdentifier;
        }

        @Override
        public final Builder sourceDbSnapshotIdentifier(String sourceDbSnapshotIdentifier) {
            this.sourceDbSnapshotIdentifier = sourceDbSnapshotIdentifier;
            return this;
        }

        public final void setSourceDbSnapshotIdentifier(String sourceDbSnapshotIdentifier) {
            this.sourceDbSnapshotIdentifier = sourceDbSnapshotIdentifier;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final String getTdeCredentialArn() {
            return this.tdeCredentialArn;
        }

        @Override
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return this.iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        public final Collection<AwsRdsDbProcessorFeature.Builder> getProcessorFeatures() {
            if (this.processorFeatures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.processorFeatures != null ? (Collection)this.processorFeatures.stream().map(AwsRdsDbProcessorFeature::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processorFeatures(Collection<AwsRdsDbProcessorFeature> processorFeatures) {
            this.processorFeatures = AwsRdsDbProcessorFeaturesCopier.copy(processorFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(AwsRdsDbProcessorFeature ... processorFeatures) {
            this.processorFeatures(Arrays.asList(processorFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(Consumer<AwsRdsDbProcessorFeature.Builder> ... processorFeatures) {
            this.processorFeatures(Stream.of(processorFeatures).map(c -> (AwsRdsDbProcessorFeature)((AwsRdsDbProcessorFeature.Builder)AwsRdsDbProcessorFeature.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProcessorFeatures(Collection<AwsRdsDbProcessorFeature.BuilderImpl> processorFeatures) {
            this.processorFeatures = AwsRdsDbProcessorFeaturesCopier.copyFromBuilder(processorFeatures);
        }

        public final String getDbiResourceId() {
            return this.dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        public AwsRdsDbSnapshotDetails build() {
            return new AwsRdsDbSnapshotDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsRdsDbSnapshotDetails> {
        public Builder dbSnapshotIdentifier(String var1);

        public Builder dbInstanceIdentifier(String var1);

        public Builder snapshotCreateTime(String var1);

        public Builder engine(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder status(String var1);

        public Builder port(Integer var1);

        public Builder availabilityZone(String var1);

        public Builder vpcId(String var1);

        public Builder instanceCreateTime(String var1);

        public Builder masterUsername(String var1);

        public Builder engineVersion(String var1);

        public Builder licenseModel(String var1);

        public Builder snapshotType(String var1);

        public Builder iops(Integer var1);

        public Builder optionGroupName(String var1);

        public Builder percentProgress(Integer var1);

        public Builder sourceRegion(String var1);

        public Builder sourceDbSnapshotIdentifier(String var1);

        public Builder storageType(String var1);

        public Builder tdeCredentialArn(String var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder timezone(String var1);

        public Builder iamDatabaseAuthenticationEnabled(Boolean var1);

        public Builder processorFeatures(Collection<AwsRdsDbProcessorFeature> var1);

        public Builder processorFeatures(AwsRdsDbProcessorFeature ... var1);

        public Builder processorFeatures(Consumer<AwsRdsDbProcessorFeature.Builder> ... var1);

        public Builder dbiResourceId(String var1);
    }
}

