/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption;
import software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDomainValidationOptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsCertificateManagerCertificateRenewalSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsCertificateManagerCertificateRenewalSummary> {
    private static final SdkField<List<AwsCertificateManagerCertificateDomainValidationOption>> DOMAIN_VALIDATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainValidationOptions").getter(AwsCertificateManagerCertificateRenewalSummary.getter(AwsCertificateManagerCertificateRenewalSummary::domainValidationOptions)).setter(AwsCertificateManagerCertificateRenewalSummary.setter(Builder::domainValidationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainValidationOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsCertificateManagerCertificateDomainValidationOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RENEWAL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RenewalStatus").getter(AwsCertificateManagerCertificateRenewalSummary.getter(AwsCertificateManagerCertificateRenewalSummary::renewalStatus)).setter(AwsCertificateManagerCertificateRenewalSummary.setter(Builder::renewalStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewalStatus").build()}).build();
    private static final SdkField<String> RENEWAL_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RenewalStatusReason").getter(AwsCertificateManagerCertificateRenewalSummary.getter(AwsCertificateManagerCertificateRenewalSummary::renewalStatusReason)).setter(AwsCertificateManagerCertificateRenewalSummary.setter(Builder::renewalStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewalStatusReason").build()}).build();
    private static final SdkField<String> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdatedAt").getter(AwsCertificateManagerCertificateRenewalSummary.getter(AwsCertificateManagerCertificateRenewalSummary::updatedAt)).setter(AwsCertificateManagerCertificateRenewalSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_VALIDATION_OPTIONS_FIELD, RENEWAL_STATUS_FIELD, RENEWAL_STATUS_REASON_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AwsCertificateManagerCertificateDomainValidationOption> domainValidationOptions;
    private final String renewalStatus;
    private final String renewalStatusReason;
    private final String updatedAt;

    private AwsCertificateManagerCertificateRenewalSummary(BuilderImpl builder) {
        this.domainValidationOptions = builder.domainValidationOptions;
        this.renewalStatus = builder.renewalStatus;
        this.renewalStatusReason = builder.renewalStatusReason;
        this.updatedAt = builder.updatedAt;
    }

    public boolean hasDomainValidationOptions() {
        return this.domainValidationOptions != null && !(this.domainValidationOptions instanceof SdkAutoConstructList);
    }

    public List<AwsCertificateManagerCertificateDomainValidationOption> domainValidationOptions() {
        return this.domainValidationOptions;
    }

    public String renewalStatus() {
        return this.renewalStatus;
    }

    public String renewalStatusReason() {
        return this.renewalStatusReason;
    }

    public String updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainValidationOptions() ? this.domainValidationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCertificateManagerCertificateRenewalSummary)) {
            return false;
        }
        AwsCertificateManagerCertificateRenewalSummary other = (AwsCertificateManagerCertificateRenewalSummary)obj;
        return this.hasDomainValidationOptions() == other.hasDomainValidationOptions() && Objects.equals(this.domainValidationOptions(), other.domainValidationOptions()) && Objects.equals(this.renewalStatus(), other.renewalStatus()) && Objects.equals(this.renewalStatusReason(), other.renewalStatusReason()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public String toString() {
        return ToString.builder((String)"AwsCertificateManagerCertificateRenewalSummary").add("DomainValidationOptions", this.hasDomainValidationOptions() ? this.domainValidationOptions() : null).add("RenewalStatus", (Object)this.renewalStatus()).add("RenewalStatusReason", (Object)this.renewalStatusReason()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainValidationOptions": {
                return Optional.ofNullable(clazz.cast(this.domainValidationOptions()));
            }
            case "RenewalStatus": {
                return Optional.ofNullable(clazz.cast(this.renewalStatus()));
            }
            case "RenewalStatusReason": {
                return Optional.ofNullable(clazz.cast(this.renewalStatusReason()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCertificateManagerCertificateRenewalSummary, T> g) {
        return obj -> g.apply((AwsCertificateManagerCertificateRenewalSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AwsCertificateManagerCertificateDomainValidationOption> domainValidationOptions = DefaultSdkAutoConstructList.getInstance();
        private String renewalStatus;
        private String renewalStatusReason;
        private String updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCertificateManagerCertificateRenewalSummary model) {
            this.domainValidationOptions(model.domainValidationOptions);
            this.renewalStatus(model.renewalStatus);
            this.renewalStatusReason(model.renewalStatusReason);
            this.updatedAt(model.updatedAt);
        }

        public final Collection<AwsCertificateManagerCertificateDomainValidationOption.Builder> getDomainValidationOptions() {
            if (this.domainValidationOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.domainValidationOptions != null ? (Collection)this.domainValidationOptions.stream().map(AwsCertificateManagerCertificateDomainValidationOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainValidationOptions(Collection<AwsCertificateManagerCertificateDomainValidationOption> domainValidationOptions) {
            this.domainValidationOptions = AwsCertificateManagerCertificateDomainValidationOptionsCopier.copy(domainValidationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(AwsCertificateManagerCertificateDomainValidationOption ... domainValidationOptions) {
            this.domainValidationOptions(Arrays.asList(domainValidationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(Consumer<AwsCertificateManagerCertificateDomainValidationOption.Builder> ... domainValidationOptions) {
            this.domainValidationOptions(Stream.of(domainValidationOptions).map(c -> (AwsCertificateManagerCertificateDomainValidationOption)((AwsCertificateManagerCertificateDomainValidationOption.Builder)AwsCertificateManagerCertificateDomainValidationOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainValidationOptions(Collection<AwsCertificateManagerCertificateDomainValidationOption.BuilderImpl> domainValidationOptions) {
            this.domainValidationOptions = AwsCertificateManagerCertificateDomainValidationOptionsCopier.copyFromBuilder(domainValidationOptions);
        }

        public final String getRenewalStatus() {
            return this.renewalStatus;
        }

        @Override
        public final Builder renewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
            return this;
        }

        public final void setRenewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
        }

        public final String getRenewalStatusReason() {
            return this.renewalStatusReason;
        }

        @Override
        public final Builder renewalStatusReason(String renewalStatusReason) {
            this.renewalStatusReason = renewalStatusReason;
            return this;
        }

        public final void setRenewalStatusReason(String renewalStatusReason) {
            this.renewalStatusReason = renewalStatusReason;
        }

        public final String getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        public AwsCertificateManagerCertificateRenewalSummary build() {
            return new AwsCertificateManagerCertificateRenewalSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsCertificateManagerCertificateRenewalSummary> {
        public Builder domainValidationOptions(Collection<AwsCertificateManagerCertificateDomainValidationOption> var1);

        public Builder domainValidationOptions(AwsCertificateManagerCertificateDomainValidationOption ... var1);

        public Builder domainValidationOptions(Consumer<AwsCertificateManagerCertificateDomainValidationOption.Builder> ... var1);

        public Builder renewalStatus(String var1);

        public Builder renewalStatusReason(String var1);

        public Builder updatedAt(String var1);
    }
}

