/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2InstanceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2InstanceDetails> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsEc2InstanceDetails.getter(AwsEc2InstanceDetails::type)).setter(AwsEc2InstanceDetails.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsEc2InstanceDetails.getter(AwsEc2InstanceDetails::imageId)).setter(AwsEc2InstanceDetails.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()}).build();
    private static final SdkField<List<String>> IP_V4_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AwsEc2InstanceDetails.getter(AwsEc2InstanceDetails::ipV4Addresses)).setter(AwsEc2InstanceDetails.setter(Builder::ipV4Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpV4Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IP_V6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AwsEc2InstanceDetails.getter(AwsEc2InstanceDetails::ipV6Addresses)).setter(AwsEc2InstanceDetails.setter(Builder::ipV6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpV6Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsEc2InstanceDetails.getter(AwsEc2InstanceDetails::keyName)).setter(AwsEc2InstanceDetails.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()}).build();
    private static final SdkField<String> IAM_INSTANCE_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsEc2InstanceDetails.getter(AwsEc2InstanceDetails::iamInstanceProfileArn)).setter(AwsEc2InstanceDetails.setter(Builder::iamInstanceProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfileArn").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsEc2InstanceDetails.getter(AwsEc2InstanceDetails::vpcId)).setter(AwsEc2InstanceDetails.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsEc2InstanceDetails.getter(AwsEc2InstanceDetails::subnetId)).setter(AwsEc2InstanceDetails.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> LAUNCHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsEc2InstanceDetails.getter(AwsEc2InstanceDetails::launchedAt)).setter(AwsEc2InstanceDetails.setter(Builder::launchedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, IMAGE_ID_FIELD, IP_V4_ADDRESSES_FIELD, IP_V6_ADDRESSES_FIELD, KEY_NAME_FIELD, IAM_INSTANCE_PROFILE_ARN_FIELD, VPC_ID_FIELD, SUBNET_ID_FIELD, LAUNCHED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String imageId;
    private final List<String> ipV4Addresses;
    private final List<String> ipV6Addresses;
    private final String keyName;
    private final String iamInstanceProfileArn;
    private final String vpcId;
    private final String subnetId;
    private final String launchedAt;

    private AwsEc2InstanceDetails(BuilderImpl builder) {
        this.type = builder.type;
        this.imageId = builder.imageId;
        this.ipV4Addresses = builder.ipV4Addresses;
        this.ipV6Addresses = builder.ipV6Addresses;
        this.keyName = builder.keyName;
        this.iamInstanceProfileArn = builder.iamInstanceProfileArn;
        this.vpcId = builder.vpcId;
        this.subnetId = builder.subnetId;
        this.launchedAt = builder.launchedAt;
    }

    public String type() {
        return this.type;
    }

    public String imageId() {
        return this.imageId;
    }

    public boolean hasIpV4Addresses() {
        return this.ipV4Addresses != null && !(this.ipV4Addresses instanceof SdkAutoConstructList);
    }

    public List<String> ipV4Addresses() {
        return this.ipV4Addresses;
    }

    public boolean hasIpV6Addresses() {
        return this.ipV6Addresses != null && !(this.ipV6Addresses instanceof SdkAutoConstructList);
    }

    public List<String> ipV6Addresses() {
        return this.ipV6Addresses;
    }

    public String keyName() {
        return this.keyName;
    }

    public String iamInstanceProfileArn() {
        return this.iamInstanceProfileArn;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String launchedAt() {
        return this.launchedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipV4Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipV6Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2InstanceDetails)) {
            return false;
        }
        AwsEc2InstanceDetails other = (AwsEc2InstanceDetails)obj;
        return Objects.equals(this.type(), other.type()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.ipV4Addresses(), other.ipV4Addresses()) && Objects.equals(this.ipV6Addresses(), other.ipV6Addresses()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.iamInstanceProfileArn(), other.iamInstanceProfileArn()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.launchedAt(), other.launchedAt());
    }

    public String toString() {
        return ToString.builder((String)"AwsEc2InstanceDetails").add("Type", (Object)this.type()).add("ImageId", (Object)this.imageId()).add("IpV4Addresses", this.ipV4Addresses()).add("IpV6Addresses", this.ipV6Addresses()).add("KeyName", (Object)this.keyName()).add("IamInstanceProfileArn", (Object)this.iamInstanceProfileArn()).add("VpcId", (Object)this.vpcId()).add("SubnetId", (Object)this.subnetId()).add("LaunchedAt", (Object)this.launchedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "IpV4Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipV4Addresses()));
            }
            case "IpV6Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipV6Addresses()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "IamInstanceProfileArn": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfileArn()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "LaunchedAt": {
                return Optional.ofNullable(clazz.cast(this.launchedAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2InstanceDetails, T> g) {
        return obj -> g.apply((AwsEc2InstanceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String imageId;
        private List<String> ipV4Addresses = DefaultSdkAutoConstructList.getInstance();
        private List<String> ipV6Addresses = DefaultSdkAutoConstructList.getInstance();
        private String keyName;
        private String iamInstanceProfileArn;
        private String vpcId;
        private String subnetId;
        private String launchedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2InstanceDetails model) {
            this.type(model.type);
            this.imageId(model.imageId);
            this.ipV4Addresses(model.ipV4Addresses);
            this.ipV6Addresses(model.ipV6Addresses);
            this.keyName(model.keyName);
            this.iamInstanceProfileArn(model.iamInstanceProfileArn);
            this.vpcId(model.vpcId);
            this.subnetId(model.subnetId);
            this.launchedAt(model.launchedAt);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final Collection<String> getIpV4Addresses() {
            return this.ipV4Addresses;
        }

        @Override
        public final Builder ipV4Addresses(Collection<String> ipV4Addresses) {
            this.ipV4Addresses = StringListCopier.copy(ipV4Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipV4Addresses(String ... ipV4Addresses) {
            this.ipV4Addresses(Arrays.asList(ipV4Addresses));
            return this;
        }

        public final void setIpV4Addresses(Collection<String> ipV4Addresses) {
            this.ipV4Addresses = StringListCopier.copy(ipV4Addresses);
        }

        public final Collection<String> getIpV6Addresses() {
            return this.ipV6Addresses;
        }

        @Override
        public final Builder ipV6Addresses(Collection<String> ipV6Addresses) {
            this.ipV6Addresses = StringListCopier.copy(ipV6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipV6Addresses(String ... ipV6Addresses) {
            this.ipV6Addresses(Arrays.asList(ipV6Addresses));
            return this;
        }

        public final void setIpV6Addresses(Collection<String> ipV6Addresses) {
            this.ipV6Addresses = StringListCopier.copy(ipV6Addresses);
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final String getIamInstanceProfileArn() {
            return this.iamInstanceProfileArn;
        }

        @Override
        public final Builder iamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
            return this;
        }

        public final void setIamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getLaunchedAt() {
            return this.launchedAt;
        }

        @Override
        public final Builder launchedAt(String launchedAt) {
            this.launchedAt = launchedAt;
            return this;
        }

        public final void setLaunchedAt(String launchedAt) {
            this.launchedAt = launchedAt;
        }

        public AwsEc2InstanceDetails build() {
            return new AwsEc2InstanceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2InstanceDetails> {
        public Builder type(String var1);

        public Builder imageId(String var1);

        public Builder ipV4Addresses(Collection<String> var1);

        public Builder ipV4Addresses(String ... var1);

        public Builder ipV6Addresses(Collection<String> var1);

        public Builder ipV6Addresses(String ... var1);

        public Builder keyName(String var1);

        public Builder iamInstanceProfileArn(String var1);

        public Builder vpcId(String var1);

        public Builder subnetId(String var1);

        public Builder launchedAt(String var1);
    }
}

