/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StatusReason
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StatusReason> {
    private static final SdkField<String> REASON_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StatusReason.getter(StatusReason::reasonCode)).setter(StatusReason.setter(Builder::reasonCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReasonCode").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StatusReason.getter(StatusReason::description)).setter(StatusReason.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_CODE_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String reasonCode;
    private final String description;

    private StatusReason(BuilderImpl builder) {
        this.reasonCode = builder.reasonCode;
        this.description = builder.description;
    }

    public String reasonCode() {
        return this.reasonCode;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatusReason)) {
            return false;
        }
        StatusReason other = (StatusReason)obj;
        return Objects.equals(this.reasonCode(), other.reasonCode()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"StatusReason").add("ReasonCode", (Object)this.reasonCode()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReasonCode": {
                return Optional.ofNullable(clazz.cast(this.reasonCode()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatusReason, T> g) {
        return obj -> g.apply((StatusReason)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reasonCode;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(StatusReason model) {
            this.reasonCode(model.reasonCode);
            this.description(model.description);
        }

        public final String getReasonCode() {
            return this.reasonCode;
        }

        @Override
        public final Builder reasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        public final void setReasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public StatusReason build() {
            return new StatusReason(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StatusReason> {
        public Builder reasonCode(String var1);

        public Builder description(String var1);
    }
}

