/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2NetworkInterfaceSecurityGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2NetworkInterfaceSecurityGroup> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsEc2NetworkInterfaceSecurityGroup.getter(AwsEc2NetworkInterfaceSecurityGroup::groupName)).setter(AwsEc2NetworkInterfaceSecurityGroup.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsEc2NetworkInterfaceSecurityGroup.getter(AwsEc2NetworkInterfaceSecurityGroup::groupId)).setter(AwsEc2NetworkInterfaceSecurityGroup.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, GROUP_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String groupName;
    private final String groupId;

    private AwsEc2NetworkInterfaceSecurityGroup(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.groupId = builder.groupId;
    }

    public String groupName() {
        return this.groupName;
    }

    public String groupId() {
        return this.groupId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2NetworkInterfaceSecurityGroup)) {
            return false;
        }
        AwsEc2NetworkInterfaceSecurityGroup other = (AwsEc2NetworkInterfaceSecurityGroup)obj;
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.groupId(), other.groupId());
    }

    public String toString() {
        return ToString.builder((String)"AwsEc2NetworkInterfaceSecurityGroup").add("GroupName", (Object)this.groupName()).add("GroupId", (Object)this.groupId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2NetworkInterfaceSecurityGroup, T> g) {
        return obj -> g.apply((AwsEc2NetworkInterfaceSecurityGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupName;
        private String groupId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2NetworkInterfaceSecurityGroup model) {
            this.groupName(model.groupName);
            this.groupId(model.groupId);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public AwsEc2NetworkInterfaceSecurityGroup build() {
            return new AwsEc2NetworkInterfaceSecurityGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2NetworkInterfaceSecurityGroup> {
        public Builder groupName(String var1);

        public Builder groupId(String var1);
    }
}

