/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHubResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, DescribeHubResponse> {
    private static final SdkField<String> HUB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeHubResponse.getter(DescribeHubResponse::hubArn)).setter(DescribeHubResponse.setter(Builder::hubArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubArn").build()}).build();
    private static final SdkField<String> SUBSCRIBED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeHubResponse.getter(DescribeHubResponse::subscribedAt)).setter(DescribeHubResponse.setter(Builder::subscribedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscribedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_ARN_FIELD, SUBSCRIBED_AT_FIELD));
    private final String hubArn;
    private final String subscribedAt;

    private DescribeHubResponse(BuilderImpl builder) {
        super(builder);
        this.hubArn = builder.hubArn;
        this.subscribedAt = builder.subscribedAt;
    }

    public String hubArn() {
        return this.hubArn;
    }

    public String subscribedAt() {
        return this.subscribedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hubArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscribedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHubResponse)) {
            return false;
        }
        DescribeHubResponse other = (DescribeHubResponse)((Object)obj);
        return Objects.equals(this.hubArn(), other.hubArn()) && Objects.equals(this.subscribedAt(), other.subscribedAt());
    }

    public String toString() {
        return ToString.builder((String)"DescribeHubResponse").add("HubArn", (Object)this.hubArn()).add("SubscribedAt", (Object)this.subscribedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HubArn": {
                return Optional.ofNullable(clazz.cast(this.hubArn()));
            }
            case "SubscribedAt": {
                return Optional.ofNullable(clazz.cast(this.subscribedAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHubResponse, T> g) {
        return obj -> g.apply((DescribeHubResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private String hubArn;
        private String subscribedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHubResponse model) {
            super(model);
            this.hubArn(model.hubArn);
            this.subscribedAt(model.subscribedAt);
        }

        public final String getHubArn() {
            return this.hubArn;
        }

        @Override
        public final Builder hubArn(String hubArn) {
            this.hubArn = hubArn;
            return this;
        }

        public final void setHubArn(String hubArn) {
            this.hubArn = hubArn;
        }

        public final String getSubscribedAt() {
            return this.subscribedAt;
        }

        @Override
        public final Builder subscribedAt(String subscribedAt) {
            this.subscribedAt = subscribedAt;
            return this;
        }

        public final void setSubscribedAt(String subscribedAt) {
            this.subscribedAt = subscribedAt;
        }

        @Override
        public DescribeHubResponse build() {
            return new DescribeHubResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeHubResponse> {
        public Builder hubArn(String var1);

        public Builder subscribedAt(String var1);
    }
}

