/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.SeverityLabel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SeverityUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SeverityUpdate> {
    private static final SdkField<Integer> NORMALIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SeverityUpdate.getter(SeverityUpdate::normalized)).setter(SeverityUpdate.setter(Builder::normalized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Normalized").build()}).build();
    private static final SdkField<Double> PRODUCT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(SeverityUpdate.getter(SeverityUpdate::product)).setter(SeverityUpdate.setter(Builder::product)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Product").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SeverityUpdate.getter(SeverityUpdate::labelAsString)).setter(SeverityUpdate.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NORMALIZED_FIELD, PRODUCT_FIELD, LABEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer normalized;
    private final Double product;
    private final String label;

    private SeverityUpdate(BuilderImpl builder) {
        this.normalized = builder.normalized;
        this.product = builder.product;
        this.label = builder.label;
    }

    public Integer normalized() {
        return this.normalized;
    }

    public Double product() {
        return this.product;
    }

    public SeverityLabel label() {
        return SeverityLabel.fromValue(this.label);
    }

    public String labelAsString() {
        return this.label;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.normalized());
        hashCode = 31 * hashCode + Objects.hashCode(this.product());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SeverityUpdate)) {
            return false;
        }
        SeverityUpdate other = (SeverityUpdate)obj;
        return Objects.equals(this.normalized(), other.normalized()) && Objects.equals(this.product(), other.product()) && Objects.equals(this.labelAsString(), other.labelAsString());
    }

    public String toString() {
        return ToString.builder((String)"SeverityUpdate").add("Normalized", (Object)this.normalized()).add("Product", (Object)this.product()).add("Label", (Object)this.labelAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Normalized": {
                return Optional.ofNullable(clazz.cast(this.normalized()));
            }
            case "Product": {
                return Optional.ofNullable(clazz.cast(this.product()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.labelAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SeverityUpdate, T> g) {
        return obj -> g.apply((SeverityUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer normalized;
        private Double product;
        private String label;

        private BuilderImpl() {
        }

        private BuilderImpl(SeverityUpdate model) {
            this.normalized(model.normalized);
            this.product(model.product);
            this.label(model.label);
        }

        public final Integer getNormalized() {
            return this.normalized;
        }

        @Override
        public final Builder normalized(Integer normalized) {
            this.normalized = normalized;
            return this;
        }

        public final void setNormalized(Integer normalized) {
            this.normalized = normalized;
        }

        public final Double getProduct() {
            return this.product;
        }

        @Override
        public final Builder product(Double product) {
            this.product = product;
            return this;
        }

        public final void setProduct(Double product) {
            this.product = product;
        }

        public final String getLabelAsString() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        @Override
        public final Builder label(SeverityLabel label) {
            this.label(label == null ? null : label.toString());
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public SeverityUpdate build() {
            return new SeverityUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SeverityUpdate> {
        public Builder normalized(Integer var1);

        public Builder product(Double var1);

        public Builder label(String var1);

        public Builder label(SeverityLabel var1);
    }
}

