/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpPermission;
import software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpPermissionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2SecurityGroupDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2SecurityGroupDetails> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsEc2SecurityGroupDetails.getter(AwsEc2SecurityGroupDetails::groupName)).setter(AwsEc2SecurityGroupDetails.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsEc2SecurityGroupDetails.getter(AwsEc2SecurityGroupDetails::groupId)).setter(AwsEc2SecurityGroupDetails.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsEc2SecurityGroupDetails.getter(AwsEc2SecurityGroupDetails::ownerId)).setter(AwsEc2SecurityGroupDetails.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsEc2SecurityGroupDetails.getter(AwsEc2SecurityGroupDetails::vpcId)).setter(AwsEc2SecurityGroupDetails.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<List<AwsEc2SecurityGroupIpPermission>> IP_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AwsEc2SecurityGroupDetails.getter(AwsEc2SecurityGroupDetails::ipPermissions)).setter(AwsEc2SecurityGroupDetails.setter(Builder::ipPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2SecurityGroupIpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AwsEc2SecurityGroupIpPermission>> IP_PERMISSIONS_EGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AwsEc2SecurityGroupDetails.getter(AwsEc2SecurityGroupDetails::ipPermissionsEgress)).setter(AwsEc2SecurityGroupDetails.setter(Builder::ipPermissionsEgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPermissionsEgress").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2SecurityGroupIpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, GROUP_ID_FIELD, OWNER_ID_FIELD, VPC_ID_FIELD, IP_PERMISSIONS_FIELD, IP_PERMISSIONS_EGRESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String groupName;
    private final String groupId;
    private final String ownerId;
    private final String vpcId;
    private final List<AwsEc2SecurityGroupIpPermission> ipPermissions;
    private final List<AwsEc2SecurityGroupIpPermission> ipPermissionsEgress;

    private AwsEc2SecurityGroupDetails(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.groupId = builder.groupId;
        this.ownerId = builder.ownerId;
        this.vpcId = builder.vpcId;
        this.ipPermissions = builder.ipPermissions;
        this.ipPermissionsEgress = builder.ipPermissionsEgress;
    }

    public String groupName() {
        return this.groupName;
    }

    public String groupId() {
        return this.groupId;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public boolean hasIpPermissions() {
        return this.ipPermissions != null && !(this.ipPermissions instanceof SdkAutoConstructList);
    }

    public List<AwsEc2SecurityGroupIpPermission> ipPermissions() {
        return this.ipPermissions;
    }

    public boolean hasIpPermissionsEgress() {
        return this.ipPermissionsEgress != null && !(this.ipPermissionsEgress instanceof SdkAutoConstructList);
    }

    public List<AwsEc2SecurityGroupIpPermission> ipPermissionsEgress() {
        return this.ipPermissionsEgress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipPermissionsEgress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2SecurityGroupDetails)) {
            return false;
        }
        AwsEc2SecurityGroupDetails other = (AwsEc2SecurityGroupDetails)obj;
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.ipPermissions(), other.ipPermissions()) && Objects.equals(this.ipPermissionsEgress(), other.ipPermissionsEgress());
    }

    public String toString() {
        return ToString.builder((String)"AwsEc2SecurityGroupDetails").add("GroupName", (Object)this.groupName()).add("GroupId", (Object)this.groupId()).add("OwnerId", (Object)this.ownerId()).add("VpcId", (Object)this.vpcId()).add("IpPermissions", this.ipPermissions()).add("IpPermissionsEgress", this.ipPermissionsEgress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "IpPermissions": {
                return Optional.ofNullable(clazz.cast(this.ipPermissions()));
            }
            case "IpPermissionsEgress": {
                return Optional.ofNullable(clazz.cast(this.ipPermissionsEgress()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2SecurityGroupDetails, T> g) {
        return obj -> g.apply((AwsEc2SecurityGroupDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupName;
        private String groupId;
        private String ownerId;
        private String vpcId;
        private List<AwsEc2SecurityGroupIpPermission> ipPermissions = DefaultSdkAutoConstructList.getInstance();
        private List<AwsEc2SecurityGroupIpPermission> ipPermissionsEgress = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2SecurityGroupDetails model) {
            this.groupName(model.groupName);
            this.groupId(model.groupId);
            this.ownerId(model.ownerId);
            this.vpcId(model.vpcId);
            this.ipPermissions(model.ipPermissions);
            this.ipPermissionsEgress(model.ipPermissionsEgress);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<AwsEc2SecurityGroupIpPermission.Builder> getIpPermissions() {
            return this.ipPermissions != null ? (Collection)this.ipPermissions.stream().map(AwsEc2SecurityGroupIpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipPermissions(Collection<AwsEc2SecurityGroupIpPermission> ipPermissions) {
            this.ipPermissions = AwsEc2SecurityGroupIpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(AwsEc2SecurityGroupIpPermission ... ipPermissions) {
            this.ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(Consumer<AwsEc2SecurityGroupIpPermission.Builder> ... ipPermissions) {
            this.ipPermissions(Stream.of(ipPermissions).map(c -> (AwsEc2SecurityGroupIpPermission)((AwsEc2SecurityGroupIpPermission.Builder)AwsEc2SecurityGroupIpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpPermissions(Collection<AwsEc2SecurityGroupIpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = AwsEc2SecurityGroupIpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        public final Collection<AwsEc2SecurityGroupIpPermission.Builder> getIpPermissionsEgress() {
            return this.ipPermissionsEgress != null ? (Collection)this.ipPermissionsEgress.stream().map(AwsEc2SecurityGroupIpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipPermissionsEgress(Collection<AwsEc2SecurityGroupIpPermission> ipPermissionsEgress) {
            this.ipPermissionsEgress = AwsEc2SecurityGroupIpPermissionListCopier.copy(ipPermissionsEgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissionsEgress(AwsEc2SecurityGroupIpPermission ... ipPermissionsEgress) {
            this.ipPermissionsEgress(Arrays.asList(ipPermissionsEgress));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissionsEgress(Consumer<AwsEc2SecurityGroupIpPermission.Builder> ... ipPermissionsEgress) {
            this.ipPermissionsEgress(Stream.of(ipPermissionsEgress).map(c -> (AwsEc2SecurityGroupIpPermission)((AwsEc2SecurityGroupIpPermission.Builder)AwsEc2SecurityGroupIpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpPermissionsEgress(Collection<AwsEc2SecurityGroupIpPermission.BuilderImpl> ipPermissionsEgress) {
            this.ipPermissionsEgress = AwsEc2SecurityGroupIpPermissionListCopier.copyFromBuilder(ipPermissionsEgress);
        }

        public AwsEc2SecurityGroupDetails build() {
            return new AwsEc2SecurityGroupDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2SecurityGroupDetails> {
        public Builder groupName(String var1);

        public Builder groupId(String var1);

        public Builder ownerId(String var1);

        public Builder vpcId(String var1);

        public Builder ipPermissions(Collection<AwsEc2SecurityGroupIpPermission> var1);

        public Builder ipPermissions(AwsEc2SecurityGroupIpPermission ... var1);

        public Builder ipPermissions(Consumer<AwsEc2SecurityGroupIpPermission.Builder> ... var1);

        public Builder ipPermissionsEgress(Collection<AwsEc2SecurityGroupIpPermission> var1);

        public Builder ipPermissionsEgress(AwsEc2SecurityGroupIpPermission ... var1);

        public Builder ipPermissionsEgress(Consumer<AwsEc2SecurityGroupIpPermission.Builder> ... var1);
    }
}

