/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.WafAction;
import software.amazon.awssdk.services.securityhub.model.WafExcludedRule;
import software.amazon.awssdk.services.securityhub.model.WafExcludedRuleListCopier;
import software.amazon.awssdk.services.securityhub.model.WafOverrideAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsWafWebAclRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsWafWebAclRule> {
    private static final SdkField<WafAction> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AwsWafWebAclRule.getter(AwsWafWebAclRule::action)).setter(AwsWafWebAclRule.setter(Builder::action)).constructor(WafAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<List<WafExcludedRule>> EXCLUDED_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AwsWafWebAclRule.getter(AwsWafWebAclRule::excludedRules)).setter(AwsWafWebAclRule.setter(Builder::excludedRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WafExcludedRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<WafOverrideAction> OVERRIDE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AwsWafWebAclRule.getter(AwsWafWebAclRule::overrideAction)).setter(AwsWafWebAclRule.setter(Builder::overrideAction)).constructor(WafOverrideAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideAction").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AwsWafWebAclRule.getter(AwsWafWebAclRule::priority)).setter(AwsWafWebAclRule.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsWafWebAclRule.getter(AwsWafWebAclRule::ruleId)).setter(AwsWafWebAclRule.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsWafWebAclRule.getter(AwsWafWebAclRule::type)).setter(AwsWafWebAclRule.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, EXCLUDED_RULES_FIELD, OVERRIDE_ACTION_FIELD, PRIORITY_FIELD, RULE_ID_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final WafAction action;
    private final List<WafExcludedRule> excludedRules;
    private final WafOverrideAction overrideAction;
    private final Integer priority;
    private final String ruleId;
    private final String type;

    private AwsWafWebAclRule(BuilderImpl builder) {
        this.action = builder.action;
        this.excludedRules = builder.excludedRules;
        this.overrideAction = builder.overrideAction;
        this.priority = builder.priority;
        this.ruleId = builder.ruleId;
        this.type = builder.type;
    }

    public WafAction action() {
        return this.action;
    }

    public boolean hasExcludedRules() {
        return this.excludedRules != null && !(this.excludedRules instanceof SdkAutoConstructList);
    }

    public List<WafExcludedRule> excludedRules() {
        return this.excludedRules;
    }

    public WafOverrideAction overrideAction() {
        return this.overrideAction;
    }

    public Integer priority() {
        return this.priority;
    }

    public String ruleId() {
        return this.ruleId;
    }

    public String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludedRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafWebAclRule)) {
            return false;
        }
        AwsWafWebAclRule other = (AwsWafWebAclRule)obj;
        return Objects.equals(this.action(), other.action()) && Objects.equals(this.excludedRules(), other.excludedRules()) && Objects.equals(this.overrideAction(), other.overrideAction()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.type(), other.type());
    }

    public String toString() {
        return ToString.builder((String)"AwsWafWebAclRule").add("Action", (Object)this.action()).add("ExcludedRules", this.excludedRules()).add("OverrideAction", (Object)this.overrideAction()).add("Priority", (Object)this.priority()).add("RuleId", (Object)this.ruleId()).add("Type", (Object)this.type()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "ExcludedRules": {
                return Optional.ofNullable(clazz.cast(this.excludedRules()));
            }
            case "OverrideAction": {
                return Optional.ofNullable(clazz.cast(this.overrideAction()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "RuleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsWafWebAclRule, T> g) {
        return obj -> g.apply((AwsWafWebAclRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WafAction action;
        private List<WafExcludedRule> excludedRules = DefaultSdkAutoConstructList.getInstance();
        private WafOverrideAction overrideAction;
        private Integer priority;
        private String ruleId;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafWebAclRule model) {
            this.action(model.action);
            this.excludedRules(model.excludedRules);
            this.overrideAction(model.overrideAction);
            this.priority(model.priority);
            this.ruleId(model.ruleId);
            this.type(model.type);
        }

        public final WafAction.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        @Override
        public final Builder action(WafAction action) {
            this.action = action;
            return this;
        }

        public final void setAction(WafAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        public final Collection<WafExcludedRule.Builder> getExcludedRules() {
            return this.excludedRules != null ? (Collection)this.excludedRules.stream().map(WafExcludedRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder excludedRules(Collection<WafExcludedRule> excludedRules) {
            this.excludedRules = WafExcludedRuleListCopier.copy(excludedRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedRules(WafExcludedRule ... excludedRules) {
            this.excludedRules(Arrays.asList(excludedRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedRules(Consumer<WafExcludedRule.Builder> ... excludedRules) {
            this.excludedRules(Stream.of(excludedRules).map(c -> (WafExcludedRule)((WafExcludedRule.Builder)WafExcludedRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExcludedRules(Collection<WafExcludedRule.BuilderImpl> excludedRules) {
            this.excludedRules = WafExcludedRuleListCopier.copyFromBuilder(excludedRules);
        }

        public final WafOverrideAction.Builder getOverrideAction() {
            return this.overrideAction != null ? this.overrideAction.toBuilder() : null;
        }

        @Override
        public final Builder overrideAction(WafOverrideAction overrideAction) {
            this.overrideAction = overrideAction;
            return this;
        }

        public final void setOverrideAction(WafOverrideAction.BuilderImpl overrideAction) {
            this.overrideAction = overrideAction != null ? overrideAction.build() : null;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public AwsWafWebAclRule build() {
            return new AwsWafWebAclRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsWafWebAclRule> {
        public Builder action(WafAction var1);

        default public Builder action(Consumer<WafAction.Builder> action) {
            return this.action((WafAction)((WafAction.Builder)WafAction.builder().applyMutation(action)).build());
        }

        public Builder excludedRules(Collection<WafExcludedRule> var1);

        public Builder excludedRules(WafExcludedRule ... var1);

        public Builder excludedRules(Consumer<WafExcludedRule.Builder> ... var1);

        public Builder overrideAction(WafOverrideAction var1);

        default public Builder overrideAction(Consumer<WafOverrideAction.Builder> overrideAction) {
            return this.overrideAction((WafOverrideAction)((WafOverrideAction.Builder)WafOverrideAction.builder().applyMutation(overrideAction)).build());
        }

        public Builder priority(Integer var1);

        public Builder ruleId(String var1);

        public Builder type(String var1);
    }
}

