/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.NetworkDirection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Network
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Network> {
    private static final SdkField<String> DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Network.getter(Network::directionAsString)).setter(Network.setter(Builder::direction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Network.getter(Network::protocol)).setter(Network.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<String> SOURCE_IP_V4_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Network.getter(Network::sourceIpV4)).setter(Network.setter(Builder::sourceIpV4)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIpV4").build()}).build();
    private static final SdkField<String> SOURCE_IP_V6_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Network.getter(Network::sourceIpV6)).setter(Network.setter(Builder::sourceIpV6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIpV6").build()}).build();
    private static final SdkField<Integer> SOURCE_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Network.getter(Network::sourcePort)).setter(Network.setter(Builder::sourcePort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePort").build()}).build();
    private static final SdkField<String> SOURCE_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Network.getter(Network::sourceDomain)).setter(Network.setter(Builder::sourceDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDomain").build()}).build();
    private static final SdkField<String> SOURCE_MAC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Network.getter(Network::sourceMac)).setter(Network.setter(Builder::sourceMac)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceMac").build()}).build();
    private static final SdkField<String> DESTINATION_IP_V4_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Network.getter(Network::destinationIpV4)).setter(Network.setter(Builder::destinationIpV4)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIpV4").build()}).build();
    private static final SdkField<String> DESTINATION_IP_V6_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Network.getter(Network::destinationIpV6)).setter(Network.setter(Builder::destinationIpV6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIpV6").build()}).build();
    private static final SdkField<Integer> DESTINATION_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Network.getter(Network::destinationPort)).setter(Network.setter(Builder::destinationPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPort").build()}).build();
    private static final SdkField<String> DESTINATION_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Network.getter(Network::destinationDomain)).setter(Network.setter(Builder::destinationDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationDomain").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTION_FIELD, PROTOCOL_FIELD, SOURCE_IP_V4_FIELD, SOURCE_IP_V6_FIELD, SOURCE_PORT_FIELD, SOURCE_DOMAIN_FIELD, SOURCE_MAC_FIELD, DESTINATION_IP_V4_FIELD, DESTINATION_IP_V6_FIELD, DESTINATION_PORT_FIELD, DESTINATION_DOMAIN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String direction;
    private final String protocol;
    private final String sourceIpV4;
    private final String sourceIpV6;
    private final Integer sourcePort;
    private final String sourceDomain;
    private final String sourceMac;
    private final String destinationIpV4;
    private final String destinationIpV6;
    private final Integer destinationPort;
    private final String destinationDomain;

    private Network(BuilderImpl builder) {
        this.direction = builder.direction;
        this.protocol = builder.protocol;
        this.sourceIpV4 = builder.sourceIpV4;
        this.sourceIpV6 = builder.sourceIpV6;
        this.sourcePort = builder.sourcePort;
        this.sourceDomain = builder.sourceDomain;
        this.sourceMac = builder.sourceMac;
        this.destinationIpV4 = builder.destinationIpV4;
        this.destinationIpV6 = builder.destinationIpV6;
        this.destinationPort = builder.destinationPort;
        this.destinationDomain = builder.destinationDomain;
    }

    public NetworkDirection direction() {
        return NetworkDirection.fromValue(this.direction);
    }

    public String directionAsString() {
        return this.direction;
    }

    public String protocol() {
        return this.protocol;
    }

    public String sourceIpV4() {
        return this.sourceIpV4;
    }

    public String sourceIpV6() {
        return this.sourceIpV6;
    }

    public Integer sourcePort() {
        return this.sourcePort;
    }

    public String sourceDomain() {
        return this.sourceDomain;
    }

    public String sourceMac() {
        return this.sourceMac;
    }

    public String destinationIpV4() {
        return this.destinationIpV4;
    }

    public String destinationIpV6() {
        return this.destinationIpV6;
    }

    public Integer destinationPort() {
        return this.destinationPort;
    }

    public String destinationDomain() {
        return this.destinationDomain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIpV4());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIpV6());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePort());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceMac());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationIpV4());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationIpV6());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationDomain());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Network)) {
            return false;
        }
        Network other = (Network)obj;
        return Objects.equals(this.directionAsString(), other.directionAsString()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.sourceIpV4(), other.sourceIpV4()) && Objects.equals(this.sourceIpV6(), other.sourceIpV6()) && Objects.equals(this.sourcePort(), other.sourcePort()) && Objects.equals(this.sourceDomain(), other.sourceDomain()) && Objects.equals(this.sourceMac(), other.sourceMac()) && Objects.equals(this.destinationIpV4(), other.destinationIpV4()) && Objects.equals(this.destinationIpV6(), other.destinationIpV6()) && Objects.equals(this.destinationPort(), other.destinationPort()) && Objects.equals(this.destinationDomain(), other.destinationDomain());
    }

    public String toString() {
        return ToString.builder((String)"Network").add("Direction", (Object)this.directionAsString()).add("Protocol", (Object)this.protocol()).add("SourceIpV4", (Object)this.sourceIpV4()).add("SourceIpV6", (Object)this.sourceIpV6()).add("SourcePort", (Object)this.sourcePort()).add("SourceDomain", (Object)this.sourceDomain()).add("SourceMac", (Object)this.sourceMac()).add("DestinationIpV4", (Object)this.destinationIpV4()).add("DestinationIpV6", (Object)this.destinationIpV6()).add("DestinationPort", (Object)this.destinationPort()).add("DestinationDomain", (Object)this.destinationDomain()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Direction": {
                return Optional.ofNullable(clazz.cast(this.directionAsString()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "SourceIpV4": {
                return Optional.ofNullable(clazz.cast(this.sourceIpV4()));
            }
            case "SourceIpV6": {
                return Optional.ofNullable(clazz.cast(this.sourceIpV6()));
            }
            case "SourcePort": {
                return Optional.ofNullable(clazz.cast(this.sourcePort()));
            }
            case "SourceDomain": {
                return Optional.ofNullable(clazz.cast(this.sourceDomain()));
            }
            case "SourceMac": {
                return Optional.ofNullable(clazz.cast(this.sourceMac()));
            }
            case "DestinationIpV4": {
                return Optional.ofNullable(clazz.cast(this.destinationIpV4()));
            }
            case "DestinationIpV6": {
                return Optional.ofNullable(clazz.cast(this.destinationIpV6()));
            }
            case "DestinationPort": {
                return Optional.ofNullable(clazz.cast(this.destinationPort()));
            }
            case "DestinationDomain": {
                return Optional.ofNullable(clazz.cast(this.destinationDomain()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Network, T> g) {
        return obj -> g.apply((Network)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String direction;
        private String protocol;
        private String sourceIpV4;
        private String sourceIpV6;
        private Integer sourcePort;
        private String sourceDomain;
        private String sourceMac;
        private String destinationIpV4;
        private String destinationIpV6;
        private Integer destinationPort;
        private String destinationDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(Network model) {
            this.direction(model.direction);
            this.protocol(model.protocol);
            this.sourceIpV4(model.sourceIpV4);
            this.sourceIpV6(model.sourceIpV6);
            this.sourcePort(model.sourcePort);
            this.sourceDomain(model.sourceDomain);
            this.sourceMac(model.sourceMac);
            this.destinationIpV4(model.destinationIpV4);
            this.destinationIpV6(model.destinationIpV6);
            this.destinationPort(model.destinationPort);
            this.destinationDomain(model.destinationDomain);
        }

        public final String getDirectionAsString() {
            return this.direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(NetworkDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getSourceIpV4() {
            return this.sourceIpV4;
        }

        @Override
        public final Builder sourceIpV4(String sourceIpV4) {
            this.sourceIpV4 = sourceIpV4;
            return this;
        }

        public final void setSourceIpV4(String sourceIpV4) {
            this.sourceIpV4 = sourceIpV4;
        }

        public final String getSourceIpV6() {
            return this.sourceIpV6;
        }

        @Override
        public final Builder sourceIpV6(String sourceIpV6) {
            this.sourceIpV6 = sourceIpV6;
            return this;
        }

        public final void setSourceIpV6(String sourceIpV6) {
            this.sourceIpV6 = sourceIpV6;
        }

        public final Integer getSourcePort() {
            return this.sourcePort;
        }

        @Override
        public final Builder sourcePort(Integer sourcePort) {
            this.sourcePort = sourcePort;
            return this;
        }

        public final void setSourcePort(Integer sourcePort) {
            this.sourcePort = sourcePort;
        }

        public final String getSourceDomain() {
            return this.sourceDomain;
        }

        @Override
        public final Builder sourceDomain(String sourceDomain) {
            this.sourceDomain = sourceDomain;
            return this;
        }

        public final void setSourceDomain(String sourceDomain) {
            this.sourceDomain = sourceDomain;
        }

        public final String getSourceMac() {
            return this.sourceMac;
        }

        @Override
        public final Builder sourceMac(String sourceMac) {
            this.sourceMac = sourceMac;
            return this;
        }

        public final void setSourceMac(String sourceMac) {
            this.sourceMac = sourceMac;
        }

        public final String getDestinationIpV4() {
            return this.destinationIpV4;
        }

        @Override
        public final Builder destinationIpV4(String destinationIpV4) {
            this.destinationIpV4 = destinationIpV4;
            return this;
        }

        public final void setDestinationIpV4(String destinationIpV4) {
            this.destinationIpV4 = destinationIpV4;
        }

        public final String getDestinationIpV6() {
            return this.destinationIpV6;
        }

        @Override
        public final Builder destinationIpV6(String destinationIpV6) {
            this.destinationIpV6 = destinationIpV6;
            return this;
        }

        public final void setDestinationIpV6(String destinationIpV6) {
            this.destinationIpV6 = destinationIpV6;
        }

        public final Integer getDestinationPort() {
            return this.destinationPort;
        }

        @Override
        public final Builder destinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final void setDestinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
        }

        public final String getDestinationDomain() {
            return this.destinationDomain;
        }

        @Override
        public final Builder destinationDomain(String destinationDomain) {
            this.destinationDomain = destinationDomain;
            return this;
        }

        public final void setDestinationDomain(String destinationDomain) {
            this.destinationDomain = destinationDomain;
        }

        public Network build() {
            return new Network(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Network> {
        public Builder direction(String var1);

        public Builder direction(NetworkDirection var1);

        public Builder protocol(String var1);

        public Builder sourceIpV4(String var1);

        public Builder sourceIpV6(String var1);

        public Builder sourcePort(Integer var1);

        public Builder sourceDomain(String var1);

        public Builder sourceMac(String var1);

        public Builder destinationIpV4(String var1);

        public Builder destinationIpV6(String var1);

        public Builder destinationPort(Integer var1);

        public Builder destinationDomain(String var1);
    }
}

