/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceDetails;
import software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyDetails;
import software.amazon.awssdk.services.securityhub.model.AwsS3BucketDetails;
import software.amazon.awssdk.services.securityhub.model.ContainerDetails;
import software.amazon.awssdk.services.securityhub.model.FieldMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceDetails> {
    private static final SdkField<AwsEc2InstanceDetails> AWS_EC2_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsEc2Instance)).setter(ResourceDetails.setter(Builder::awsEc2Instance)).constructor(AwsEc2InstanceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2Instance").build()}).build();
    private static final SdkField<AwsS3BucketDetails> AWS_S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsS3Bucket)).setter(ResourceDetails.setter(Builder::awsS3Bucket)).constructor(AwsS3BucketDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsS3Bucket").build()}).build();
    private static final SdkField<AwsIamAccessKeyDetails> AWS_IAM_ACCESS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::awsIamAccessKey)).setter(ResourceDetails.setter(Builder::awsIamAccessKey)).constructor(AwsIamAccessKeyDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsIamAccessKey").build()}).build();
    private static final SdkField<ContainerDetails> CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ResourceDetails.getter(ResourceDetails::container)).setter(ResourceDetails.setter(Builder::container)).constructor(ContainerDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Container").build()}).build();
    private static final SdkField<Map<String, String>> OTHER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ResourceDetails.getter(ResourceDetails::other)).setter(ResourceDetails.setter(Builder::other)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Other").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_EC2_INSTANCE_FIELD, AWS_S3_BUCKET_FIELD, AWS_IAM_ACCESS_KEY_FIELD, CONTAINER_FIELD, OTHER_FIELD));
    private static final long serialVersionUID = 1L;
    private final AwsEc2InstanceDetails awsEc2Instance;
    private final AwsS3BucketDetails awsS3Bucket;
    private final AwsIamAccessKeyDetails awsIamAccessKey;
    private final ContainerDetails container;
    private final Map<String, String> other;

    private ResourceDetails(BuilderImpl builder) {
        this.awsEc2Instance = builder.awsEc2Instance;
        this.awsS3Bucket = builder.awsS3Bucket;
        this.awsIamAccessKey = builder.awsIamAccessKey;
        this.container = builder.container;
        this.other = builder.other;
    }

    public AwsEc2InstanceDetails awsEc2Instance() {
        return this.awsEc2Instance;
    }

    public AwsS3BucketDetails awsS3Bucket() {
        return this.awsS3Bucket;
    }

    public AwsIamAccessKeyDetails awsIamAccessKey() {
        return this.awsIamAccessKey;
    }

    public ContainerDetails container() {
        return this.container;
    }

    public boolean hasOther() {
        return this.other != null && !(this.other instanceof SdkAutoConstructMap);
    }

    public Map<String, String> other() {
        return this.other;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsEc2Instance());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsIamAccessKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.container());
        hashCode = 31 * hashCode + Objects.hashCode(this.other());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDetails)) {
            return false;
        }
        ResourceDetails other = (ResourceDetails)obj;
        return Objects.equals(this.awsEc2Instance(), other.awsEc2Instance()) && Objects.equals(this.awsS3Bucket(), other.awsS3Bucket()) && Objects.equals(this.awsIamAccessKey(), other.awsIamAccessKey()) && Objects.equals(this.container(), other.container()) && Objects.equals(this.other(), other.other());
    }

    public String toString() {
        return ToString.builder((String)"ResourceDetails").add("AwsEc2Instance", (Object)this.awsEc2Instance()).add("AwsS3Bucket", (Object)this.awsS3Bucket()).add("AwsIamAccessKey", (Object)this.awsIamAccessKey()).add("Container", (Object)this.container()).add("Other", this.other()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsEc2Instance": {
                return Optional.ofNullable(clazz.cast(this.awsEc2Instance()));
            }
            case "AwsS3Bucket": {
                return Optional.ofNullable(clazz.cast(this.awsS3Bucket()));
            }
            case "AwsIamAccessKey": {
                return Optional.ofNullable(clazz.cast(this.awsIamAccessKey()));
            }
            case "Container": {
                return Optional.ofNullable(clazz.cast(this.container()));
            }
            case "Other": {
                return Optional.ofNullable(clazz.cast(this.other()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDetails, T> g) {
        return obj -> g.apply((ResourceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AwsEc2InstanceDetails awsEc2Instance;
        private AwsS3BucketDetails awsS3Bucket;
        private AwsIamAccessKeyDetails awsIamAccessKey;
        private ContainerDetails container;
        private Map<String, String> other = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDetails model) {
            this.awsEc2Instance(model.awsEc2Instance);
            this.awsS3Bucket(model.awsS3Bucket);
            this.awsIamAccessKey(model.awsIamAccessKey);
            this.container(model.container);
            this.other(model.other);
        }

        public final AwsEc2InstanceDetails.Builder getAwsEc2Instance() {
            return this.awsEc2Instance != null ? this.awsEc2Instance.toBuilder() : null;
        }

        @Override
        public final Builder awsEc2Instance(AwsEc2InstanceDetails awsEc2Instance) {
            this.awsEc2Instance = awsEc2Instance;
            return this;
        }

        public final void setAwsEc2Instance(AwsEc2InstanceDetails.BuilderImpl awsEc2Instance) {
            this.awsEc2Instance = awsEc2Instance != null ? awsEc2Instance.build() : null;
        }

        public final AwsS3BucketDetails.Builder getAwsS3Bucket() {
            return this.awsS3Bucket != null ? this.awsS3Bucket.toBuilder() : null;
        }

        @Override
        public final Builder awsS3Bucket(AwsS3BucketDetails awsS3Bucket) {
            this.awsS3Bucket = awsS3Bucket;
            return this;
        }

        public final void setAwsS3Bucket(AwsS3BucketDetails.BuilderImpl awsS3Bucket) {
            this.awsS3Bucket = awsS3Bucket != null ? awsS3Bucket.build() : null;
        }

        public final AwsIamAccessKeyDetails.Builder getAwsIamAccessKey() {
            return this.awsIamAccessKey != null ? this.awsIamAccessKey.toBuilder() : null;
        }

        @Override
        public final Builder awsIamAccessKey(AwsIamAccessKeyDetails awsIamAccessKey) {
            this.awsIamAccessKey = awsIamAccessKey;
            return this;
        }

        public final void setAwsIamAccessKey(AwsIamAccessKeyDetails.BuilderImpl awsIamAccessKey) {
            this.awsIamAccessKey = awsIamAccessKey != null ? awsIamAccessKey.build() : null;
        }

        public final ContainerDetails.Builder getContainer() {
            return this.container != null ? this.container.toBuilder() : null;
        }

        @Override
        public final Builder container(ContainerDetails container) {
            this.container = container;
            return this;
        }

        public final void setContainer(ContainerDetails.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        public final Map<String, String> getOther() {
            return this.other;
        }

        @Override
        public final Builder other(Map<String, String> other) {
            this.other = FieldMapCopier.copy(other);
            return this;
        }

        public final void setOther(Map<String, String> other) {
            this.other = FieldMapCopier.copy(other);
        }

        public ResourceDetails build() {
            return new ResourceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceDetails> {
        public Builder awsEc2Instance(AwsEc2InstanceDetails var1);

        default public Builder awsEc2Instance(Consumer<AwsEc2InstanceDetails.Builder> awsEc2Instance) {
            return this.awsEc2Instance((AwsEc2InstanceDetails)((AwsEc2InstanceDetails.Builder)AwsEc2InstanceDetails.builder().applyMutation(awsEc2Instance)).build());
        }

        public Builder awsS3Bucket(AwsS3BucketDetails var1);

        default public Builder awsS3Bucket(Consumer<AwsS3BucketDetails.Builder> awsS3Bucket) {
            return this.awsS3Bucket((AwsS3BucketDetails)((AwsS3BucketDetails.Builder)AwsS3BucketDetails.builder().applyMutation(awsS3Bucket)).build());
        }

        public Builder awsIamAccessKey(AwsIamAccessKeyDetails var1);

        default public Builder awsIamAccessKey(Consumer<AwsIamAccessKeyDetails.Builder> awsIamAccessKey) {
            return this.awsIamAccessKey((AwsIamAccessKeyDetails)((AwsIamAccessKeyDetails.Builder)AwsIamAccessKeyDetails.builder().applyMutation(awsIamAccessKey)).build());
        }

        public Builder container(ContainerDetails var1);

        default public Builder container(Consumer<ContainerDetails.Builder> container) {
            return this.container((ContainerDetails)((ContainerDetails.Builder)ContainerDetails.builder().applyMutation(container)).build());
        }

        public Builder other(Map<String, String> var1);
    }
}

