/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSecretVersionStageRequest
extends SecretsManagerRequest
implements ToCopyableBuilder<Builder, UpdateSecretVersionStageRequest> {
    private final String secretId;
    private final String versionStage;
    private final String removeFromVersionId;
    private final String moveToVersionId;

    private UpdateSecretVersionStageRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.versionStage = builder.versionStage;
        this.removeFromVersionId = builder.removeFromVersionId;
        this.moveToVersionId = builder.moveToVersionId;
    }

    public String secretId() {
        return this.secretId;
    }

    public String versionStage() {
        return this.versionStage;
    }

    public String removeFromVersionId() {
        return this.removeFromVersionId;
    }

    public String moveToVersionId() {
        return this.moveToVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.secretId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionStage());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeFromVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.moveToVersionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecretVersionStageRequest)) {
            return false;
        }
        UpdateSecretVersionStageRequest other = (UpdateSecretVersionStageRequest)((Object)obj);
        return Objects.equals(this.secretId(), other.secretId()) && Objects.equals(this.versionStage(), other.versionStage()) && Objects.equals(this.removeFromVersionId(), other.removeFromVersionId()) && Objects.equals(this.moveToVersionId(), other.moveToVersionId());
    }

    public String toString() {
        return ToString.builder((String)"UpdateSecretVersionStageRequest").add("SecretId", (Object)this.secretId()).add("VersionStage", (Object)this.versionStage()).add("RemoveFromVersionId", (Object)this.removeFromVersionId()).add("MoveToVersionId", (Object)this.moveToVersionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecretId": {
                return Optional.ofNullable(clazz.cast(this.secretId()));
            }
            case "VersionStage": {
                return Optional.ofNullable(clazz.cast(this.versionStage()));
            }
            case "RemoveFromVersionId": {
                return Optional.ofNullable(clazz.cast(this.removeFromVersionId()));
            }
            case "MoveToVersionId": {
                return Optional.ofNullable(clazz.cast(this.moveToVersionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SecretsManagerRequest.BuilderImpl
    implements Builder {
        private String secretId;
        private String versionStage;
        private String removeFromVersionId;
        private String moveToVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecretVersionStageRequest model) {
            super(model);
            this.secretId(model.secretId);
            this.versionStage(model.versionStage);
            this.removeFromVersionId(model.removeFromVersionId);
            this.moveToVersionId(model.moveToVersionId);
        }

        public final String getSecretId() {
            return this.secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public final String getVersionStage() {
            return this.versionStage;
        }

        @Override
        public final Builder versionStage(String versionStage) {
            this.versionStage = versionStage;
            return this;
        }

        public final void setVersionStage(String versionStage) {
            this.versionStage = versionStage;
        }

        public final String getRemoveFromVersionId() {
            return this.removeFromVersionId;
        }

        @Override
        public final Builder removeFromVersionId(String removeFromVersionId) {
            this.removeFromVersionId = removeFromVersionId;
            return this;
        }

        public final void setRemoveFromVersionId(String removeFromVersionId) {
            this.removeFromVersionId = removeFromVersionId;
        }

        public final String getMoveToVersionId() {
            return this.moveToVersionId;
        }

        @Override
        public final Builder moveToVersionId(String moveToVersionId) {
            this.moveToVersionId = moveToVersionId;
            return this;
        }

        public final void setMoveToVersionId(String moveToVersionId) {
            this.moveToVersionId = moveToVersionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecretVersionStageRequest build() {
            return new UpdateSecretVersionStageRequest(this);
        }
    }

    public static interface Builder
    extends SecretsManagerRequest.Builder,
    CopyableBuilder<Builder, UpdateSecretVersionStageRequest> {
        public Builder secretId(String var1);

        public Builder versionStage(String var1);

        public Builder removeFromVersionId(String var1);

        public Builder moveToVersionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

