/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.benchmark.ec2;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.ElasticGpuSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.RunInstancesRequest;
import software.amazon.awssdk.services.ec2.model.VolumeType;

final class V2ItemFactory {
    private static final String ALPHA = "abcdefghijklmnopqrstuvwxyz";
    private static final Random RNG = new Random();

    V2ItemFactory() {
    }

    RunInstancesRequest tiny() {
        return (RunInstancesRequest)RunInstancesRequest.builder().additionalInfo(V2ItemFactory.randomS(50)).disableApiTermination(Boolean.valueOf(true)).maxCount(Integer.valueOf(5)).build();
    }

    RunInstancesRequest small() {
        return (RunInstancesRequest)RunInstancesRequest.builder().additionalInfo(V2ItemFactory.randomS(50)).disableApiTermination(Boolean.valueOf(true)).maxCount(Integer.valueOf(5)).blockDeviceMappings(V2ItemFactory.blockDeviceMappings(3)).cpuOptions(c -> c.coreCount(Integer.valueOf(5)).threadsPerCore(Integer.valueOf(5))).elasticGpuSpecification(new ElasticGpuSpecification[]{V2ItemFactory.elasticGpuSpecification()}).networkInterfaces(V2ItemFactory.networkInterfaces(3)).build();
    }

    RunInstancesRequest huge() {
        return (RunInstancesRequest)RunInstancesRequest.builder().additionalInfo(V2ItemFactory.randomS(50)).disableApiTermination(Boolean.valueOf(true)).maxCount(Integer.valueOf(5)).blockDeviceMappings(V2ItemFactory.blockDeviceMappings(100)).cpuOptions(c -> c.coreCount(Integer.valueOf(5)).threadsPerCore(Integer.valueOf(5))).elasticGpuSpecification(new ElasticGpuSpecification[]{V2ItemFactory.elasticGpuSpecification()}).networkInterfaces(V2ItemFactory.networkInterfaces(100)).build();
    }

    private static ElasticGpuSpecification elasticGpuSpecification() {
        return (ElasticGpuSpecification)ElasticGpuSpecification.builder().type(V2ItemFactory.randomS(50)).build();
    }

    private static InstanceNetworkInterfaceSpecification networkInterface() {
        return (InstanceNetworkInterfaceSpecification)InstanceNetworkInterfaceSpecification.builder().associatePublicIpAddress(Boolean.valueOf(true)).deleteOnTermination(Boolean.valueOf(true)).deviceIndex(Integer.valueOf(50)).groups(new String[]{V2ItemFactory.randomS(50), V2ItemFactory.randomS(50), V2ItemFactory.randomS(50)}).description(V2ItemFactory.randomS(50)).build();
    }

    private static List<InstanceNetworkInterfaceSpecification> networkInterfaces(int num) {
        return IntStream.of(num).mapToObj(i -> V2ItemFactory.networkInterface()).collect(Collectors.toList());
    }

    private static BlockDeviceMapping blockDeviceMapping() {
        return (BlockDeviceMapping)BlockDeviceMapping.builder().deviceName(V2ItemFactory.randomS(100)).virtualName(V2ItemFactory.randomS(50)).noDevice(V2ItemFactory.randomS(50)).ebs(e -> e.deleteOnTermination(Boolean.valueOf(true)).encrypted(Boolean.valueOf(false)).iops(Integer.valueOf(50)).kmsKeyId(V2ItemFactory.randomS(50)).snapshotId(V2ItemFactory.randomS(50)).volumeSize(Integer.valueOf(50)).volumeType(VolumeType.GP2)).build();
    }

    private static List<BlockDeviceMapping> blockDeviceMappings(int num) {
        return IntStream.of(num).mapToObj(i -> V2ItemFactory.blockDeviceMapping()).collect(Collectors.toList());
    }

    private static String randomS(int len) {
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(ALPHA.charAt(RNG.nextInt(ALPHA.length())));
        }
        return sb.toString();
    }
}

